import { MonacoCommands } from './monaco-commands';
import { MonacoLanguages } from "./monaco-languages";
import { MonacoWorkspace } from "./monaco-workspace";
import { ConsoleWindow } from "./console-window";
import { Services } from "./services";
export interface MonacoServices extends Services {
    commands: MonacoCommands;
    languages: MonacoLanguages;
    workspace: MonacoWorkspace;
    window: ConsoleWindow;
}
export declare namespace MonacoServices {
    interface Options {
        rootUri?: string;
    }
    type Provider = () => MonacoServices;
    function create(editor: monaco.editor.IStandaloneCodeEditor, options?: Options): MonacoServices;
    function install(editor: monaco.editor.IStandaloneCodeEditor, options?: Options): MonacoServices;
    function get(): MonacoServices;
}
//# sourceMappingURL=monaco-services.d.ts.map