import React from 'react';
import PrimaryButton from '../PrimaryButton';
import { shallow, mount } from 'enzyme';
import { iconSearch } from 'carbon-icons';
describe('PrimaryButton', function () {
  describe('Renders as expected', function () {
    var wrapper = shallow(React.createElement(PrimaryButton, {
      small: true,
      className: "extra-class"
    }, React.createElement("div", {
      className: "child"
    }, "Test"), React.createElement("div", {
      className: "child"
    }, "Test")));
    it('Renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(2);
      expect(wrapper.find('svg').length).toBe(0);
    });
    it('Renders wrapper as expected', function () {
      expect(wrapper.length).toBe(1);
    });
    it('Has the expected kind set to "primary"', function () {
      expect(wrapper.props().kind).toEqual('primary');
    });
    it('Has the expected small property set to true', function () {
      expect(wrapper.props().small).toEqual(true);
    });
    it('Should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
    describe('Renders icon buttons', function () {
      var iconButton = mount(React.createElement(PrimaryButton, {
        icon: iconSearch,
        iconDescription: "Search"
      }, "Search"));
      var icon = iconButton.find('svg');
      it('should have the appropriate icon', function () {
        expect(icon.hasClass('bx--btn__icon')).toBe(true);
      });
    });
  });
});