"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isEqual2 = _interopRequireDefault(require("lodash/isEqual"));

var _isFunction2 = _interopRequireDefault(require("lodash/isFunction"));

var _isArray2 = _interopRequireDefault(require("lodash/isArray"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactSmooth = _interopRequireDefault(require("react-smooth"));

var _Sector = _interopRequireDefault(require("../shape/Sector"));

var _Layer = _interopRequireDefault(require("../container/Layer"));

var _ReactUtils = require("../util/ReactUtils");

var _PureRender = _interopRequireDefault(require("../util/PureRender"));

var _LabelList = _interopRequireDefault(require("../component/LabelList"));

var _Cell = _interopRequireDefault(require("../component/Cell"));

var _DataUtils = require("../util/DataUtils");

var _ChartUtils = require("../util/ChartUtils");

var _class, _class2, _temp;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var RadialBar = (0, _PureRender.default)(_class = (_temp = _class2 =
/*#__PURE__*/
function (_Component) {
  _inherits(RadialBar, _Component);

  function RadialBar() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, RadialBar);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(RadialBar)).call.apply(_getPrototypeOf2, [this].concat(args)));
    _this.state = {
      isAnimationFinished: false
    };

    _this.cachePrevData = function (data) {
      _this.setState({
        prevData: data
      });
    };

    _this.handleAnimationEnd = function () {
      _this.setState({
        isAnimationFinished: true
      });
    };

    _this.handleAnimationStart = function () {
      _this.setState({
        isAnimationFinished: false
      });
    };

    return _this;
  }

  _createClass(RadialBar, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      var _this$props = this.props,
          animationId = _this$props.animationId,
          data = _this$props.data;

      if (nextProps.animationId !== animationId) {
        this.cachePrevData(data);
      }
    }
  }, {
    key: "getDeltaAngle",
    value: function getDeltaAngle() {
      var _this$props2 = this.props,
          startAngle = _this$props2.startAngle,
          endAngle = _this$props2.endAngle;
      var sign = (0, _DataUtils.mathSign)(endAngle - startAngle);
      var deltaAngle = Math.min(Math.abs(endAngle - startAngle), 360);
      return sign * deltaAngle;
    }
  }, {
    key: "renderSectorsStatically",
    value: function renderSectorsStatically(sectors) {
      var _this2 = this;

      var _this$props3 = this.props,
          shape = _this$props3.shape,
          activeShape = _this$props3.activeShape,
          activeIndex = _this$props3.activeIndex,
          cornerRadius = _this$props3.cornerRadius,
          others = _objectWithoutProperties(_this$props3, ["shape", "activeShape", "activeIndex", "cornerRadius"]);

      var baseProps = (0, _ReactUtils.getPresentationAttributes)(others);
      return sectors.map(function (entry, i) {
        var props = _objectSpread({}, baseProps, {
          cornerRadius: cornerRadius
        }, entry, (0, _ReactUtils.filterEventsOfChild)(_this2.props, entry, i), {
          key: "sector-".concat(i),
          className: 'recharts-radial-bar-sector'
        });

        return _this2.constructor.renderSectorShape(i === activeIndex ? activeShape : shape, props);
      });
    }
  }, {
    key: "renderSectorsWithAnimation",
    value: function renderSectorsWithAnimation() {
      var _this3 = this;

      var _this$props4 = this.props,
          data = _this$props4.data,
          isAnimationActive = _this$props4.isAnimationActive,
          animationBegin = _this$props4.animationBegin,
          animationDuration = _this$props4.animationDuration,
          animationEasing = _this$props4.animationEasing,
          animationId = _this$props4.animationId;
      var prevData = this.state.prevData;
      return _react.default.createElement(_reactSmooth.default, {
        begin: animationBegin,
        duration: animationDuration,
        isActive: isAnimationActive,
        easing: animationEasing,
        from: {
          t: 0
        },
        to: {
          t: 1
        },
        key: "radialBar-".concat(animationId),
        onAnimationStart: this.handleAnimationStart,
        onAnimationEnd: this.handleAnimationEnd
      }, function (_ref) {
        var t = _ref.t;
        var stepData = data.map(function (entry, index) {
          var prev = prevData && prevData[index];

          if (prev) {
            var interpolatorStartAngle = (0, _DataUtils.interpolateNumber)(prev.startAngle, entry.startAngle);
            var interpolatorEndAngle = (0, _DataUtils.interpolateNumber)(prev.endAngle, entry.endAngle);
            return _objectSpread({}, entry, {
              startAngle: interpolatorStartAngle(t),
              endAngle: interpolatorEndAngle(t)
            });
          }

          var endAngle = entry.endAngle,
              startAngle = entry.startAngle;
          var interpolator = (0, _DataUtils.interpolateNumber)(startAngle, endAngle);
          return _objectSpread({}, entry, {
            endAngle: interpolator(t)
          });
        });
        return _react.default.createElement(_Layer.default, null, _this3.renderSectorsStatically(stepData));
      });
    }
  }, {
    key: "renderSectors",
    value: function renderSectors() {
      var _this$props5 = this.props,
          data = _this$props5.data,
          isAnimationActive = _this$props5.isAnimationActive;
      var prevData = this.state.prevData;

      if (isAnimationActive && data && data.length && (!prevData || !(0, _isEqual2.default)(prevData, data))) {
        return this.renderSectorsWithAnimation();
      }

      return this.renderSectorsStatically(data);
    }
  }, {
    key: "renderBackground",
    value: function renderBackground(sectors) {
      var _this4 = this;

      var cornerRadius = this.props.cornerRadius;
      var backgroundProps = (0, _ReactUtils.getPresentationAttributes)(this.props.background);
      return sectors.map(function (entry, i) {
        // eslint-disable-next-line no-unused-vars
        var value = entry.value,
            background = entry.background,
            rest = _objectWithoutProperties(entry, ["value", "background"]);

        if (!background) {
          return null;
        }

        var props = _objectSpread({
          cornerRadius: cornerRadius
        }, rest, {
          fill: '#eee'
        }, background, backgroundProps, (0, _ReactUtils.filterEventsOfChild)(_this4.props, entry, i), {
          index: i,
          key: "sector-".concat(i),
          className: 'recharts-radial-bar-background-sector'
        });

        return _this4.constructor.renderSectorShape(background, props);
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props6 = this.props,
          hide = _this$props6.hide,
          data = _this$props6.data,
          className = _this$props6.className,
          background = _this$props6.background,
          isAnimationActive = _this$props6.isAnimationActive;

      if (hide || !data || !data.length) {
        return null;
      }

      var isAnimationFinished = this.state.isAnimationFinished;
      var layerClass = (0, _classnames.default)('recharts-area', className);
      return _react.default.createElement(_Layer.default, {
        className: layerClass
      }, background && _react.default.createElement(_Layer.default, {
        className: "recharts-radial-bar-background"
      }, this.renderBackground(data)), _react.default.createElement(_Layer.default, {
        className: "recharts-radial-bar-sectors"
      }, this.renderSectors(data)), (!isAnimationActive || isAnimationFinished) && _LabelList.default.renderCallByParent(_objectSpread({}, this.props, {
        clockWise: this.getDeltaAngle() < 0
      }), data));
    }
  }], [{
    key: "renderSectorShape",
    value: function renderSectorShape(shape, props) {
      var sectorShape;

      if (_react.default.isValidElement(shape)) {
        sectorShape = _react.default.cloneElement(shape, props);
      } else if ((0, _isFunction2.default)(shape)) {
        sectorShape = shape(props);
      } else {
        sectorShape = _react.default.createElement(_Sector.default, props);
      }

      return sectorShape;
    }
  }]);

  return RadialBar;
}(_react.Component), _class2.displayName = 'RadialBar', _class2.propTypes = _objectSpread({}, _ReactUtils.PRESENTATION_ATTRIBUTES, {
  className: _propTypes.default.string,
  angleAxisId: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  radiusAxisId: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  shape: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.element]),
  activeShape: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.func, _propTypes.default.element]),
  activeIndex: _propTypes.default.number,
  dataKey: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.func]).isRequired,
  cornerRadius: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  minPointSize: _propTypes.default.number,
  maxBarSize: _propTypes.default.number,
  data: _propTypes.default.arrayOf(_propTypes.default.shape({
    cx: _propTypes.default.number,
    cy: _propTypes.default.number,
    innerRadius: _propTypes.default.number,
    outerRadius: _propTypes.default.number,
    value: _propTypes.default.value
  })),
  legendType: _propTypes.default.oneOf(_ReactUtils.LEGEND_TYPES),
  label: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.func, _propTypes.default.element, _propTypes.default.object]),
  background: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.func, _propTypes.default.object, _propTypes.default.element]),
  hide: _propTypes.default.bool,
  onMouseEnter: _propTypes.default.func,
  onMouseLeave: _propTypes.default.func,
  onClick: _propTypes.default.func,
  isAnimationActive: _propTypes.default.bool,
  animationBegin: _propTypes.default.number,
  animationDuration: _propTypes.default.number,
  animationEasing: _propTypes.default.oneOf(['ease', 'ease-in', 'ease-out', 'ease-in-out', 'linear', 'spring'])
}), _class2.defaultProps = {
  angleAxisId: 0,
  radiusAxisId: 0,
  minPointSize: 0,
  hide: false,
  legendType: 'rect',
  data: [],
  isAnimationActive: !(0, _ReactUtils.isSsr)(),
  animationBegin: 0,
  animationDuration: 1500,
  animationEasing: 'ease'
}, _class2.getComposedData = function (_ref2) {
  var item = _ref2.item,
      props = _ref2.props,
      radiusAxis = _ref2.radiusAxis,
      radiusAxisTicks = _ref2.radiusAxisTicks,
      angleAxis = _ref2.angleAxis,
      angleAxisTicks = _ref2.angleAxisTicks,
      displayedData = _ref2.displayedData,
      dataKey = _ref2.dataKey,
      stackedData = _ref2.stackedData,
      barPosition = _ref2.barPosition,
      bandSize = _ref2.bandSize,
      dataStartIndex = _ref2.dataStartIndex;
  var pos = (0, _ChartUtils.findPositionOfBar)(barPosition, item);

  if (!pos) {
    return [];
  }

  var cx = angleAxis.cx,
      cy = angleAxis.cy;
  var layout = props.layout;
  var _item$props = item.props,
      children = _item$props.children,
      minPointSize = _item$props.minPointSize;
  var numericAxis = layout === 'radial' ? angleAxis : radiusAxis;
  var stackedDomain = stackedData ? numericAxis.scale.domain() : null;
  var baseValue = (0, _ChartUtils.getBaseValueOfBar)({
    props: props,
    numericAxis: numericAxis
  });
  var cells = (0, _ReactUtils.findAllByType)(children, _Cell.default);
  var sectors = displayedData.map(function (entry, index) {
    var value, innerRadius, outerRadius, startAngle, endAngle, backgroundSector;

    if (stackedData) {
      value = (0, _ChartUtils.truncateByDomain)(stackedData[dataStartIndex + index], stackedDomain);
    } else {
      value = (0, _ChartUtils.getValueByDataKey)(entry, dataKey);

      if (!(0, _isArray2.default)(value)) {
        value = [baseValue, value];
      }
    }

    if (layout === 'radial') {
      innerRadius = (0, _ChartUtils.getCateCoordinateOfBar)({
        axis: radiusAxis,
        ticks: radiusAxisTicks,
        bandSize: bandSize,
        offset: pos.offset,
        entry: entry,
        index: index
      });
      endAngle = angleAxis.scale(value[1]);
      startAngle = angleAxis.scale(value[0]);
      outerRadius = innerRadius + pos.size;
      var deltaAngle = endAngle - startAngle;

      if (Math.abs(minPointSize) > 0 && Math.abs(deltaAngle) < Math.abs(minPointSize)) {
        var delta = (0, _DataUtils.mathSign)(deltaAngle || minPointSize) * (Math.abs(minPointSize) - Math.abs(deltaAngle));
        endAngle += delta;
      }

      backgroundSector = {
        background: {
          cx: cx,
          cy: cy,
          innerRadius: innerRadius,
          outerRadius: outerRadius,
          startAngle: props.startAngle,
          endAngle: props.endAngle
        }
      };
    } else {
      innerRadius = radiusAxis.scale(value[0]);
      outerRadius = radiusAxis.scale(value[1]);
      startAngle = (0, _ChartUtils.getCateCoordinateOfBar)({
        axis: angleAxis,
        ticks: angleAxisTicks,
        bandSize: bandSize,
        offset: pos.offset,
        entry: entry,
        index: index
      });
      endAngle = startAngle + pos.size;
      var deltaRadius = outerRadius - innerRadius;

      if (Math.abs(minPointSize) > 0 && Math.abs(deltaRadius) < Math.abs(minPointSize)) {
        var _delta = (0, _DataUtils.mathSign)(deltaRadius || minPointSize) * (Math.abs(minPointSize) - Math.abs(deltaRadius));

        outerRadius += _delta;
      }
    }

    return _objectSpread({}, entry, backgroundSector, {
      payload: entry,
      value: stackedData ? value : value[1],
      cx: cx,
      cy: cy,
      innerRadius: innerRadius,
      outerRadius: outerRadius,
      startAngle: startAngle,
      endAngle: endAngle
    }, cells && cells[index] && cells[index].props);
  });
  return {
    data: sectors,
    layout: layout
  };
}, _temp)) || _class;

var _default = RadialBar;
exports.default = _default;