import { WorkspaceFolder as VWorkspaceFolder, WorkspaceFoldersChangeEvent as VWorkspaceFoldersChangeEvent } from 'vscode';
import { DynamicFeature, RegistrationData, BaseLanguageClient, NextSignature } from './client';
import { ClientCapabilities, InitializeParams, RPCMessageType, ServerCapabilities, WorkspaceFoldersRequest } from 'vscode-languageserver-protocol';
export declare function arrayDiff<T>(left: T[], right: T[]): T[];
export interface WorkspaceFolderWorkspaceMiddleware {
    workspaceFolders?: WorkspaceFoldersRequest.MiddlewareSignature;
    didChangeWorkspaceFolders?: NextSignature<VWorkspaceFoldersChangeEvent, void>;
}
export declare class WorkspaceFoldersFeature implements DynamicFeature<undefined> {
    private _client;
    private _listeners;
    private _initialFolders;
    constructor(_client: BaseLanguageClient);
    get messages(): RPCMessageType;
    fillInitializeParams(params: InitializeParams): void;
    protected initializeWithFolders(currentWorkspaceFolders: VWorkspaceFolder[] | undefined): void;
    fillClientCapabilities(capabilities: ClientCapabilities): void;
    initialize(capabilities: ServerCapabilities): void;
    protected sendInitialEvent(currentWorkspaceFolders: VWorkspaceFolder[] | undefined): void;
    private doSendEvent;
    register(_message: RPCMessageType, data: RegistrationData<undefined>): void;
    unregister(id: string): void;
    dispose(): void;
    private asProtocol;
}
