"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _NumberInput = _interopRequireDefault(require("../NumberInput"));

var _NumberInput2 = _interopRequireDefault(require("../NumberInput/NumberInput.Skeleton"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var props = function props() {
  return {
    className: 'some-class',
    id: 'tj-input',
    label: (0, _addonKnobs.text)('Label (label)', 'Number Input label'),
    hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel)', false),
    min: (0, _addonKnobs.number)('Minimum value (min)', 0),
    max: (0, _addonKnobs.number)('Maximum value (max)', 100),
    value: (0, _addonKnobs.number)('Value (value)', 50),
    step: (0, _addonKnobs.number)('Step of up/down arrow (step)', 10),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    readOnly: (0, _addonKnobs.boolean)('Read only (readOnly)', false),
    invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid)', false),
    isMobile: (0, _addonKnobs.boolean)('Mobile variant', false),
    invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText)', 'Number is not valid'),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text.'),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    onChange: (0, _addonActions.action)('onChange'),
    onClick: (0, _addonActions.action)('onClick'),
    allowEmpty: (0, _addonKnobs.boolean)('Allow empty value (allowEmpty)', false),
    numberInputArrowTranslationIds: (0, _addonKnobs.object)('Number input arrow icon translation IDs (for translateWithId callback)', {
      'increment.number': 'Increment number',
      'decrement.number': 'Decrement number'
    })
  };
};

_NumberInput.default.displayName = 'NumberInput';
(0, _react2.storiesOf)('NumberInput', module).addDecorator(_addonKnobs.withKnobs).add('Default', function () {
  var _props = props(),
      numberInputArrowTranslationIds = _props.numberInputArrowTranslationIds,
      rest = _objectWithoutProperties(_props, ["numberInputArrowTranslationIds"]);

  return _react.default.createElement(_NumberInput.default, _extends({
    translateWithId: function translateWithId(id) {
      return numberInputArrowTranslationIds[id];
    }
  }, rest));
}, {
  info: {
    text: "\n            Number inputs are similar to text fields, but contain controls used to increase or decrease an incremental value.\n            The Number Input component can be passed a starting value, a min, a max, and the step.\n          "
  }
}).add('skeleton', function () {
  return _react.default.createElement("div", {
    "aria-label": "loading number input",
    "aria-live": "assertive",
    role: "status",
    tabindex: "0" // eslint-disable-line jsx-a11y/no-noninteractive-tabindex

  }, _react.default.createElement(_NumberInput2.default, null));
}, {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n          "
  }
});