function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, number, select, text } from '@storybook/addon-knobs';
import { default as Accordion, AccordionItem, AccordionSkeleton } from '../Accordion';
import Button from '../Button';
var props = {
  onClick: action('onClick'),
  onHeadingClick: action('onHeadingClick')
};
storiesOf('Accordion', module).addDecorator(withKnobs).add('Default', function () {
  return React.createElement(Accordion, {
    align: select('Accordion heading alignment (align)', ['start', 'end'], 'end')
  }, React.createElement(AccordionItem, _extends({
    title: text('The title (title)', 'Section 1 title'),
    open: boolean('Open the section (open)', false)
  }, props), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), React.createElement(AccordionItem, _extends({
    title: "Section 2 title"
  }, props), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), React.createElement(AccordionItem, _extends({
    title: "Section 3 title"
  }, props), React.createElement(Button, null, "This is a button.")), React.createElement(AccordionItem, _extends({
    title: React.createElement("span", null, "Section 4 title (", React.createElement("em", null, "the title can be a node"), ")")
  }, props), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")));
}, {
  info: {
    text: "\n          Accordions allow users to expand and collapse sections of content.\n        "
  }
}).add('skeleton', function () {
  return React.createElement("div", {
    style: {
      width: '500px'
    }
  }, React.createElement(AccordionSkeleton, {
    align: select('Accordion heading alignment (align)', ['start', 'end'], 'end'),
    open: boolean('Show first item opened (open)', true),
    count: number('Set number of items (count)', 4)
  }));
}, {
  info: {
    text: "\n          Accordions allow users to expand and collapse sections of content.\n        "
  }
});