"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
const client_1 = require("vscode-languageclient/lib/client");
const typeDefinition_1 = require("vscode-languageclient/lib/typeDefinition");
const configuration_1 = require("vscode-languageclient/lib/configuration");
const implementation_1 = require("vscode-languageclient/lib/implementation");
const colorProvider_1 = require("vscode-languageclient/lib/colorProvider");
const workspaceFolders_1 = require("vscode-languageclient/lib/workspaceFolders");
const foldingRange_1 = require("vscode-languageclient/lib/foldingRange");
const declaration_1 = require("vscode-languageclient/lib/declaration");
__export(require("vscode-languageclient/lib/client"));
class MonacoLanguageClient extends client_1.BaseLanguageClient {
    constructor({ id, name, clientOptions, connectionProvider }) {
        super(id || name.toLowerCase(), name, clientOptions);
        this.connectionProvider = connectionProvider;
        this.createConnection = this.doCreateConnection.bind(this);
        // bypass LSP <=> VS Code conversion
        const self = this;
        self._p2c = new Proxy(self._p2c, {
            get: (target, prop) => {
                if (prop === 'asUri') {
                    return target[prop];
                }
                return MonacoLanguageClient.bypassConversion;
            }
        });
        self._c2p = new Proxy(self._c2p, {
            get: (target, prop) => {
                if (prop === 'asUri') {
                    return target[prop];
                }
                if (prop === 'asCompletionParams') {
                    return (textDocument, position, context) => {
                        return {
                            textDocument: target.asTextDocumentIdentifier(textDocument),
                            position,
                            context
                        };
                    };
                }
                if (prop === 'asWillSaveTextDocumentParams') {
                    return (event) => {
                        return {
                            textDocument: target.asTextDocumentIdentifier(event.document),
                            reason: event.reason
                        };
                    };
                }
                if (prop.endsWith('Params')) {
                    return target[prop];
                }
                return MonacoLanguageClient.bypassConversion;
            }
        });
    }
    doCreateConnection() {
        const errorHandler = this.handleConnectionError.bind(this);
        const closeHandler = this.handleConnectionClosed.bind(this);
        return this.connectionProvider.get(errorHandler, closeHandler, this.outputChannel);
    }
    createMessageTransports(encoding) {
        throw new Error('Unsupported');
    }
    registerBuiltinFeatures() {
        super.registerBuiltinFeatures();
        this.registerFeature(new configuration_1.ConfigurationFeature(this));
        this.registerFeature(new typeDefinition_1.TypeDefinitionFeature(this));
        this.registerFeature(new implementation_1.ImplementationFeature(this));
        this.registerFeature(new colorProvider_1.ColorProviderFeature(this));
        this.registerFeature(new workspaceFolders_1.WorkspaceFoldersFeature(this));
        const foldingRangeFeature = new foldingRange_1.FoldingRangeFeature(this);
        foldingRangeFeature['asFoldingRanges'] = MonacoLanguageClient.bypassConversion;
        this.registerFeature(foldingRangeFeature);
        this.registerFeature(new declaration_1.DeclarationFeature(this));
        const features = this['_features'];
        for (const feature of features) {
            if (feature instanceof colorProvider_1.ColorProviderFeature) {
                feature['asColor'] = MonacoLanguageClient.bypassConversion;
                feature['asColorInformations'] = MonacoLanguageClient.bypassConversion;
                feature['asColorPresentations'] = MonacoLanguageClient.bypassConversion;
            }
        }
    }
}
exports.MonacoLanguageClient = MonacoLanguageClient;
MonacoLanguageClient.bypassConversion = (result) => result || undefined;
//# sourceMappingURL=monaco-language-client.js.map