"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Modal = _interopRequireDefault(require("../Modal"));

var _TextInput = _interopRequireDefault(require("../TextInput"));

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
var sizes = {
  Default: '',
  'Extra small (xs)': 'xs',
  'Small (sm)': 'sm',
  'Large (lg)': 'lg'
};

var props = function props() {
  return {
    className: 'some-class',
    open: (0, _addonKnobs.boolean)('Open (open)', true),
    passiveModal: (0, _addonKnobs.boolean)('Without footer (passiveModal)', false),
    danger: (0, _addonKnobs.boolean)('Danger mode (danger)', false),
    shouldSubmitOnEnter: (0, _addonKnobs.boolean)('Enter key to submit (shouldSubmitOnEnter)', false),
    focusTrap: (0, _addonKnobs.boolean)('Trap focus (focusTrap)', false),
    hasScrollingContent: (0, _addonKnobs.boolean)('Modal contains scrollable content (hasScrollingContent)', false),
    modalHeading: (0, _addonKnobs.text)('Modal heading (modalHeading)', 'Modal heading'),
    modalLabel: (0, _addonKnobs.text)('Optional label (modalLabel)', 'Label'),
    modalAriaLabel: (0, _addonKnobs.text)('ARIA label, used only if modalLabel not provided (modalAriaLabel)', 'A label to be read by screen readers on the modal root node'),
    primaryButtonText: (0, _addonKnobs.text)('Primary button text (primaryButtonText)', 'Primary Button'),
    secondaryButtonText: (0, _addonKnobs.text)('Secondary button text (secondaryButtonText)', 'Secondary Button'),
    selectorPrimaryFocus: (0, _addonKnobs.text)('Primary focus element selector (selectorPrimaryFocus)', '[data-modal-primary-focus]'),
    size: (0, _addonKnobs.select)('Size (size)', sizes),
    iconDescription: (0, _addonKnobs.text)('Close icon description (iconDescription)', 'Close the modal'),
    onBlur: (0, _addonActions.action)('onBlur'),
    onClick: (0, _addonActions.action)('onClick'),
    onFocus: (0, _addonActions.action)('onFocus'),
    onRequestClose: (0, _addonActions.action)('onRequestClose'),
    onRequestSubmit: (0, _addonActions.action)('onRequestSubmit'),
    onSecondarySubmit: (0, _addonActions.action)('onSecondarySubmit')
  };
};

var titleOnlyProps = function titleOnlyProps() {
  var passiveModal = (0, _addonKnobs.boolean)('Without footer (passiveModal)', false);
  return {
    className: 'some-class',
    open: (0, _addonKnobs.boolean)('Open (open)', true),
    passiveModal: passiveModal,
    danger: !passiveModal && (0, _addonKnobs.boolean)('Danger mode (danger)', false),
    modalHeading: (0, _addonKnobs.text)('Modal heading (modalHeading)', "\n      Passive modal title as the message. Should be direct and 3 lines or less.\n    ".trim()),
    modalAriaLabel: (0, _addonKnobs.text)('ARIA label, used only if modalLabel not provided (modalAriaLabel)', 'A label to be read by screen readers on the modal root node'),
    primaryButtonText: (0, _addonKnobs.text)('Primary button text (primaryButtonText)', 'Primary Button'),
    secondaryButtonText: (0, _addonKnobs.text)('Secondary button text (secondaryButtonText)', 'Secondary Button'),
    size: (0, _addonKnobs.select)('Size (size)', sizes, 'sm'),
    iconDescription: (0, _addonKnobs.text)('Close icon description (iconDescription)', 'Close the modal'),
    onBlur: (0, _addonActions.action)('onBlur'),
    onClick: (0, _addonActions.action)('onClick'),
    onFocus: (0, _addonActions.action)('onFocus'),
    onRequestClose: (0, _addonActions.action)('onRequestClose')
  };
};

(0, _react2.storiesOf)('Modal', module).addDecorator(_addonKnobs.withKnobs).add('Default', function () {
  var _props = props(),
      size = _props.size,
      rest = _objectWithoutProperties(_props, ["size"]);

  return _react.default.createElement(_Modal.default, _extends({}, rest, {
    size: size || undefined
  }), _react.default.createElement("p", {
    className: "".concat(prefix, "--modal-content__text")
  }, "Please see ModalWrapper for more examples and demo of the functionality."), rest.hasScrollingContent && _react.default.createElement(_react.default.Fragment, null, _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("h3", null, "Lorem ipsum"), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), _react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' ')));
}, {
  info: {
    text: "\n            Modals communicate information via a secondary window and allow the user to maintain the context of a particular task.\n            Use the Modal Wrapper component to encapsulate your Modal within a button.\n          "
  }
}).add('Title only', function () {
  var _titleOnlyProps = titleOnlyProps(),
      size = _titleOnlyProps.size,
      rest = _objectWithoutProperties(_titleOnlyProps, ["size"]);

  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_Modal.default, _extends({}, rest, {
    size: size || undefined
  })));
}, {
  info: {
    text: "\n          In \"small\" and \"xs\" modals size, the title is allowed to span multiple lines and be used for the main message.\n          It should be less than 3 lines of text. If more room is required then use the standard body copy format.\n        "
  }
}).add('Trap Focus', function () {
  var _props2 = props(),
      size = _props2.size,
      rest = _objectWithoutProperties(_props2, ["size"]);

  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_Modal.default, _extends({}, rest, {
    hasForm: true,
    size: size || undefined,
    selectorPrimaryFocus: "#text-input-2"
  }), _react.default.createElement(_TextInput.default, {
    id: "text-input-1",
    labelText: "Text Input 1",
    placeholder: "Enter text...",
    style: {
      marginBottom: '1rem'
    }
  }), _react.default.createElement(_TextInput.default, {
    id: "text-input-2",
    labelText: "Text Input 2",
    placeholder: "Enter text..."
  })));
}, {
  info: {
    text: "\n            Specify a selector for the primary element to focus when opening a modal.\n          "
  }
});