"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Copy;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _lodash = _interopRequireDefault(require("lodash.debounce"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _events = require("../../tools/events");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function Copy(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      feedback = _ref.feedback,
      feedbackTimeout = _ref.feedbackTimeout,
      onAnimationEnd = _ref.onAnimationEnd,
      onClick = _ref.onClick,
      other = _objectWithoutProperties(_ref, ["children", "className", "feedback", "feedbackTimeout", "onAnimationEnd", "onClick"]);

  var _useState = (0, _react.useState)(''),
      _useState2 = _slicedToArray(_useState, 2),
      animation = _useState2[0],
      setAnimation = _useState2[1];

  var classNames = (0, _classnames2.default)(className, (_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--copy-btn--animating"), animation), _defineProperty(_classnames, "".concat(prefix, "--copy-btn--").concat(animation), animation), _classnames));
  var handleFadeOut = (0, _react.useCallback)((0, _lodash.default)(function () {
    setAnimation('fade-out');
  }, feedbackTimeout), [feedbackTimeout]);
  var handleClick = (0, _react.useCallback)(function () {
    setAnimation('fade-in');
    handleFadeOut();
  }, [handleFadeOut]);

  var handleAnimationEnd = function handleAnimationEnd(event) {
    if (event.animationName === 'hide-feedback') {
      setAnimation('');
    }
  };

  (0, _react.useEffect)(function () {
    return function () {
      handleFadeOut.cancel();
    };
  }, [handleFadeOut]);
  return _react.default.createElement("button", _extends({
    type: "button",
    className: classNames,
    onClick: (0, _events.composeEventHandlers)([onClick, handleClick]),
    onAnimationEnd: (0, _events.composeEventHandlers)([onAnimationEnd, handleAnimationEnd])
  }, other), children, _react.default.createElement("span", {
    className: "".concat(prefix, "--assistive-text ").concat(prefix, "--copy-btn__feedback")
  }, feedback));
}

Copy.propTypes = {
  /**
   * Pass in content to be rendred in the underlying <button>
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the underlying <button>
   */
  className: _propTypes.default.string,

  /**
   * Specify the string that is displayed when the button is clicked and the
   * content is copied
   */
  feedback: _propTypes.default.string,

  /**
   * Specify the time it takes for the feedback message to timeout
   */
  feedbackTimeout: _propTypes.default.number,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * <button> is clicked
   */
  onClick: _propTypes.default.func
};
Copy.defaultProps = {
  feedback: 'Copied!',
  feedbackTimeout: 2000,
  onClick: function onClick() {}
};