"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmHeaderPrototype = void 0;
/* istanbul ignore file */
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var styles_1 = require("@material-ui/styles");
var RHACM_Logo_svg_1 = __importDefault(require("../assets/RHACM-Logo.svg"));
function api(url, headers) {
    if (headers) {
        return fetch(url, headers).then(function (response) {
            if (!response.ok) {
                throw new Error(response.statusText);
            }
            return response.json();
        });
    }
    return fetch(url).then(function (response) {
        if (!response.ok) {
            throw new Error(response.statusText);
        }
        return response.json();
    });
}
function DropdownName() {
    var _a = react_1.useState(''), name = _a[0], setName = _a[1];
    react_1.useEffect(function () {
        var dev = process.env.NODE_ENV !== 'production';
        var serverForTest = dev ? 'https://localhost:3000' : '';
        api(serverForTest + "/multicloud/common/username")
            .then(function (_a) {
            var username = _a.username;
            setName(username);
        })
            .catch(function (error) {
            // eslint-disable-next-line no-console
            console.error(error);
            setName('');
        });
    }, []);
    return react_1.default.createElement("span", { "aria-label": "dropdown-username" }, name);
}
function AboutModalVersion() {
    var _a = react_1.useState('undefined'), version = _a[0], setVersion = _a[1];
    react_1.useEffect(function () {
        var dev = process.env.NODE_ENV !== 'production';
        var serverForTest = dev ? 'https://localhost:3000' : '';
        api(serverForTest + "/multicloud/common/version")
            .then(function (_a) {
            var version = _a.version;
            setVersion(version);
        })
            .catch(function (error) {
            // eslint-disable-next-line no-console
            console.error(error);
            setVersion('undefined');
        });
    }, []);
    return react_1.default.createElement("span", { className: "version-details__no" }, version === 'undefined' ? react_1.default.createElement(react_core_1.Spinner, { size: "md" }) : version);
}
var useStyles = styles_1.makeStyles({
    list: {
        '& li.pf-c-nav__item.pf-m-expandable.pf-m-expanded': {
            '& section': {
                display: 'list-item',
            },
        },
        '& li.pf-c-nav__item.pf-m-expandable': {
            '& section': {
                display: 'none',
            },
        },
    },
});
function NavExpandableList(props) {
    var navData = {
        home: {
            path: '/multicloud/welcome',
            groupId: 'home',
            itemId: 'home_welcome',
            name: 'Home',
        },
        overview: {
            path: '/multicloud/overview',
            groupId: 'observe',
            itemId: 'observe_overview',
            name: 'Overview',
        },
        clusters: {
            path: '/multicloud/clusters',
            groupId: 'automate',
            itemId: 'automate_clusters',
            name: 'Clusters',
        },
        baremetal: {
            path: '/multicloud/bare-metal-assets',
            groupId: 'automate',
            itemId: 'automate_baremetal',
            name: 'Bare metal assets',
        },
        applications: {
            path: '/multicloud/applications',
            groupId: 'manage',
            itemId: 'manage_applications',
            name: 'Manage applications',
        },
        grc: {
            path: '/multicloud/policies',
            groupId: 'grc',
            itemId: 'grc_govern_risk',
            name: 'Govern risk',
        },
    };
    var pathname = props.urlpath;
    var currentGroup = '';
    var currentItem = '';
    Object.keys(navData).forEach(function (key) {
        var n = navData[key];
        if (pathname && pathname.indexOf(n.path) !== -1) {
            currentGroup = n.groupId;
            currentItem = n.itemId;
        }
    });
    var _a = react_1.useState(currentGroup), activeGroup = _a[0], setActiveGroup = _a[1];
    var _b = react_1.useState(currentItem), activeItem = _b[0], setActiveItem = _b[1];
    var _c = react_1.useState(false), switcherIsOpen = _c[0], switcherSetOpen = _c[1];
    var classes = useStyles();
    function select(result) {
        if (result.groupId !== undefined) {
            setActiveGroup(result.groupId.toString());
        }
        if (result.itemId !== undefined) {
            setActiveItem(result.itemId.toString());
        }
    }
    function launchToOCP(searchParam) {
        api('/multicloud/api/v1/namespaces/openshift-config-managed/configmaps/console-public')
            .then(function (_a) {
            var data = _a.data;
            window.open("" + data.consoleURL + searchParam, '_self');
        })
            .catch(function (error) {
            // eslint-disable-next-line no-console
            console.error(error);
        });
    }
    function SidebarNavItem(props) {
        var data = props.data;
        return (react_1.default.createElement(react_core_1.NavItem, { preventDefault: true, groupId: data.groupId, itemId: data.itemId, isActive: activeItem === data.itemId, onClick: function () { return window.open(data.path, '_self'); } }, data.name));
    }
    var toggleStyles = {
        color: 'white',
    };
    return (react_1.default.createElement(react_core_1.Nav, { onSelect: select },
        react_1.default.createElement(react_core_1.Dropdown, { toggle: react_1.default.createElement(react_core_1.DropdownToggle, { id: "toggle-perspective", onToggle: function () { return switcherSetOpen(!switcherIsOpen); } },
                react_1.default.createElement("span", { style: toggleStyles }, "Advanced Cluster Management")), dropdownItems: [
                react_1.default.createElement(react_core_1.DropdownItem, { onClick: function () { return launchToOCP(''); }, key: 'administrator' }, "Administrator"),
                react_1.default.createElement(react_core_1.DropdownItem, { onClick: function () { return launchToOCP(''); }, key: 'devbutton' }, "Developer"),
            ], isOpen: switcherIsOpen }),
        react_1.default.createElement(react_core_1.NavItemSeparator, null),
        react_1.default.createElement(react_core_1.NavList, { className: classes.list },
            react_1.default.createElement(SidebarNavItem, { data: navData.home }),
            react_1.default.createElement(react_core_1.NavExpandable, { title: "Observe Environments", groupId: "observe", isActive: activeGroup === 'observe', isExpanded: activeGroup === 'observe' },
                react_1.default.createElement(SidebarNavItem, { data: navData.overview })),
            react_1.default.createElement(react_core_1.NavExpandable, { title: "Automate Infrastructure", groupId: "automate", isActive: activeGroup === 'automate', isExpanded: activeGroup === 'automate' },
                react_1.default.createElement(SidebarNavItem, { data: navData.clusters }),
                react_1.default.createElement(SidebarNavItem, { data: navData.baremetal })),
            react_1.default.createElement(SidebarNavItem, { data: navData.applications }),
            react_1.default.createElement(SidebarNavItem, { data: navData.grc }))));
}
function AcmHeaderPrototype(props) {
    var _a = react_1.useState(true), isOpen = _a[0], setOpen = _a[1];
    var _b = react_1.useState(false), dropIsOpen = _b[0], dropSetOpen = _b[1];
    var _c = react_1.useState(false), aboutDropIsOpen = _c[0], aboutDropSetOpen = _c[1];
    var _d = react_1.useState(false), aboutModalOpen = _d[0], setAboutModalOpen = _d[1];
    function api(url) {
        return fetch(url).then(function (response) {
            if (!response.ok) {
                throw new Error(response.statusText);
            }
            return response.json();
        });
    }
    function configureClient() {
        api('/multicloud/common/configure')
            .then(function (_a) {
            var token_endpoint = _a.token_endpoint;
            window.open(token_endpoint + "/request", '_blank');
        })
            .catch(function (error) {
            // eslint-disable-next-line no-console
            console.error(error);
        });
    }
    function logout() {
        api('/multicloud/logout')
            .then(function (_a) {
            var admin = _a.admin, logoutPath = _a.logoutPath;
            var onLogout = function (delay) {
                if (delay === void 0) { delay = 0; }
                return setTimeout(function () {
                    location.reload(true);
                }, delay);
            };
            if (admin) {
                var form = document.createElement('form');
                form.target = 'hidden-form';
                form.method = 'POST';
                form.action = logoutPath;
                var iframe = document.createElement('iframe');
                iframe.setAttribute('type', 'hidden');
                iframe.name = 'hidden-form';
                iframe.onload = function () { return onLogout(500); };
                document.body.appendChild(iframe);
                document.body.appendChild(form);
                form.submit();
            }
            onLogout(500);
        })
            .catch(function (error) {
            // eslint-disable-next-line no-console
            console.error(error);
        });
    }
    var headerTools = (react_1.default.createElement(react_core_1.PageHeaderTools, null,
        react_1.default.createElement(react_core_1.PageHeaderToolsGroup, { visibility: {
                default: 'hidden',
                lg: 'visible',
            } },
            react_1.default.createElement(react_core_1.PageHeaderToolsItem, null,
                react_1.default.createElement(react_core_1.Dropdown, { toggle: react_1.default.createElement(react_core_1.DropdownToggle, { id: "toggle-about", onToggle: function () { return aboutDropSetOpen(!aboutDropIsOpen); } }, "About"), dropdownItems: [
                        react_1.default.createElement(react_core_1.DropdownItem, { onClick: function () {
                                return window.open('https://access.redhat.com/documentation/en-us/red_hat_advanced_cluster_management_for_kubernetes/2.2/', '_blank');
                            }, key: 'docbutton' }, "Documentation"),
                        react_1.default.createElement(react_core_1.DropdownItem, { onClick: function () { return setAboutModalOpen(!aboutModalOpen); }, key: 'aboutbutton' }, "About"),
                    ], isOpen: aboutDropIsOpen }),
                react_1.default.createElement(react_core_1.Dropdown, { toggle: react_1.default.createElement(react_core_1.DropdownToggle, { id: "toggle-id", onToggle: function () { return dropSetOpen(!dropIsOpen); } },
                        react_1.default.createElement(DropdownName, null)), dropdownItems: [
                        react_1.default.createElement(react_core_1.DropdownItem, { onClick: function () { return logout(); }, key: 'logoutbutton' }, "Logout"),
                        react_1.default.createElement(react_core_1.DropdownItem, { onClick: function () { return configureClient(); }, key: 'configurebutton' }, "Configure client"),
                    ], isOpen: dropIsOpen }),
                react_1.default.createElement(react_core_1.Modal, { variant: react_core_1.ModalVariant.small, isOpen: aboutModalOpen, "aria-label": "about-modal", showClose: true, "aria-describedby": "about-modal", onClose: function () { return setAboutModalOpen(!aboutModalOpen); } },
                    react_1.default.createElement("span", { className: "version-details__label" }, "Version "),
                    react_1.default.createElement(AboutModalVersion, null),
                    react_1.default.createElement("span", { className: "spacer" }),
                    react_1.default.createElement("div", { className: "copyright" },
                        react_1.default.createElement("p", null, "Copyright \u00A9 2020 IBM Corporation. All rights reserved."),
                        react_1.default.createElement("p", null, "Copyright \u00A9 2020 Red Hat, Inc. All rights reserved.")))))));
    var Header = (react_1.default.createElement(react_core_1.PageHeader, { logo: react_1.default.createElement(react_core_1.Brand, { src: RHACM_Logo_svg_1.default, alt: "RHACM Logo" }), logoProps: props, headerTools: headerTools, showNavToggle: true, isNavOpen: isOpen, onNavToggle: function () { return setOpen(!isOpen); } }));
    var SidebarNav = react_1.default.createElement(NavExpandableList, { urlpath: props.urlpath });
    var Sidebar = react_1.default.createElement(react_core_1.PageSidebar, { nav: SidebarNav, isNavOpen: isOpen });
    return (react_1.default.createElement(react_core_1.Page, { header: Header, sidebar: Sidebar }, props.children));
}
exports.AcmHeaderPrototype = AcmHeaderPrototype;
//# sourceMappingURL=AcmHeaderPrototype.js.map