"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmDrawer = exports.AcmDrawerProvider = exports.AcmDrawerContext = void 0;
var react_1 = __importStar(require("react"));
var react_router_dom_1 = require("react-router-dom");
var react_core_1 = require("@patternfly/react-core");
var AcmAlert_1 = require("../AcmAlert/AcmAlert");
exports.AcmDrawerContext = react_1.createContext({
    drawerContext: undefined,
    setDrawerContext: /* istanbul ignore next */ function () { return undefined; },
});
function AcmDrawerProvider(props) {
    var _a = react_1.useState(), drawerContext = _a[0], setDrawerContext = _a[1];
    // close the drawer on location changes
    var history = react_router_dom_1.useHistory();
    var historyListener = history.listen(function () { return setDrawerContext(undefined); });
    react_1.useEffect(function () {
        return function () { return historyListener(); };
    }, []);
    return (react_1.default.createElement(exports.AcmDrawerContext.Provider, { value: { drawerContext: drawerContext, setDrawerContext: setDrawerContext } }, props.children));
}
exports.AcmDrawerProvider = AcmDrawerProvider;
function AcmDrawer(props) {
    var _a, _b, _c, _d, _e, _f;
    var drawerRef = react_1.useRef(null);
    var drawerContext = react_1.useContext(exports.AcmDrawerContext).drawerContext;
    /* istanbul ignore next */
    var isExpanded = (_a = props === null || props === void 0 ? void 0 : props.isExpanded) !== null && _a !== void 0 ? _a : drawerContext === null || drawerContext === void 0 ? void 0 : drawerContext.isExpanded;
    /* istanbul ignore next */
    var onCloseClick = (_b = props === null || props === void 0 ? void 0 : props.onCloseClick) !== null && _b !== void 0 ? _b : drawerContext === null || drawerContext === void 0 ? void 0 : drawerContext.onCloseClick;
    /* istanbul ignore next */
    var title = (_c = props === null || props === void 0 ? void 0 : props.title) !== null && _c !== void 0 ? _c : drawerContext === null || drawerContext === void 0 ? void 0 : drawerContext.title;
    /* istanbul ignore next */
    var panelContent = (_d = props === null || props === void 0 ? void 0 : props.panelContent) !== null && _d !== void 0 ? _d : drawerContext === null || drawerContext === void 0 ? void 0 : drawerContext.panelContent;
    /* istanbul ignore next */
    var panelContentProps = (_f = (_e = props === null || props === void 0 ? void 0 : props.panelContentProps) !== null && _e !== void 0 ? _e : drawerContext === null || drawerContext === void 0 ? void 0 : drawerContext.panelContentProps) !== null && _f !== void 0 ? _f : {};
    return (react_1.default.createElement(react_core_1.Drawer, { isExpanded: isExpanded, onExpand: /* istanbul ignore next */ function () { var _a; return (_a = drawerRef === null || drawerRef === void 0 ? void 0 : drawerRef.current) === null || _a === void 0 ? void 0 : _a.focus(); } },
        react_1.default.createElement(react_core_1.DrawerContent, { style: { backgroundColor: 'unset' }, panelContent: react_1.default.createElement(AcmAlert_1.AcmAlertProvider, null,
                react_1.default.createElement(AcmDrawerPanelContent, { isExpanded: isExpanded, onCloseClick: onCloseClick, panelContent: panelContent, panelContentProps: panelContentProps, title: title, drawerRef: drawerRef })) },
            react_1.default.createElement(react_core_1.DrawerContentBody, null, props.children))));
}
exports.AcmDrawer = AcmDrawer;
function AcmDrawerPanelContent(props) {
    var alertContext = react_1.useContext(AcmAlert_1.AcmAlertContext);
    react_1.useEffect(function () {
        if (props.isExpanded === undefined || props.isExpanded === false) {
            alertContext.clearAlerts();
        }
    }, [props.isExpanded]);
    return (react_1.default.createElement(react_core_1.DrawerPanelContent, __assign({}, props.panelContentProps),
        react_1.default.createElement(react_core_1.DrawerHead, null,
            react_1.default.createElement("div", { ref: props.drawerRef, tabIndex: 0, style: { fontSize: '24px', outline: 'none' } }, props.title),
            react_1.default.createElement(react_core_1.DrawerActions, null,
                react_1.default.createElement(react_core_1.DrawerCloseButton, { onClick: props.onCloseClick }))),
        react_1.default.createElement(react_core_1.DrawerPanelBody, null, props.panelContent)));
}
//# sourceMappingURL=AcmDrawer.js.map