import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryGroup } from 'victory-group';
import { ChartContainer } from '../ChartContainer';
import { getClassName, getTheme } from '../ChartUtils';
export var ChartGroupSortOrder;
(function (ChartGroupSortOrder) {
    ChartGroupSortOrder["ascending"] = "ascending";
    ChartGroupSortOrder["descending"] = "descending";
})(ChartGroupSortOrder || (ChartGroupSortOrder = {}));
export const ChartGroup = (_a) => {
    var { ariaDesc, ariaTitle, children, containerComponent = React.createElement(ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["ariaDesc", "ariaTitle", "children", "containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign(Object.assign({ desc: ariaDesc, title: ariaTitle, theme }, containerComponent.props), { className: getClassName({ className: containerComponent.props.className }) // Override VictoryContainer class name
     }));
    // Note: containerComponent is required for theme
    return (React.createElement(VictoryGroup, Object.assign({ containerComponent: container, theme: theme }, rest), children));
};
ChartGroup.displayName = 'ChartGroup';
// Note: VictoryGroup.role must be hoisted
hoistNonReactStatics(ChartGroup, VictoryGroup);
//# sourceMappingURL=ChartGroup.js.map