import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryBar } from 'victory-bar';
import { getComparativeMeasureData } from './utils';
import { ChartBar } from '../ChartBar';
import { ChartContainer } from '../ChartContainer';
import { ChartBulletStyles } from '../ChartTheme';
import { ChartTooltip } from '../ChartTooltip';
import { getBulletComparativeMeasureTheme } from '../ChartUtils';
export const ChartBulletComparativeMeasure = ({ allowTooltip = true, ariaDesc, ariaTitle, barWidth = ChartBulletStyles.comparativeMeasureWidth, constrainToVisibleArea = false, data, domain, horizontal = true, labels, measureComponent = React.createElement(ChartBar, null), // Using bar instead of line for tooltip functionality
padding, standalone = true, themeColor, themeVariant, y, 
// destructure last
theme = getBulletComparativeMeasureTheme(themeColor, themeVariant), height = theme.bar.height, width = theme.bar.width, labelComponent = React.createElement(ChartTooltip, null) }) => {
    const computedData = getComparativeMeasureData({
        data,
        theme,
        y
    });
    // Label component
    //
    // Note: SVG height and width are provided by ChartBullet as a workaround to support constrainToVisibleArea
    const tooltip = React.cloneElement(labelComponent, Object.assign({ constrainToVisibleArea, dx: () => {
            if (horizontal) {
                return 0;
            }
            const result = typeof barWidth === 'function' ? barWidth(data) : barWidth;
            return result / 2;
        }, dy: () => {
            if (!horizontal) {
                return 0;
            }
            const result = typeof barWidth === 'function' ? barWidth(data) : barWidth;
            return -(result / 2);
        }, orientation: 'top' }, labelComponent.props));
    const measure = computedData.map((dataPoint, index) => React.cloneElement(measureComponent, Object.assign({ barWidth, data: [Object.assign({}, dataPoint)], domain,
        height,
        horizontal, labelComponent: allowTooltip ? tooltip : undefined, labels, key: `pf-chart-bullet-comparative-measure-${index}`, padding, standalone: false, theme,
        width }, measureComponent.props)));
    return standalone ? (React.createElement(ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, measure)) : (React.createElement(React.Fragment, null, measure));
};
ChartBulletComparativeMeasure.displayName = 'ChartBulletComparativeMeasure';
// Note: VictoryBar.role must be hoisted
hoistNonReactStatics(ChartBulletComparativeMeasure, VictoryBar);
//# sourceMappingURL=ChartBulletComparativeMeasure.js.map