"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.factory = exports.version = exports.name = void 0;
// take care of including ONLY TYPES here, for the rest use `ts`
var bs_logger_1 = require("bs-logger");
/**
 * What methods of `jest` should we hoist
 */
var HOIST_METHODS = ['mock', 'unmock', 'enableAutomock', 'disableAutomock', 'deepUnmock'];
/**
 * @internal
 */
exports.name = 'hoisting-jest-mock';
// increment this each time the code is modified
/**
 * @internal
 */
exports.version = 1;
/**
 * The factory of hoisting transformer factory
 *
 * @param cs Current jest configuration-set
 * @internal
 */
function factory(cs) {
    var logger = cs.logger.child({ namespace: 'ts-hoisting' });
    /**
     * Our compiler (typescript, or a module with typescript-like interface)
     * To access Program or TypeChecker, do: cs.tsCompiler.program or cs.tsCompiler.program.getTypeChecker()
     */
    var ts = cs.compilerModule;
    function shouldHoistExpression(expression) {
        return (ts.isCallExpression(expression) &&
            ts.isPropertyAccessExpression(expression.expression) &&
            HOIST_METHODS.includes(expression.expression.name.text) &&
            ((ts.isIdentifier(expression.expression.expression) && expression.expression.expression.text === 'jest') ||
                shouldHoistExpression(expression.expression.expression)));
    }
    /**
     * Checks whether given node is a statement that we need to hoist
     *
     * @param node The node to test
     */
    function shouldHoistNode(node) {
        return ts.isExpressionStatement(node) && shouldHoistExpression(node.expression);
    }
    /**
     * Create a source file visitor which will visit all nodes in a source file
     *
     * @param ctx The typescript transformation context
     * @param sf The owning source file
     */
    function createVisitor(ctx, _) {
        /**
         * Current block level
         */
        var level = 0;
        /**
         * List of nodes which needs to be hoisted, indexed by their owning level
         */
        var hoisted = [];
        /**
         * Called when we enter a block to increase the level
         */
        var enter = function () {
            level++;
            // reuse arrays
            if (hoisted[level]) {
                hoisted[level].splice(0, hoisted[level].length);
            }
        };
        /**
         * Called when we leave a block to decrease the level
         */
        var exit = function () { return level--; };
        /**
         * Adds a node to the list of nodes to be hoisted in the current level
         *
         * @param node The node to hoist
         */
        var hoist = function (node) {
            if (hoisted[level]) {
                hoisted[level].push(node);
            }
            else {
                hoisted[level] = [node];
            }
        };
        /**
         * Our main visitor, which will be called recursively for each node in the source file's AST
         *
         * @param node The node to be visited
         */
        var visitor = function (node) {
            // enter this level
            enter();
            // visit each child
            var resultNode = ts.visitEachChild(node, visitor, ctx);
            // check if we have something to hoist in this level
            if (hoisted[level] && hoisted[level].length) {
                // re-order children so that hoisted ones appear first
                // this is actually the main job of this transformer
                var hoistedStmts_1 = hoisted[level];
                var otherStmts = resultNode.statements.filter(function (s) { return !hoistedStmts_1.includes(s); });
                var newNode = ts.getMutableClone(resultNode);
                resultNode = __assign(__assign({}, newNode), { statements: ts.createNodeArray(__spread(hoistedStmts_1, otherStmts)) });
            }
            // exit the level
            exit();
            if (shouldHoistNode(resultNode)) {
                // hoist into current level
                hoist(resultNode);
            }
            // finally returns the currently visited node
            return resultNode;
        };
        return visitor;
    }
    // returns the transformer factory
    return function (ctx) {
        var _a;
        return logger.wrap((_a = {}, _a[bs_logger_1.LogContexts.logLevel] = bs_logger_1.LogLevels.debug, _a.call = null, _a), 'visitSourceFileNode(): hoisting', function (sf) { return ts.visitNode(sf, createVisitor(ctx, sf)); });
    };
}
exports.factory = factory;
