export declare const NOOP: (...args: any[]) => void;
/**
 * Returns either the source argument when it is a `Function`, or the default
 * `NOOP` function constant
 */
export declare function asFunction<T extends Function>(source: T | any): T;
/**
 * Determines whether the supplied argument is both a function, and is not
 * the `NOOP` function.
 */
export declare function isUserFunction<T extends Function>(source: T | any): source is T;
export declare function splitOn(input: string, char: string): [string, string];
export declare function last<T>(input: T[]): T | undefined;
export declare function toLinesWithContent(input: string, trimmed?: boolean): string[];
