"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The `GitLogger` is used by the main `SimpleGit` runner to handle logging
 * any warnings or errors.
 */
class GitLogger {
    constructor(_silentLogging) {
        this._silentLogging = _silentLogging;
    }
    silent(silence = false) {
        this._silentLogging = silence;
    }
    error(message) {
        if (!this._silentLogging) {
            console.error(message);
        }
    }
    warn(message) {
        if (!this._silentLogging) {
            console.warn(message);
        }
    }
}
exports.GitLogger = GitLogger;
//# sourceMappingURL=git-logger.js.map