// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/customer_extension_setting_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v1/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/wrappers"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for
// [CustomerExtensionSettingService.GetCustomerExtensionSetting][google.ads.googleads.v1.services.CustomerExtensionSettingService.GetCustomerExtensionSetting].
type GetCustomerExtensionSettingRequest struct {
	// The resource name of the customer extension setting to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomerExtensionSettingRequest) Reset()         { *m = GetCustomerExtensionSettingRequest{} }
func (m *GetCustomerExtensionSettingRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomerExtensionSettingRequest) ProtoMessage()    {}
func (*GetCustomerExtensionSettingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_customer_extension_setting_service_7aa4f56bacfec343, []int{0}
}
func (m *GetCustomerExtensionSettingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomerExtensionSettingRequest.Unmarshal(m, b)
}
func (m *GetCustomerExtensionSettingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomerExtensionSettingRequest.Marshal(b, m, deterministic)
}
func (dst *GetCustomerExtensionSettingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomerExtensionSettingRequest.Merge(dst, src)
}
func (m *GetCustomerExtensionSettingRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomerExtensionSettingRequest.Size(m)
}
func (m *GetCustomerExtensionSettingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomerExtensionSettingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomerExtensionSettingRequest proto.InternalMessageInfo

func (m *GetCustomerExtensionSettingRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for
// [CustomerExtensionSettingService.MutateCustomerExtensionSettings][google.ads.googleads.v1.services.CustomerExtensionSettingService.MutateCustomerExtensionSettings].
type MutateCustomerExtensionSettingsRequest struct {
	// The ID of the customer whose customer extension settings are being
	// modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual customer extension
	// settings.
	Operations []*CustomerExtensionSettingOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerExtensionSettingsRequest) Reset() {
	*m = MutateCustomerExtensionSettingsRequest{}
}
func (m *MutateCustomerExtensionSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerExtensionSettingsRequest) ProtoMessage()    {}
func (*MutateCustomerExtensionSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_customer_extension_setting_service_7aa4f56bacfec343, []int{1}
}
func (m *MutateCustomerExtensionSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerExtensionSettingsRequest.Unmarshal(m, b)
}
func (m *MutateCustomerExtensionSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerExtensionSettingsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateCustomerExtensionSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerExtensionSettingsRequest.Merge(dst, src)
}
func (m *MutateCustomerExtensionSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerExtensionSettingsRequest.Size(m)
}
func (m *MutateCustomerExtensionSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerExtensionSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerExtensionSettingsRequest proto.InternalMessageInfo

func (m *MutateCustomerExtensionSettingsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomerExtensionSettingsRequest) GetOperations() []*CustomerExtensionSettingOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateCustomerExtensionSettingsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateCustomerExtensionSettingsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on a customer extension setting.
type CustomerExtensionSettingOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomerExtensionSettingOperation_Create
	//	*CustomerExtensionSettingOperation_Update
	//	*CustomerExtensionSettingOperation_Remove
	Operation            isCustomerExtensionSettingOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *CustomerExtensionSettingOperation) Reset()         { *m = CustomerExtensionSettingOperation{} }
func (m *CustomerExtensionSettingOperation) String() string { return proto.CompactTextString(m) }
func (*CustomerExtensionSettingOperation) ProtoMessage()    {}
func (*CustomerExtensionSettingOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_customer_extension_setting_service_7aa4f56bacfec343, []int{2}
}
func (m *CustomerExtensionSettingOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerExtensionSettingOperation.Unmarshal(m, b)
}
func (m *CustomerExtensionSettingOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerExtensionSettingOperation.Marshal(b, m, deterministic)
}
func (dst *CustomerExtensionSettingOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerExtensionSettingOperation.Merge(dst, src)
}
func (m *CustomerExtensionSettingOperation) XXX_Size() int {
	return xxx_messageInfo_CustomerExtensionSettingOperation.Size(m)
}
func (m *CustomerExtensionSettingOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerExtensionSettingOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerExtensionSettingOperation proto.InternalMessageInfo

func (m *CustomerExtensionSettingOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomerExtensionSettingOperation_Operation interface {
	isCustomerExtensionSettingOperation_Operation()
}

type CustomerExtensionSettingOperation_Create struct {
	Create *resources.CustomerExtensionSetting `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type CustomerExtensionSettingOperation_Update struct {
	Update *resources.CustomerExtensionSetting `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type CustomerExtensionSettingOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*CustomerExtensionSettingOperation_Create) isCustomerExtensionSettingOperation_Operation() {}

func (*CustomerExtensionSettingOperation_Update) isCustomerExtensionSettingOperation_Operation() {}

func (*CustomerExtensionSettingOperation_Remove) isCustomerExtensionSettingOperation_Operation() {}

func (m *CustomerExtensionSettingOperation) GetOperation() isCustomerExtensionSettingOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomerExtensionSettingOperation) GetCreate() *resources.CustomerExtensionSetting {
	if x, ok := m.GetOperation().(*CustomerExtensionSettingOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *CustomerExtensionSettingOperation) GetUpdate() *resources.CustomerExtensionSetting {
	if x, ok := m.GetOperation().(*CustomerExtensionSettingOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *CustomerExtensionSettingOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*CustomerExtensionSettingOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomerExtensionSettingOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomerExtensionSettingOperation_OneofMarshaler, _CustomerExtensionSettingOperation_OneofUnmarshaler, _CustomerExtensionSettingOperation_OneofSizer, []interface{}{
		(*CustomerExtensionSettingOperation_Create)(nil),
		(*CustomerExtensionSettingOperation_Update)(nil),
		(*CustomerExtensionSettingOperation_Remove)(nil),
	}
}

func _CustomerExtensionSettingOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomerExtensionSettingOperation)
	// operation
	switch x := m.Operation.(type) {
	case *CustomerExtensionSettingOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *CustomerExtensionSettingOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *CustomerExtensionSettingOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("CustomerExtensionSettingOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _CustomerExtensionSettingOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomerExtensionSettingOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.CustomerExtensionSetting)
		err := b.DecodeMessage(msg)
		m.Operation = &CustomerExtensionSettingOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.CustomerExtensionSetting)
		err := b.DecodeMessage(msg)
		m.Operation = &CustomerExtensionSettingOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &CustomerExtensionSettingOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _CustomerExtensionSettingOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomerExtensionSettingOperation)
	// operation
	switch x := m.Operation.(type) {
	case *CustomerExtensionSettingOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomerExtensionSettingOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomerExtensionSettingOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for a customer extension setting mutate.
type MutateCustomerExtensionSettingsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateCustomerExtensionSettingResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *MutateCustomerExtensionSettingsResponse) Reset() {
	*m = MutateCustomerExtensionSettingsResponse{}
}
func (m *MutateCustomerExtensionSettingsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerExtensionSettingsResponse) ProtoMessage()    {}
func (*MutateCustomerExtensionSettingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_customer_extension_setting_service_7aa4f56bacfec343, []int{3}
}
func (m *MutateCustomerExtensionSettingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerExtensionSettingsResponse.Unmarshal(m, b)
}
func (m *MutateCustomerExtensionSettingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerExtensionSettingsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateCustomerExtensionSettingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerExtensionSettingsResponse.Merge(dst, src)
}
func (m *MutateCustomerExtensionSettingsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerExtensionSettingsResponse.Size(m)
}
func (m *MutateCustomerExtensionSettingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerExtensionSettingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerExtensionSettingsResponse proto.InternalMessageInfo

func (m *MutateCustomerExtensionSettingsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateCustomerExtensionSettingsResponse) GetResults() []*MutateCustomerExtensionSettingResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the customer extension setting mutate.
type MutateCustomerExtensionSettingResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerExtensionSettingResult) Reset()         { *m = MutateCustomerExtensionSettingResult{} }
func (m *MutateCustomerExtensionSettingResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerExtensionSettingResult) ProtoMessage()    {}
func (*MutateCustomerExtensionSettingResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_customer_extension_setting_service_7aa4f56bacfec343, []int{4}
}
func (m *MutateCustomerExtensionSettingResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerExtensionSettingResult.Unmarshal(m, b)
}
func (m *MutateCustomerExtensionSettingResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerExtensionSettingResult.Marshal(b, m, deterministic)
}
func (dst *MutateCustomerExtensionSettingResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerExtensionSettingResult.Merge(dst, src)
}
func (m *MutateCustomerExtensionSettingResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerExtensionSettingResult.Size(m)
}
func (m *MutateCustomerExtensionSettingResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerExtensionSettingResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerExtensionSettingResult proto.InternalMessageInfo

func (m *MutateCustomerExtensionSettingResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomerExtensionSettingRequest)(nil), "google.ads.googleads.v1.services.GetCustomerExtensionSettingRequest")
	proto.RegisterType((*MutateCustomerExtensionSettingsRequest)(nil), "google.ads.googleads.v1.services.MutateCustomerExtensionSettingsRequest")
	proto.RegisterType((*CustomerExtensionSettingOperation)(nil), "google.ads.googleads.v1.services.CustomerExtensionSettingOperation")
	proto.RegisterType((*MutateCustomerExtensionSettingsResponse)(nil), "google.ads.googleads.v1.services.MutateCustomerExtensionSettingsResponse")
	proto.RegisterType((*MutateCustomerExtensionSettingResult)(nil), "google.ads.googleads.v1.services.MutateCustomerExtensionSettingResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CustomerExtensionSettingServiceClient is the client API for CustomerExtensionSettingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomerExtensionSettingServiceClient interface {
	// Returns the requested customer extension setting in full detail.
	GetCustomerExtensionSetting(ctx context.Context, in *GetCustomerExtensionSettingRequest, opts ...grpc.CallOption) (*resources.CustomerExtensionSetting, error)
	// Creates, updates, or removes customer extension settings. Operation
	// statuses are returned.
	MutateCustomerExtensionSettings(ctx context.Context, in *MutateCustomerExtensionSettingsRequest, opts ...grpc.CallOption) (*MutateCustomerExtensionSettingsResponse, error)
}

type customerExtensionSettingServiceClient struct {
	cc *grpc.ClientConn
}

func NewCustomerExtensionSettingServiceClient(cc *grpc.ClientConn) CustomerExtensionSettingServiceClient {
	return &customerExtensionSettingServiceClient{cc}
}

func (c *customerExtensionSettingServiceClient) GetCustomerExtensionSetting(ctx context.Context, in *GetCustomerExtensionSettingRequest, opts ...grpc.CallOption) (*resources.CustomerExtensionSetting, error) {
	out := new(resources.CustomerExtensionSetting)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CustomerExtensionSettingService/GetCustomerExtensionSetting", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerExtensionSettingServiceClient) MutateCustomerExtensionSettings(ctx context.Context, in *MutateCustomerExtensionSettingsRequest, opts ...grpc.CallOption) (*MutateCustomerExtensionSettingsResponse, error) {
	out := new(MutateCustomerExtensionSettingsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CustomerExtensionSettingService/MutateCustomerExtensionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerExtensionSettingServiceServer is the server API for CustomerExtensionSettingService service.
type CustomerExtensionSettingServiceServer interface {
	// Returns the requested customer extension setting in full detail.
	GetCustomerExtensionSetting(context.Context, *GetCustomerExtensionSettingRequest) (*resources.CustomerExtensionSetting, error)
	// Creates, updates, or removes customer extension settings. Operation
	// statuses are returned.
	MutateCustomerExtensionSettings(context.Context, *MutateCustomerExtensionSettingsRequest) (*MutateCustomerExtensionSettingsResponse, error)
}

func RegisterCustomerExtensionSettingServiceServer(s *grpc.Server, srv CustomerExtensionSettingServiceServer) {
	s.RegisterService(&_CustomerExtensionSettingService_serviceDesc, srv)
}

func _CustomerExtensionSettingService_GetCustomerExtensionSetting_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerExtensionSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerExtensionSettingServiceServer).GetCustomerExtensionSetting(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CustomerExtensionSettingService/GetCustomerExtensionSetting",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerExtensionSettingServiceServer).GetCustomerExtensionSetting(ctx, req.(*GetCustomerExtensionSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerExtensionSettingService_MutateCustomerExtensionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomerExtensionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerExtensionSettingServiceServer).MutateCustomerExtensionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CustomerExtensionSettingService/MutateCustomerExtensionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerExtensionSettingServiceServer).MutateCustomerExtensionSettings(ctx, req.(*MutateCustomerExtensionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomerExtensionSettingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.CustomerExtensionSettingService",
	HandlerType: (*CustomerExtensionSettingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomerExtensionSetting",
			Handler:    _CustomerExtensionSettingService_GetCustomerExtensionSetting_Handler,
		},
		{
			MethodName: "MutateCustomerExtensionSettings",
			Handler:    _CustomerExtensionSettingService_MutateCustomerExtensionSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/customer_extension_setting_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/customer_extension_setting_service.proto", fileDescriptor_customer_extension_setting_service_7aa4f56bacfec343)
}

var fileDescriptor_customer_extension_setting_service_7aa4f56bacfec343 = []byte{
	// 722 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0xcf, 0x4e, 0xd4, 0x40,
	0x1c, 0xc7, 0x6d, 0x21, 0x28, 0xb3, 0xa8, 0xc9, 0x18, 0xe3, 0x66, 0x35, 0xb2, 0xd6, 0x8d, 0x90,
	0x3d, 0xb4, 0xd9, 0xf5, 0xd6, 0x0d, 0x26, 0xbb, 0x2b, 0x0b, 0x1b, 0x83, 0x90, 0x12, 0x39, 0x98,
	0x4d, 0xea, 0xd0, 0x0e, 0x4d, 0x43, 0xdb, 0xa9, 0x33, 0xd3, 0x55, 0x42, 0x38, 0xe8, 0xd5, 0x78,
	0xf2, 0x0d, 0x3c, 0x7a, 0xf7, 0x25, 0xbc, 0xf2, 0x0a, 0x7a, 0xf1, 0x19, 0x3c, 0x98, 0x76, 0x3a,
	0x15, 0x30, 0xa5, 0x24, 0x70, 0x9b, 0xfe, 0xe6, 0xdb, 0xcf, 0xef, 0x6f, 0x7f, 0x05, 0x63, 0x8f,
	0x10, 0x2f, 0xc0, 0x06, 0x72, 0x99, 0x21, 0x8e, 0xe9, 0x69, 0xda, 0x31, 0x18, 0xa6, 0x53, 0xdf,
	0xc1, 0xcc, 0x70, 0x12, 0xc6, 0x49, 0x88, 0xa9, 0x8d, 0xdf, 0x73, 0x1c, 0x31, 0x9f, 0x44, 0x36,
	0xc3, 0x9c, 0xfb, 0x91, 0x67, 0xe7, 0x1a, 0x3d, 0xa6, 0x84, 0x13, 0xd8, 0x14, 0xef, 0xeb, 0xc8,
	0x65, 0x7a, 0x81, 0xd2, 0xa7, 0x1d, 0x5d, 0xa2, 0x1a, 0x83, 0x32, 0x67, 0x14, 0x33, 0x92, 0xd0,
	0xf3, 0xbd, 0x09, 0x2f, 0x8d, 0x07, 0x92, 0x11, 0xfb, 0x06, 0x8a, 0x22, 0xc2, 0x11, 0xf7, 0x49,
	0xc4, 0xf2, 0xdb, 0x3c, 0x06, 0x23, 0x7b, 0xda, 0x4d, 0xf6, 0x8c, 0x3d, 0x1f, 0x07, 0xae, 0x1d,
	0x22, 0xb6, 0x9f, 0x2b, 0x1e, 0x9e, 0x55, 0xbc, 0xa3, 0x28, 0x8e, 0x31, 0x95, 0x84, 0x7b, 0xf9,
	0x3d, 0x8d, 0x1d, 0x83, 0x71, 0xc4, 0x93, 0xfc, 0x42, 0x1b, 0x03, 0x6d, 0x0d, 0xf3, 0x61, 0x1e,
	0xdf, 0xaa, 0x0c, 0x6f, 0x5b, 0x44, 0x67, 0xe1, 0xb7, 0x09, 0x66, 0x1c, 0x3e, 0x06, 0x37, 0x65,
	0x32, 0x76, 0x84, 0x42, 0x5c, 0x57, 0x9a, 0xca, 0xf2, 0xbc, 0xb5, 0x20, 0x8d, 0x2f, 0x51, 0x88,
	0xb5, 0x3f, 0x0a, 0x78, 0xb2, 0x91, 0x70, 0xc4, 0x71, 0x19, 0x8e, 0x49, 0xde, 0x22, 0xa8, 0x15,
	0x25, 0xf1, 0xdd, 0x9c, 0x06, 0xa4, 0x69, 0xec, 0x42, 0x07, 0x00, 0x12, 0x63, 0x2a, 0xaa, 0x50,
	0x57, 0x9b, 0x33, 0xcb, 0xb5, 0xee, 0x50, 0xaf, 0x6a, 0x85, 0x5e, 0xe6, 0x78, 0x53, 0xb2, 0xac,
	0x13, 0x58, 0xb8, 0x04, 0x6e, 0xc7, 0x88, 0x72, 0x1f, 0x05, 0xf6, 0x1e, 0xf2, 0x83, 0x84, 0xe2,
	0xfa, 0x4c, 0x53, 0x59, 0xbe, 0x61, 0xdd, 0xca, 0xcd, 0x23, 0x61, 0x4d, 0xd3, 0x9f, 0xa2, 0xc0,
	0x77, 0x11, 0xc7, 0x36, 0x89, 0x82, 0x83, 0xfa, 0x6c, 0x26, 0x5b, 0x90, 0xc6, 0xcd, 0x28, 0x38,
	0xd0, 0xbe, 0xab, 0xe0, 0x51, 0xa5, 0x7f, 0xd8, 0x03, 0xb5, 0x24, 0xce, 0x40, 0x69, 0xf7, 0x32,
	0x50, 0xad, 0xdb, 0x90, 0x99, 0xc9, 0xf6, 0xe9, 0xa3, 0xb4, 0xc1, 0x1b, 0x88, 0xed, 0x5b, 0x40,
	0xc8, 0xd3, 0x33, 0x7c, 0x05, 0xe6, 0x1c, 0x8a, 0x11, 0x17, 0xf5, 0xaf, 0x75, 0x7b, 0xa5, 0x15,
	0x29, 0x46, 0xaf, 0xb4, 0x24, 0xeb, 0xd7, 0xac, 0x1c, 0x96, 0x62, 0x85, 0x93, 0xba, 0x7a, 0x25,
	0x58, 0x01, 0x83, 0x75, 0x30, 0x47, 0x71, 0x48, 0xa6, 0xa2, 0xaa, 0xf3, 0xe9, 0x8d, 0x78, 0x1e,
	0xd4, 0xc0, 0x7c, 0xd1, 0x06, 0xed, 0x58, 0x01, 0x4b, 0x95, 0x63, 0xc3, 0x62, 0x12, 0x31, 0x0c,
	0x47, 0xe0, 0xee, 0x99, 0x8e, 0xd9, 0x98, 0x52, 0x42, 0x33, 0x0f, 0xb5, 0x2e, 0x94, 0x81, 0xd3,
	0xd8, 0xd1, 0xb7, 0xb3, 0x31, 0xb7, 0xee, 0x9c, 0xee, 0xe5, 0x6a, 0x2a, 0x87, 0x6f, 0xc0, 0x75,
	0x8a, 0x59, 0x12, 0x70, 0x39, 0x5b, 0xa3, 0xea, 0xd9, 0x3a, 0x3f, 0x46, 0x2b, 0xc3, 0x59, 0x12,
	0xab, 0xbd, 0x00, 0xad, 0x8b, 0xbc, 0x70, 0xa1, 0x2f, 0xab, 0xfb, 0x79, 0x16, 0x2c, 0x96, 0x71,
	0xb6, 0x45, 0x7c, 0xf0, 0x97, 0x02, 0xee, 0x9f, 0xf3, 0x25, 0xc3, 0xe7, 0xd5, 0x19, 0x56, 0x2f,
	0x82, 0xc6, 0x65, 0x46, 0x43, 0x1b, 0x7e, 0x3c, 0xfe, 0xf9, 0x45, 0x5d, 0x81, 0xbd, 0x74, 0x39,
	0x1e, 0x9e, 0x4a, 0x7b, 0x45, 0x7e, 0xfb, 0xcc, 0x68, 0x17, 0xdb, 0xf2, 0xbf, 0x39, 0x30, 0xda,
	0x47, 0xf0, 0x83, 0x0a, 0x16, 0x2b, 0xc6, 0x05, 0xae, 0x5f, 0xb6, 0x9b, 0x72, 0x51, 0x35, 0xc6,
	0x57, 0x40, 0x12, 0xb3, 0xab, 0x8d, 0xb3, 0xec, 0x87, 0xda, 0xb3, 0x34, 0xfb, 0x7f, 0xe9, 0x1e,
	0x9e, 0x58, 0x84, 0x2b, 0xed, 0xa3, 0xf2, 0xe4, 0xcd, 0x30, 0x73, 0x64, 0x2a, 0xed, 0xc1, 0x27,
	0x15, 0xb4, 0x1c, 0x12, 0x56, 0xc6, 0x36, 0x68, 0x55, 0x4c, 0xcd, 0x56, 0xba, 0x6f, 0xb6, 0x94,
	0xd7, 0xeb, 0x39, 0xc9, 0x23, 0x01, 0x8a, 0x3c, 0x9d, 0x50, 0xcf, 0xf0, 0x70, 0x94, 0x6d, 0x23,
	0xf9, 0x4b, 0x8b, 0x7d, 0x56, 0xfe, 0x3b, 0xed, 0xc9, 0xc3, 0x57, 0x75, 0x66, 0xad, 0xdf, 0xff,
	0xa6, 0x36, 0xd7, 0x04, 0xb0, 0xef, 0x32, 0x5d, 0x1c, 0xd3, 0xd3, 0x4e, 0x47, 0xcf, 0x1d, 0xb3,
	0x1f, 0x52, 0x32, 0xe9, 0xbb, 0x6c, 0x52, 0x48, 0x26, 0x3b, 0x9d, 0x89, 0x94, 0xfc, 0x56, 0x5b,
	0xc2, 0x6e, 0x9a, 0x7d, 0x97, 0x99, 0x66, 0x21, 0x32, 0xcd, 0x9d, 0x8e, 0x69, 0x4a, 0xd9, 0xee,
	0x5c, 0x16, 0xe7, 0xd3, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xac, 0xac, 0x54, 0xea, 0xf5, 0x07,
	0x00, 0x00,
}
