// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/logging/v1/audit_data.proto

package logging // import "google.golang.org/genproto/googleapis/cloud/bigquery/logging/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// BigQuery request and response messages for audit log.
// Note: `Table.schema` has been deprecated in favor of `Table.schemaJson`.
// `Table.schema` may continue to be present in your logs during this
// transition.
type AuditData struct {
	// Request data for each BigQuery method.
	//
	// Types that are valid to be assigned to Request:
	//	*AuditData_TableInsertRequest
	//	*AuditData_TableUpdateRequest
	//	*AuditData_DatasetListRequest
	//	*AuditData_DatasetInsertRequest
	//	*AuditData_DatasetUpdateRequest
	//	*AuditData_JobInsertRequest
	//	*AuditData_JobQueryRequest
	//	*AuditData_JobGetQueryResultsRequest
	//	*AuditData_TableDataListRequest
	Request isAuditData_Request `protobuf_oneof:"request"`
	// Response data for each BigQuery method.
	//
	// Types that are valid to be assigned to Response:
	//	*AuditData_TableInsertResponse
	//	*AuditData_TableUpdateResponse
	//	*AuditData_DatasetInsertResponse
	//	*AuditData_DatasetUpdateResponse
	//	*AuditData_JobInsertResponse
	//	*AuditData_JobQueryResponse
	//	*AuditData_JobGetQueryResultsResponse
	//	*AuditData_JobQueryDoneResponse
	Response isAuditData_Response `protobuf_oneof:"response"`
	// A job completion event.
	JobCompletedEvent    *JobCompletedEvent `protobuf:"bytes,17,opt,name=job_completed_event,json=jobCompletedEvent,proto3" json:"job_completed_event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *AuditData) Reset()         { *m = AuditData{} }
func (m *AuditData) String() string { return proto.CompactTextString(m) }
func (*AuditData) ProtoMessage()    {}
func (*AuditData) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{0}
}
func (m *AuditData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AuditData.Unmarshal(m, b)
}
func (m *AuditData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AuditData.Marshal(b, m, deterministic)
}
func (dst *AuditData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditData.Merge(dst, src)
}
func (m *AuditData) XXX_Size() int {
	return xxx_messageInfo_AuditData.Size(m)
}
func (m *AuditData) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditData.DiscardUnknown(m)
}

var xxx_messageInfo_AuditData proto.InternalMessageInfo

type isAuditData_Request interface {
	isAuditData_Request()
}

type AuditData_TableInsertRequest struct {
	TableInsertRequest *TableInsertRequest `protobuf:"bytes,1,opt,name=table_insert_request,json=tableInsertRequest,proto3,oneof"`
}

type AuditData_TableUpdateRequest struct {
	TableUpdateRequest *TableUpdateRequest `protobuf:"bytes,16,opt,name=table_update_request,json=tableUpdateRequest,proto3,oneof"`
}

type AuditData_DatasetListRequest struct {
	DatasetListRequest *DatasetListRequest `protobuf:"bytes,2,opt,name=dataset_list_request,json=datasetListRequest,proto3,oneof"`
}

type AuditData_DatasetInsertRequest struct {
	DatasetInsertRequest *DatasetInsertRequest `protobuf:"bytes,3,opt,name=dataset_insert_request,json=datasetInsertRequest,proto3,oneof"`
}

type AuditData_DatasetUpdateRequest struct {
	DatasetUpdateRequest *DatasetUpdateRequest `protobuf:"bytes,4,opt,name=dataset_update_request,json=datasetUpdateRequest,proto3,oneof"`
}

type AuditData_JobInsertRequest struct {
	JobInsertRequest *JobInsertRequest `protobuf:"bytes,5,opt,name=job_insert_request,json=jobInsertRequest,proto3,oneof"`
}

type AuditData_JobQueryRequest struct {
	JobQueryRequest *JobQueryRequest `protobuf:"bytes,6,opt,name=job_query_request,json=jobQueryRequest,proto3,oneof"`
}

type AuditData_JobGetQueryResultsRequest struct {
	JobGetQueryResultsRequest *JobGetQueryResultsRequest `protobuf:"bytes,7,opt,name=job_get_query_results_request,json=jobGetQueryResultsRequest,proto3,oneof"`
}

type AuditData_TableDataListRequest struct {
	TableDataListRequest *TableDataListRequest `protobuf:"bytes,8,opt,name=table_data_list_request,json=tableDataListRequest,proto3,oneof"`
}

func (*AuditData_TableInsertRequest) isAuditData_Request() {}

func (*AuditData_TableUpdateRequest) isAuditData_Request() {}

func (*AuditData_DatasetListRequest) isAuditData_Request() {}

func (*AuditData_DatasetInsertRequest) isAuditData_Request() {}

func (*AuditData_DatasetUpdateRequest) isAuditData_Request() {}

func (*AuditData_JobInsertRequest) isAuditData_Request() {}

func (*AuditData_JobQueryRequest) isAuditData_Request() {}

func (*AuditData_JobGetQueryResultsRequest) isAuditData_Request() {}

func (*AuditData_TableDataListRequest) isAuditData_Request() {}

func (m *AuditData) GetRequest() isAuditData_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *AuditData) GetTableInsertRequest() *TableInsertRequest {
	if x, ok := m.GetRequest().(*AuditData_TableInsertRequest); ok {
		return x.TableInsertRequest
	}
	return nil
}

func (m *AuditData) GetTableUpdateRequest() *TableUpdateRequest {
	if x, ok := m.GetRequest().(*AuditData_TableUpdateRequest); ok {
		return x.TableUpdateRequest
	}
	return nil
}

func (m *AuditData) GetDatasetListRequest() *DatasetListRequest {
	if x, ok := m.GetRequest().(*AuditData_DatasetListRequest); ok {
		return x.DatasetListRequest
	}
	return nil
}

func (m *AuditData) GetDatasetInsertRequest() *DatasetInsertRequest {
	if x, ok := m.GetRequest().(*AuditData_DatasetInsertRequest); ok {
		return x.DatasetInsertRequest
	}
	return nil
}

func (m *AuditData) GetDatasetUpdateRequest() *DatasetUpdateRequest {
	if x, ok := m.GetRequest().(*AuditData_DatasetUpdateRequest); ok {
		return x.DatasetUpdateRequest
	}
	return nil
}

func (m *AuditData) GetJobInsertRequest() *JobInsertRequest {
	if x, ok := m.GetRequest().(*AuditData_JobInsertRequest); ok {
		return x.JobInsertRequest
	}
	return nil
}

func (m *AuditData) GetJobQueryRequest() *JobQueryRequest {
	if x, ok := m.GetRequest().(*AuditData_JobQueryRequest); ok {
		return x.JobQueryRequest
	}
	return nil
}

func (m *AuditData) GetJobGetQueryResultsRequest() *JobGetQueryResultsRequest {
	if x, ok := m.GetRequest().(*AuditData_JobGetQueryResultsRequest); ok {
		return x.JobGetQueryResultsRequest
	}
	return nil
}

func (m *AuditData) GetTableDataListRequest() *TableDataListRequest {
	if x, ok := m.GetRequest().(*AuditData_TableDataListRequest); ok {
		return x.TableDataListRequest
	}
	return nil
}

type isAuditData_Response interface {
	isAuditData_Response()
}

type AuditData_TableInsertResponse struct {
	TableInsertResponse *TableInsertResponse `protobuf:"bytes,9,opt,name=table_insert_response,json=tableInsertResponse,proto3,oneof"`
}

type AuditData_TableUpdateResponse struct {
	TableUpdateResponse *TableUpdateResponse `protobuf:"bytes,10,opt,name=table_update_response,json=tableUpdateResponse,proto3,oneof"`
}

type AuditData_DatasetInsertResponse struct {
	DatasetInsertResponse *DatasetInsertResponse `protobuf:"bytes,11,opt,name=dataset_insert_response,json=datasetInsertResponse,proto3,oneof"`
}

type AuditData_DatasetUpdateResponse struct {
	DatasetUpdateResponse *DatasetUpdateResponse `protobuf:"bytes,12,opt,name=dataset_update_response,json=datasetUpdateResponse,proto3,oneof"`
}

type AuditData_JobInsertResponse struct {
	JobInsertResponse *JobInsertResponse `protobuf:"bytes,18,opt,name=job_insert_response,json=jobInsertResponse,proto3,oneof"`
}

type AuditData_JobQueryResponse struct {
	JobQueryResponse *JobQueryResponse `protobuf:"bytes,13,opt,name=job_query_response,json=jobQueryResponse,proto3,oneof"`
}

type AuditData_JobGetQueryResultsResponse struct {
	JobGetQueryResultsResponse *JobGetQueryResultsResponse `protobuf:"bytes,14,opt,name=job_get_query_results_response,json=jobGetQueryResultsResponse,proto3,oneof"`
}

type AuditData_JobQueryDoneResponse struct {
	JobQueryDoneResponse *JobQueryDoneResponse `protobuf:"bytes,15,opt,name=job_query_done_response,json=jobQueryDoneResponse,proto3,oneof"`
}

func (*AuditData_TableInsertResponse) isAuditData_Response() {}

func (*AuditData_TableUpdateResponse) isAuditData_Response() {}

func (*AuditData_DatasetInsertResponse) isAuditData_Response() {}

func (*AuditData_DatasetUpdateResponse) isAuditData_Response() {}

func (*AuditData_JobInsertResponse) isAuditData_Response() {}

func (*AuditData_JobQueryResponse) isAuditData_Response() {}

func (*AuditData_JobGetQueryResultsResponse) isAuditData_Response() {}

func (*AuditData_JobQueryDoneResponse) isAuditData_Response() {}

func (m *AuditData) GetResponse() isAuditData_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *AuditData) GetTableInsertResponse() *TableInsertResponse {
	if x, ok := m.GetResponse().(*AuditData_TableInsertResponse); ok {
		return x.TableInsertResponse
	}
	return nil
}

func (m *AuditData) GetTableUpdateResponse() *TableUpdateResponse {
	if x, ok := m.GetResponse().(*AuditData_TableUpdateResponse); ok {
		return x.TableUpdateResponse
	}
	return nil
}

func (m *AuditData) GetDatasetInsertResponse() *DatasetInsertResponse {
	if x, ok := m.GetResponse().(*AuditData_DatasetInsertResponse); ok {
		return x.DatasetInsertResponse
	}
	return nil
}

func (m *AuditData) GetDatasetUpdateResponse() *DatasetUpdateResponse {
	if x, ok := m.GetResponse().(*AuditData_DatasetUpdateResponse); ok {
		return x.DatasetUpdateResponse
	}
	return nil
}

func (m *AuditData) GetJobInsertResponse() *JobInsertResponse {
	if x, ok := m.GetResponse().(*AuditData_JobInsertResponse); ok {
		return x.JobInsertResponse
	}
	return nil
}

func (m *AuditData) GetJobQueryResponse() *JobQueryResponse {
	if x, ok := m.GetResponse().(*AuditData_JobQueryResponse); ok {
		return x.JobQueryResponse
	}
	return nil
}

func (m *AuditData) GetJobGetQueryResultsResponse() *JobGetQueryResultsResponse {
	if x, ok := m.GetResponse().(*AuditData_JobGetQueryResultsResponse); ok {
		return x.JobGetQueryResultsResponse
	}
	return nil
}

func (m *AuditData) GetJobQueryDoneResponse() *JobQueryDoneResponse {
	if x, ok := m.GetResponse().(*AuditData_JobQueryDoneResponse); ok {
		return x.JobQueryDoneResponse
	}
	return nil
}

func (m *AuditData) GetJobCompletedEvent() *JobCompletedEvent {
	if m != nil {
		return m.JobCompletedEvent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AuditData) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AuditData_OneofMarshaler, _AuditData_OneofUnmarshaler, _AuditData_OneofSizer, []interface{}{
		(*AuditData_TableInsertRequest)(nil),
		(*AuditData_TableUpdateRequest)(nil),
		(*AuditData_DatasetListRequest)(nil),
		(*AuditData_DatasetInsertRequest)(nil),
		(*AuditData_DatasetUpdateRequest)(nil),
		(*AuditData_JobInsertRequest)(nil),
		(*AuditData_JobQueryRequest)(nil),
		(*AuditData_JobGetQueryResultsRequest)(nil),
		(*AuditData_TableDataListRequest)(nil),
		(*AuditData_TableInsertResponse)(nil),
		(*AuditData_TableUpdateResponse)(nil),
		(*AuditData_DatasetInsertResponse)(nil),
		(*AuditData_DatasetUpdateResponse)(nil),
		(*AuditData_JobInsertResponse)(nil),
		(*AuditData_JobQueryResponse)(nil),
		(*AuditData_JobGetQueryResultsResponse)(nil),
		(*AuditData_JobQueryDoneResponse)(nil),
	}
}

func _AuditData_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AuditData)
	// request
	switch x := m.Request.(type) {
	case *AuditData_TableInsertRequest:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TableInsertRequest); err != nil {
			return err
		}
	case *AuditData_TableUpdateRequest:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TableUpdateRequest); err != nil {
			return err
		}
	case *AuditData_DatasetListRequest:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatasetListRequest); err != nil {
			return err
		}
	case *AuditData_DatasetInsertRequest:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatasetInsertRequest); err != nil {
			return err
		}
	case *AuditData_DatasetUpdateRequest:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatasetUpdateRequest); err != nil {
			return err
		}
	case *AuditData_JobInsertRequest:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.JobInsertRequest); err != nil {
			return err
		}
	case *AuditData_JobQueryRequest:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.JobQueryRequest); err != nil {
			return err
		}
	case *AuditData_JobGetQueryResultsRequest:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.JobGetQueryResultsRequest); err != nil {
			return err
		}
	case *AuditData_TableDataListRequest:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TableDataListRequest); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AuditData.Request has unexpected type %T", x)
	}
	// response
	switch x := m.Response.(type) {
	case *AuditData_TableInsertResponse:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TableInsertResponse); err != nil {
			return err
		}
	case *AuditData_TableUpdateResponse:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TableUpdateResponse); err != nil {
			return err
		}
	case *AuditData_DatasetInsertResponse:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatasetInsertResponse); err != nil {
			return err
		}
	case *AuditData_DatasetUpdateResponse:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatasetUpdateResponse); err != nil {
			return err
		}
	case *AuditData_JobInsertResponse:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.JobInsertResponse); err != nil {
			return err
		}
	case *AuditData_JobQueryResponse:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.JobQueryResponse); err != nil {
			return err
		}
	case *AuditData_JobGetQueryResultsResponse:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.JobGetQueryResultsResponse); err != nil {
			return err
		}
	case *AuditData_JobQueryDoneResponse:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.JobQueryDoneResponse); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AuditData.Response has unexpected type %T", x)
	}
	return nil
}

func _AuditData_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AuditData)
	switch tag {
	case 1: // request.table_insert_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TableInsertRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_TableInsertRequest{msg}
		return true, err
	case 16: // request.table_update_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TableUpdateRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_TableUpdateRequest{msg}
		return true, err
	case 2: // request.dataset_list_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatasetListRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_DatasetListRequest{msg}
		return true, err
	case 3: // request.dataset_insert_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatasetInsertRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_DatasetInsertRequest{msg}
		return true, err
	case 4: // request.dataset_update_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatasetUpdateRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_DatasetUpdateRequest{msg}
		return true, err
	case 5: // request.job_insert_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobInsertRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_JobInsertRequest{msg}
		return true, err
	case 6: // request.job_query_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobQueryRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_JobQueryRequest{msg}
		return true, err
	case 7: // request.job_get_query_results_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobGetQueryResultsRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_JobGetQueryResultsRequest{msg}
		return true, err
	case 8: // request.table_data_list_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TableDataListRequest)
		err := b.DecodeMessage(msg)
		m.Request = &AuditData_TableDataListRequest{msg}
		return true, err
	case 9: // response.table_insert_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TableInsertResponse)
		err := b.DecodeMessage(msg)
		m.Response = &AuditData_TableInsertResponse{msg}
		return true, err
	case 10: // response.table_update_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TableUpdateResponse)
		err := b.DecodeMessage(msg)
		m.Response = &AuditData_TableUpdateResponse{msg}
		return true, err
	case 11: // response.dataset_insert_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatasetInsertResponse)
		err := b.DecodeMessage(msg)
		m.Response = &AuditData_DatasetInsertResponse{msg}
		return true, err
	case 12: // response.dataset_update_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatasetUpdateResponse)
		err := b.DecodeMessage(msg)
		m.Response = &AuditData_DatasetUpdateResponse{msg}
		return true, err
	case 18: // response.job_insert_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobInsertResponse)
		err := b.DecodeMessage(msg)
		m.Response = &AuditData_JobInsertResponse{msg}
		return true, err
	case 13: // response.job_query_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobQueryResponse)
		err := b.DecodeMessage(msg)
		m.Response = &AuditData_JobQueryResponse{msg}
		return true, err
	case 14: // response.job_get_query_results_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobGetQueryResultsResponse)
		err := b.DecodeMessage(msg)
		m.Response = &AuditData_JobGetQueryResultsResponse{msg}
		return true, err
	case 15: // response.job_query_done_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobQueryDoneResponse)
		err := b.DecodeMessage(msg)
		m.Response = &AuditData_JobQueryDoneResponse{msg}
		return true, err
	default:
		return false, nil
	}
}

func _AuditData_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AuditData)
	// request
	switch x := m.Request.(type) {
	case *AuditData_TableInsertRequest:
		s := proto.Size(x.TableInsertRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_TableUpdateRequest:
		s := proto.Size(x.TableUpdateRequest)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_DatasetListRequest:
		s := proto.Size(x.DatasetListRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_DatasetInsertRequest:
		s := proto.Size(x.DatasetInsertRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_DatasetUpdateRequest:
		s := proto.Size(x.DatasetUpdateRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_JobInsertRequest:
		s := proto.Size(x.JobInsertRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_JobQueryRequest:
		s := proto.Size(x.JobQueryRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_JobGetQueryResultsRequest:
		s := proto.Size(x.JobGetQueryResultsRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_TableDataListRequest:
		s := proto.Size(x.TableDataListRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// response
	switch x := m.Response.(type) {
	case *AuditData_TableInsertResponse:
		s := proto.Size(x.TableInsertResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_TableUpdateResponse:
		s := proto.Size(x.TableUpdateResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_DatasetInsertResponse:
		s := proto.Size(x.DatasetInsertResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_DatasetUpdateResponse:
		s := proto.Size(x.DatasetUpdateResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_JobInsertResponse:
		s := proto.Size(x.JobInsertResponse)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_JobQueryResponse:
		s := proto.Size(x.JobQueryResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_JobGetQueryResultsResponse:
		s := proto.Size(x.JobGetQueryResultsResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AuditData_JobQueryDoneResponse:
		s := proto.Size(x.JobQueryDoneResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Table insert request.
type TableInsertRequest struct {
	// The new table.
	Resource             *Table   `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableInsertRequest) Reset()         { *m = TableInsertRequest{} }
func (m *TableInsertRequest) String() string { return proto.CompactTextString(m) }
func (*TableInsertRequest) ProtoMessage()    {}
func (*TableInsertRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{1}
}
func (m *TableInsertRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableInsertRequest.Unmarshal(m, b)
}
func (m *TableInsertRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableInsertRequest.Marshal(b, m, deterministic)
}
func (dst *TableInsertRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableInsertRequest.Merge(dst, src)
}
func (m *TableInsertRequest) XXX_Size() int {
	return xxx_messageInfo_TableInsertRequest.Size(m)
}
func (m *TableInsertRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TableInsertRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TableInsertRequest proto.InternalMessageInfo

func (m *TableInsertRequest) GetResource() *Table {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Table update request.
type TableUpdateRequest struct {
	// The table to be updated.
	Resource             *Table   `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableUpdateRequest) Reset()         { *m = TableUpdateRequest{} }
func (m *TableUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*TableUpdateRequest) ProtoMessage()    {}
func (*TableUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{2}
}
func (m *TableUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableUpdateRequest.Unmarshal(m, b)
}
func (m *TableUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *TableUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableUpdateRequest.Merge(dst, src)
}
func (m *TableUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_TableUpdateRequest.Size(m)
}
func (m *TableUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TableUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TableUpdateRequest proto.InternalMessageInfo

func (m *TableUpdateRequest) GetResource() *Table {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Table insert response.
type TableInsertResponse struct {
	// Final state of the inserted table.
	Resource             *Table   `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableInsertResponse) Reset()         { *m = TableInsertResponse{} }
func (m *TableInsertResponse) String() string { return proto.CompactTextString(m) }
func (*TableInsertResponse) ProtoMessage()    {}
func (*TableInsertResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{3}
}
func (m *TableInsertResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableInsertResponse.Unmarshal(m, b)
}
func (m *TableInsertResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableInsertResponse.Marshal(b, m, deterministic)
}
func (dst *TableInsertResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableInsertResponse.Merge(dst, src)
}
func (m *TableInsertResponse) XXX_Size() int {
	return xxx_messageInfo_TableInsertResponse.Size(m)
}
func (m *TableInsertResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TableInsertResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TableInsertResponse proto.InternalMessageInfo

func (m *TableInsertResponse) GetResource() *Table {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Table update response.
type TableUpdateResponse struct {
	// Final state of the updated table.
	Resource             *Table   `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableUpdateResponse) Reset()         { *m = TableUpdateResponse{} }
func (m *TableUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*TableUpdateResponse) ProtoMessage()    {}
func (*TableUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{4}
}
func (m *TableUpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableUpdateResponse.Unmarshal(m, b)
}
func (m *TableUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableUpdateResponse.Marshal(b, m, deterministic)
}
func (dst *TableUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableUpdateResponse.Merge(dst, src)
}
func (m *TableUpdateResponse) XXX_Size() int {
	return xxx_messageInfo_TableUpdateResponse.Size(m)
}
func (m *TableUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TableUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TableUpdateResponse proto.InternalMessageInfo

func (m *TableUpdateResponse) GetResource() *Table {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Dataset list request.
type DatasetListRequest struct {
	// Whether to list all datasets, including hidden ones.
	ListAll              bool     `protobuf:"varint,1,opt,name=list_all,json=listAll,proto3" json:"list_all,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatasetListRequest) Reset()         { *m = DatasetListRequest{} }
func (m *DatasetListRequest) String() string { return proto.CompactTextString(m) }
func (*DatasetListRequest) ProtoMessage()    {}
func (*DatasetListRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{5}
}
func (m *DatasetListRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatasetListRequest.Unmarshal(m, b)
}
func (m *DatasetListRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatasetListRequest.Marshal(b, m, deterministic)
}
func (dst *DatasetListRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatasetListRequest.Merge(dst, src)
}
func (m *DatasetListRequest) XXX_Size() int {
	return xxx_messageInfo_DatasetListRequest.Size(m)
}
func (m *DatasetListRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DatasetListRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DatasetListRequest proto.InternalMessageInfo

func (m *DatasetListRequest) GetListAll() bool {
	if m != nil {
		return m.ListAll
	}
	return false
}

// Dataset insert request.
type DatasetInsertRequest struct {
	// The dataset to be inserted.
	Resource             *Dataset `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatasetInsertRequest) Reset()         { *m = DatasetInsertRequest{} }
func (m *DatasetInsertRequest) String() string { return proto.CompactTextString(m) }
func (*DatasetInsertRequest) ProtoMessage()    {}
func (*DatasetInsertRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{6}
}
func (m *DatasetInsertRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatasetInsertRequest.Unmarshal(m, b)
}
func (m *DatasetInsertRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatasetInsertRequest.Marshal(b, m, deterministic)
}
func (dst *DatasetInsertRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatasetInsertRequest.Merge(dst, src)
}
func (m *DatasetInsertRequest) XXX_Size() int {
	return xxx_messageInfo_DatasetInsertRequest.Size(m)
}
func (m *DatasetInsertRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DatasetInsertRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DatasetInsertRequest proto.InternalMessageInfo

func (m *DatasetInsertRequest) GetResource() *Dataset {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Dataset insert response.
type DatasetInsertResponse struct {
	// Final state of the inserted dataset.
	Resource             *Dataset `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatasetInsertResponse) Reset()         { *m = DatasetInsertResponse{} }
func (m *DatasetInsertResponse) String() string { return proto.CompactTextString(m) }
func (*DatasetInsertResponse) ProtoMessage()    {}
func (*DatasetInsertResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{7}
}
func (m *DatasetInsertResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatasetInsertResponse.Unmarshal(m, b)
}
func (m *DatasetInsertResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatasetInsertResponse.Marshal(b, m, deterministic)
}
func (dst *DatasetInsertResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatasetInsertResponse.Merge(dst, src)
}
func (m *DatasetInsertResponse) XXX_Size() int {
	return xxx_messageInfo_DatasetInsertResponse.Size(m)
}
func (m *DatasetInsertResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DatasetInsertResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DatasetInsertResponse proto.InternalMessageInfo

func (m *DatasetInsertResponse) GetResource() *Dataset {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Dataset update request.
type DatasetUpdateRequest struct {
	// The dataset to be updated.
	Resource             *Dataset `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatasetUpdateRequest) Reset()         { *m = DatasetUpdateRequest{} }
func (m *DatasetUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*DatasetUpdateRequest) ProtoMessage()    {}
func (*DatasetUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{8}
}
func (m *DatasetUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatasetUpdateRequest.Unmarshal(m, b)
}
func (m *DatasetUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatasetUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *DatasetUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatasetUpdateRequest.Merge(dst, src)
}
func (m *DatasetUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_DatasetUpdateRequest.Size(m)
}
func (m *DatasetUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DatasetUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DatasetUpdateRequest proto.InternalMessageInfo

func (m *DatasetUpdateRequest) GetResource() *Dataset {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Dataset update response.
type DatasetUpdateResponse struct {
	// Final state of the updated dataset.
	Resource             *Dataset `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatasetUpdateResponse) Reset()         { *m = DatasetUpdateResponse{} }
func (m *DatasetUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*DatasetUpdateResponse) ProtoMessage()    {}
func (*DatasetUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{9}
}
func (m *DatasetUpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatasetUpdateResponse.Unmarshal(m, b)
}
func (m *DatasetUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatasetUpdateResponse.Marshal(b, m, deterministic)
}
func (dst *DatasetUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatasetUpdateResponse.Merge(dst, src)
}
func (m *DatasetUpdateResponse) XXX_Size() int {
	return xxx_messageInfo_DatasetUpdateResponse.Size(m)
}
func (m *DatasetUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DatasetUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DatasetUpdateResponse proto.InternalMessageInfo

func (m *DatasetUpdateResponse) GetResource() *Dataset {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Job insert request.
type JobInsertRequest struct {
	// Job insert request.
	Resource             *Job     `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobInsertRequest) Reset()         { *m = JobInsertRequest{} }
func (m *JobInsertRequest) String() string { return proto.CompactTextString(m) }
func (*JobInsertRequest) ProtoMessage()    {}
func (*JobInsertRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{10}
}
func (m *JobInsertRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobInsertRequest.Unmarshal(m, b)
}
func (m *JobInsertRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobInsertRequest.Marshal(b, m, deterministic)
}
func (dst *JobInsertRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobInsertRequest.Merge(dst, src)
}
func (m *JobInsertRequest) XXX_Size() int {
	return xxx_messageInfo_JobInsertRequest.Size(m)
}
func (m *JobInsertRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_JobInsertRequest.DiscardUnknown(m)
}

var xxx_messageInfo_JobInsertRequest proto.InternalMessageInfo

func (m *JobInsertRequest) GetResource() *Job {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Job insert response.
type JobInsertResponse struct {
	// Job insert response.
	Resource             *Job     `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobInsertResponse) Reset()         { *m = JobInsertResponse{} }
func (m *JobInsertResponse) String() string { return proto.CompactTextString(m) }
func (*JobInsertResponse) ProtoMessage()    {}
func (*JobInsertResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{11}
}
func (m *JobInsertResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobInsertResponse.Unmarshal(m, b)
}
func (m *JobInsertResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobInsertResponse.Marshal(b, m, deterministic)
}
func (dst *JobInsertResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobInsertResponse.Merge(dst, src)
}
func (m *JobInsertResponse) XXX_Size() int {
	return xxx_messageInfo_JobInsertResponse.Size(m)
}
func (m *JobInsertResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_JobInsertResponse.DiscardUnknown(m)
}

var xxx_messageInfo_JobInsertResponse proto.InternalMessageInfo

func (m *JobInsertResponse) GetResource() *Job {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Job query request.
type JobQueryRequest struct {
	// The query.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of results.
	MaxResults uint32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// The default dataset for tables that do not have a dataset specified.
	DefaultDataset *DatasetName `protobuf:"bytes,3,opt,name=default_dataset,json=defaultDataset,proto3" json:"default_dataset,omitempty"`
	// Project that the query should be charged to.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If true, don't actually run the job. Just check that it would run.
	DryRun               bool     `protobuf:"varint,5,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobQueryRequest) Reset()         { *m = JobQueryRequest{} }
func (m *JobQueryRequest) String() string { return proto.CompactTextString(m) }
func (*JobQueryRequest) ProtoMessage()    {}
func (*JobQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{12}
}
func (m *JobQueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobQueryRequest.Unmarshal(m, b)
}
func (m *JobQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobQueryRequest.Marshal(b, m, deterministic)
}
func (dst *JobQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobQueryRequest.Merge(dst, src)
}
func (m *JobQueryRequest) XXX_Size() int {
	return xxx_messageInfo_JobQueryRequest.Size(m)
}
func (m *JobQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_JobQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_JobQueryRequest proto.InternalMessageInfo

func (m *JobQueryRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *JobQueryRequest) GetMaxResults() uint32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *JobQueryRequest) GetDefaultDataset() *DatasetName {
	if m != nil {
		return m.DefaultDataset
	}
	return nil
}

func (m *JobQueryRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *JobQueryRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

// Job query response.
type JobQueryResponse struct {
	// The total number of rows in the full query result set.
	TotalResults uint64 `protobuf:"varint,1,opt,name=total_results,json=totalResults,proto3" json:"total_results,omitempty"`
	// Information about the queried job.
	Job                  *Job     `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobQueryResponse) Reset()         { *m = JobQueryResponse{} }
func (m *JobQueryResponse) String() string { return proto.CompactTextString(m) }
func (*JobQueryResponse) ProtoMessage()    {}
func (*JobQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{13}
}
func (m *JobQueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobQueryResponse.Unmarshal(m, b)
}
func (m *JobQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobQueryResponse.Marshal(b, m, deterministic)
}
func (dst *JobQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobQueryResponse.Merge(dst, src)
}
func (m *JobQueryResponse) XXX_Size() int {
	return xxx_messageInfo_JobQueryResponse.Size(m)
}
func (m *JobQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_JobQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_JobQueryResponse proto.InternalMessageInfo

func (m *JobQueryResponse) GetTotalResults() uint64 {
	if m != nil {
		return m.TotalResults
	}
	return 0
}

func (m *JobQueryResponse) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// Job getQueryResults request.
type JobGetQueryResultsRequest struct {
	// Maximum number of results to return.
	MaxResults uint32 `protobuf:"varint,1,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Zero-based row number at which to start.
	StartRow             uint64   `protobuf:"varint,2,opt,name=start_row,json=startRow,proto3" json:"start_row,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobGetQueryResultsRequest) Reset()         { *m = JobGetQueryResultsRequest{} }
func (m *JobGetQueryResultsRequest) String() string { return proto.CompactTextString(m) }
func (*JobGetQueryResultsRequest) ProtoMessage()    {}
func (*JobGetQueryResultsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{14}
}
func (m *JobGetQueryResultsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobGetQueryResultsRequest.Unmarshal(m, b)
}
func (m *JobGetQueryResultsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobGetQueryResultsRequest.Marshal(b, m, deterministic)
}
func (dst *JobGetQueryResultsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobGetQueryResultsRequest.Merge(dst, src)
}
func (m *JobGetQueryResultsRequest) XXX_Size() int {
	return xxx_messageInfo_JobGetQueryResultsRequest.Size(m)
}
func (m *JobGetQueryResultsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_JobGetQueryResultsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_JobGetQueryResultsRequest proto.InternalMessageInfo

func (m *JobGetQueryResultsRequest) GetMaxResults() uint32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *JobGetQueryResultsRequest) GetStartRow() uint64 {
	if m != nil {
		return m.StartRow
	}
	return 0
}

// Job getQueryResults response.
type JobGetQueryResultsResponse struct {
	// Total number of results in query results.
	TotalResults uint64 `protobuf:"varint,1,opt,name=total_results,json=totalResults,proto3" json:"total_results,omitempty"`
	// The job that was created to run the query.
	// It completed if `job.status.state` is `DONE`.
	// It failed if `job.status.errorResult` is also present.
	Job                  *Job     `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobGetQueryResultsResponse) Reset()         { *m = JobGetQueryResultsResponse{} }
func (m *JobGetQueryResultsResponse) String() string { return proto.CompactTextString(m) }
func (*JobGetQueryResultsResponse) ProtoMessage()    {}
func (*JobGetQueryResultsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{15}
}
func (m *JobGetQueryResultsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobGetQueryResultsResponse.Unmarshal(m, b)
}
func (m *JobGetQueryResultsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobGetQueryResultsResponse.Marshal(b, m, deterministic)
}
func (dst *JobGetQueryResultsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobGetQueryResultsResponse.Merge(dst, src)
}
func (m *JobGetQueryResultsResponse) XXX_Size() int {
	return xxx_messageInfo_JobGetQueryResultsResponse.Size(m)
}
func (m *JobGetQueryResultsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_JobGetQueryResultsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_JobGetQueryResultsResponse proto.InternalMessageInfo

func (m *JobGetQueryResultsResponse) GetTotalResults() uint64 {
	if m != nil {
		return m.TotalResults
	}
	return 0
}

func (m *JobGetQueryResultsResponse) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// Job getQueryDone response.
type JobQueryDoneResponse struct {
	// The job and status information.
	// The job completed if `job.status.state` is `DONE`.
	Job                  *Job     `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobQueryDoneResponse) Reset()         { *m = JobQueryDoneResponse{} }
func (m *JobQueryDoneResponse) String() string { return proto.CompactTextString(m) }
func (*JobQueryDoneResponse) ProtoMessage()    {}
func (*JobQueryDoneResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{16}
}
func (m *JobQueryDoneResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobQueryDoneResponse.Unmarshal(m, b)
}
func (m *JobQueryDoneResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobQueryDoneResponse.Marshal(b, m, deterministic)
}
func (dst *JobQueryDoneResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobQueryDoneResponse.Merge(dst, src)
}
func (m *JobQueryDoneResponse) XXX_Size() int {
	return xxx_messageInfo_JobQueryDoneResponse.Size(m)
}
func (m *JobQueryDoneResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_JobQueryDoneResponse.DiscardUnknown(m)
}

var xxx_messageInfo_JobQueryDoneResponse proto.InternalMessageInfo

func (m *JobQueryDoneResponse) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// Query job completed event.
type JobCompletedEvent struct {
	// Name of the event.
	EventName string `protobuf:"bytes,1,opt,name=event_name,json=eventName,proto3" json:"event_name,omitempty"`
	// Job information.
	Job                  *Job     `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobCompletedEvent) Reset()         { *m = JobCompletedEvent{} }
func (m *JobCompletedEvent) String() string { return proto.CompactTextString(m) }
func (*JobCompletedEvent) ProtoMessage()    {}
func (*JobCompletedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{17}
}
func (m *JobCompletedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobCompletedEvent.Unmarshal(m, b)
}
func (m *JobCompletedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobCompletedEvent.Marshal(b, m, deterministic)
}
func (dst *JobCompletedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobCompletedEvent.Merge(dst, src)
}
func (m *JobCompletedEvent) XXX_Size() int {
	return xxx_messageInfo_JobCompletedEvent.Size(m)
}
func (m *JobCompletedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_JobCompletedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_JobCompletedEvent proto.InternalMessageInfo

func (m *JobCompletedEvent) GetEventName() string {
	if m != nil {
		return m.EventName
	}
	return ""
}

func (m *JobCompletedEvent) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// Table data-list request.
type TableDataListRequest struct {
	// Starting row offset.
	StartRow uint64 `protobuf:"varint,1,opt,name=start_row,json=startRow,proto3" json:"start_row,omitempty"`
	// Maximum number of results to return.
	MaxResults           uint32   `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableDataListRequest) Reset()         { *m = TableDataListRequest{} }
func (m *TableDataListRequest) String() string { return proto.CompactTextString(m) }
func (*TableDataListRequest) ProtoMessage()    {}
func (*TableDataListRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{18}
}
func (m *TableDataListRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableDataListRequest.Unmarshal(m, b)
}
func (m *TableDataListRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableDataListRequest.Marshal(b, m, deterministic)
}
func (dst *TableDataListRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableDataListRequest.Merge(dst, src)
}
func (m *TableDataListRequest) XXX_Size() int {
	return xxx_messageInfo_TableDataListRequest.Size(m)
}
func (m *TableDataListRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TableDataListRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TableDataListRequest proto.InternalMessageInfo

func (m *TableDataListRequest) GetStartRow() uint64 {
	if m != nil {
		return m.StartRow
	}
	return 0
}

func (m *TableDataListRequest) GetMaxResults() uint32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

// Describes a BigQuery table.
// See the [Table](/bigquery/docs/reference/v2/tables) API resource
// for more details on individual fields.
// Note: `Table.schema` has been deprecated in favor of `Table.schemaJson`.
// `Table.schema` may continue to be present in your logs during this
// transition.
type Table struct {
	// The name of the table.
	TableName *TableName `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// User-provided metadata for the table.
	Info *TableInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// A JSON representation of the table's schema.
	SchemaJson string `protobuf:"bytes,8,opt,name=schema_json,json=schemaJson,proto3" json:"schema_json,omitempty"`
	// If present, this is a virtual table defined by a SQL query.
	View *TableViewDefinition `protobuf:"bytes,4,opt,name=view,proto3" json:"view,omitempty"`
	// The expiration date for the table, after which the table
	// is deleted and the storage reclaimed.
	// If not present, the table persists indefinitely.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// The time the table was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the table was last truncated
	// by an operation with a `writeDisposition` of `WRITE_TRUNCATE`.
	TruncateTime         *timestamp.Timestamp `protobuf:"bytes,7,opt,name=truncate_time,json=truncateTime,proto3" json:"truncate_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Table) Reset()         { *m = Table{} }
func (m *Table) String() string { return proto.CompactTextString(m) }
func (*Table) ProtoMessage()    {}
func (*Table) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{19}
}
func (m *Table) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Table.Unmarshal(m, b)
}
func (m *Table) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Table.Marshal(b, m, deterministic)
}
func (dst *Table) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Table.Merge(dst, src)
}
func (m *Table) XXX_Size() int {
	return xxx_messageInfo_Table.Size(m)
}
func (m *Table) XXX_DiscardUnknown() {
	xxx_messageInfo_Table.DiscardUnknown(m)
}

var xxx_messageInfo_Table proto.InternalMessageInfo

func (m *Table) GetTableName() *TableName {
	if m != nil {
		return m.TableName
	}
	return nil
}

func (m *Table) GetInfo() *TableInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Table) GetSchemaJson() string {
	if m != nil {
		return m.SchemaJson
	}
	return ""
}

func (m *Table) GetView() *TableViewDefinition {
	if m != nil {
		return m.View
	}
	return nil
}

func (m *Table) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

func (m *Table) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Table) GetTruncateTime() *timestamp.Timestamp {
	if m != nil {
		return m.TruncateTime
	}
	return nil
}

// User-provided metadata for a table.
type TableInfo struct {
	// A short name for the table, such as`"Analytics Data - Jan 2011"`.
	FriendlyName string `protobuf:"bytes,1,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// A long description, perhaps several paragraphs,
	// describing the table contents in detail.
	Description          string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableInfo) Reset()         { *m = TableInfo{} }
func (m *TableInfo) String() string { return proto.CompactTextString(m) }
func (*TableInfo) ProtoMessage()    {}
func (*TableInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{20}
}
func (m *TableInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableInfo.Unmarshal(m, b)
}
func (m *TableInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableInfo.Marshal(b, m, deterministic)
}
func (dst *TableInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableInfo.Merge(dst, src)
}
func (m *TableInfo) XXX_Size() int {
	return xxx_messageInfo_TableInfo.Size(m)
}
func (m *TableInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TableInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TableInfo proto.InternalMessageInfo

func (m *TableInfo) GetFriendlyName() string {
	if m != nil {
		return m.FriendlyName
	}
	return ""
}

func (m *TableInfo) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Describes a virtual table defined by a SQL query.
type TableViewDefinition struct {
	// SQL query defining the view.
	Query                string   `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableViewDefinition) Reset()         { *m = TableViewDefinition{} }
func (m *TableViewDefinition) String() string { return proto.CompactTextString(m) }
func (*TableViewDefinition) ProtoMessage()    {}
func (*TableViewDefinition) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{21}
}
func (m *TableViewDefinition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableViewDefinition.Unmarshal(m, b)
}
func (m *TableViewDefinition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableViewDefinition.Marshal(b, m, deterministic)
}
func (dst *TableViewDefinition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableViewDefinition.Merge(dst, src)
}
func (m *TableViewDefinition) XXX_Size() int {
	return xxx_messageInfo_TableViewDefinition.Size(m)
}
func (m *TableViewDefinition) XXX_DiscardUnknown() {
	xxx_messageInfo_TableViewDefinition.DiscardUnknown(m)
}

var xxx_messageInfo_TableViewDefinition proto.InternalMessageInfo

func (m *TableViewDefinition) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

// BigQuery dataset information.
// See the [Dataset](/bigquery/docs/reference/v2/datasets) API resource
// for more details on individual fields.
type Dataset struct {
	// The name of the dataset.
	DatasetName *DatasetName `protobuf:"bytes,1,opt,name=dataset_name,json=datasetName,proto3" json:"dataset_name,omitempty"`
	// User-provided metadata for the dataset.
	Info *DatasetInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// The time the dataset was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the dataset was last modified.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The access control list for the dataset.
	Acl *BigQueryAcl `protobuf:"bytes,6,opt,name=acl,proto3" json:"acl,omitempty"`
	// If this field is present, each table that does not specify an
	// expiration time is assigned an expiration time by adding this
	// duration to the table's `createTime`.  If this field is empty,
	// there is no default table expiration time.
	DefaultTableExpireDuration *duration.Duration `protobuf:"bytes,8,opt,name=default_table_expire_duration,json=defaultTableExpireDuration,proto3" json:"default_table_expire_duration,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}           `json:"-"`
	XXX_unrecognized           []byte             `json:"-"`
	XXX_sizecache              int32              `json:"-"`
}

func (m *Dataset) Reset()         { *m = Dataset{} }
func (m *Dataset) String() string { return proto.CompactTextString(m) }
func (*Dataset) ProtoMessage()    {}
func (*Dataset) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{22}
}
func (m *Dataset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Dataset.Unmarshal(m, b)
}
func (m *Dataset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Dataset.Marshal(b, m, deterministic)
}
func (dst *Dataset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Dataset.Merge(dst, src)
}
func (m *Dataset) XXX_Size() int {
	return xxx_messageInfo_Dataset.Size(m)
}
func (m *Dataset) XXX_DiscardUnknown() {
	xxx_messageInfo_Dataset.DiscardUnknown(m)
}

var xxx_messageInfo_Dataset proto.InternalMessageInfo

func (m *Dataset) GetDatasetName() *DatasetName {
	if m != nil {
		return m.DatasetName
	}
	return nil
}

func (m *Dataset) GetInfo() *DatasetInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Dataset) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Dataset) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Dataset) GetAcl() *BigQueryAcl {
	if m != nil {
		return m.Acl
	}
	return nil
}

func (m *Dataset) GetDefaultTableExpireDuration() *duration.Duration {
	if m != nil {
		return m.DefaultTableExpireDuration
	}
	return nil
}

// User-provided metadata for a dataset.
type DatasetInfo struct {
	// A short name for the dataset, such as`"Analytics Data 2011"`.
	FriendlyName string `protobuf:"bytes,1,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// A long description, perhaps several paragraphs,
	// describing the dataset contents in detail.
	Description          string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatasetInfo) Reset()         { *m = DatasetInfo{} }
func (m *DatasetInfo) String() string { return proto.CompactTextString(m) }
func (*DatasetInfo) ProtoMessage()    {}
func (*DatasetInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{23}
}
func (m *DatasetInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatasetInfo.Unmarshal(m, b)
}
func (m *DatasetInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatasetInfo.Marshal(b, m, deterministic)
}
func (dst *DatasetInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatasetInfo.Merge(dst, src)
}
func (m *DatasetInfo) XXX_Size() int {
	return xxx_messageInfo_DatasetInfo.Size(m)
}
func (m *DatasetInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DatasetInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DatasetInfo proto.InternalMessageInfo

func (m *DatasetInfo) GetFriendlyName() string {
	if m != nil {
		return m.FriendlyName
	}
	return ""
}

func (m *DatasetInfo) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// An access control list.
type BigQueryAcl struct {
	// Access control entry list.
	Entries              []*BigQueryAcl_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BigQueryAcl) Reset()         { *m = BigQueryAcl{} }
func (m *BigQueryAcl) String() string { return proto.CompactTextString(m) }
func (*BigQueryAcl) ProtoMessage()    {}
func (*BigQueryAcl) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{24}
}
func (m *BigQueryAcl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryAcl.Unmarshal(m, b)
}
func (m *BigQueryAcl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryAcl.Marshal(b, m, deterministic)
}
func (dst *BigQueryAcl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryAcl.Merge(dst, src)
}
func (m *BigQueryAcl) XXX_Size() int {
	return xxx_messageInfo_BigQueryAcl.Size(m)
}
func (m *BigQueryAcl) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryAcl.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryAcl proto.InternalMessageInfo

func (m *BigQueryAcl) GetEntries() []*BigQueryAcl_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// Access control entry.
type BigQueryAcl_Entry struct {
	// The granted role, which can be `READER`, `WRITER`, or `OWNER`.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// Grants access to a group identified by an email address.
	GroupEmail string `protobuf:"bytes,2,opt,name=group_email,json=groupEmail,proto3" json:"group_email,omitempty"`
	// Grants access to a user identified by an email address.
	UserEmail string `protobuf:"bytes,3,opt,name=user_email,json=userEmail,proto3" json:"user_email,omitempty"`
	// Grants access to all members of a domain.
	Domain string `protobuf:"bytes,4,opt,name=domain,proto3" json:"domain,omitempty"`
	// Grants access to special groups. Valid groups are `PROJECT_OWNERS`,
	// `PROJECT_READERS`, `PROJECT_WRITERS` and `ALL_AUTHENTICATED_USERS`.
	SpecialGroup string `protobuf:"bytes,5,opt,name=special_group,json=specialGroup,proto3" json:"special_group,omitempty"`
	// Grants access to a BigQuery View.
	ViewName             *TableName `protobuf:"bytes,6,opt,name=view_name,json=viewName,proto3" json:"view_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BigQueryAcl_Entry) Reset()         { *m = BigQueryAcl_Entry{} }
func (m *BigQueryAcl_Entry) String() string { return proto.CompactTextString(m) }
func (*BigQueryAcl_Entry) ProtoMessage()    {}
func (*BigQueryAcl_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{24, 0}
}
func (m *BigQueryAcl_Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryAcl_Entry.Unmarshal(m, b)
}
func (m *BigQueryAcl_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryAcl_Entry.Marshal(b, m, deterministic)
}
func (dst *BigQueryAcl_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryAcl_Entry.Merge(dst, src)
}
func (m *BigQueryAcl_Entry) XXX_Size() int {
	return xxx_messageInfo_BigQueryAcl_Entry.Size(m)
}
func (m *BigQueryAcl_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryAcl_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryAcl_Entry proto.InternalMessageInfo

func (m *BigQueryAcl_Entry) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *BigQueryAcl_Entry) GetGroupEmail() string {
	if m != nil {
		return m.GroupEmail
	}
	return ""
}

func (m *BigQueryAcl_Entry) GetUserEmail() string {
	if m != nil {
		return m.UserEmail
	}
	return ""
}

func (m *BigQueryAcl_Entry) GetDomain() string {
	if m != nil {
		return m.Domain
	}
	return ""
}

func (m *BigQueryAcl_Entry) GetSpecialGroup() string {
	if m != nil {
		return m.SpecialGroup
	}
	return ""
}

func (m *BigQueryAcl_Entry) GetViewName() *TableName {
	if m != nil {
		return m.ViewName
	}
	return nil
}

// Describes a job.
type Job struct {
	// Job name.
	JobName *JobName `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Job configuration.
	JobConfiguration *JobConfiguration `protobuf:"bytes,2,opt,name=job_configuration,json=jobConfiguration,proto3" json:"job_configuration,omitempty"`
	// Job status.
	JobStatus *JobStatus `protobuf:"bytes,3,opt,name=job_status,json=jobStatus,proto3" json:"job_status,omitempty"`
	// Job statistics.
	JobStatistics        *JobStatistics `protobuf:"bytes,4,opt,name=job_statistics,json=jobStatistics,proto3" json:"job_statistics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Job) Reset()         { *m = Job{} }
func (m *Job) String() string { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()    {}
func (*Job) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{25}
}
func (m *Job) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Job.Unmarshal(m, b)
}
func (m *Job) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Job.Marshal(b, m, deterministic)
}
func (dst *Job) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Job.Merge(dst, src)
}
func (m *Job) XXX_Size() int {
	return xxx_messageInfo_Job.Size(m)
}
func (m *Job) XXX_DiscardUnknown() {
	xxx_messageInfo_Job.DiscardUnknown(m)
}

var xxx_messageInfo_Job proto.InternalMessageInfo

func (m *Job) GetJobName() *JobName {
	if m != nil {
		return m.JobName
	}
	return nil
}

func (m *Job) GetJobConfiguration() *JobConfiguration {
	if m != nil {
		return m.JobConfiguration
	}
	return nil
}

func (m *Job) GetJobStatus() *JobStatus {
	if m != nil {
		return m.JobStatus
	}
	return nil
}

func (m *Job) GetJobStatistics() *JobStatistics {
	if m != nil {
		return m.JobStatistics
	}
	return nil
}

// Job configuration information.
// See the [Jobs](/bigquery/docs/reference/v2/jobs) API resource
// for more details on individual fields.
type JobConfiguration struct {
	// Job configuration information.
	//
	// Types that are valid to be assigned to Configuration:
	//	*JobConfiguration_Query_
	//	*JobConfiguration_Load_
	//	*JobConfiguration_Extract_
	//	*JobConfiguration_TableCopy_
	Configuration isJobConfiguration_Configuration `protobuf_oneof:"configuration"`
	// If true, don't actually run the job. Just check that it would run.
	DryRun               bool     `protobuf:"varint,9,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobConfiguration) Reset()         { *m = JobConfiguration{} }
func (m *JobConfiguration) String() string { return proto.CompactTextString(m) }
func (*JobConfiguration) ProtoMessage()    {}
func (*JobConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{26}
}
func (m *JobConfiguration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobConfiguration.Unmarshal(m, b)
}
func (m *JobConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobConfiguration.Marshal(b, m, deterministic)
}
func (dst *JobConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobConfiguration.Merge(dst, src)
}
func (m *JobConfiguration) XXX_Size() int {
	return xxx_messageInfo_JobConfiguration.Size(m)
}
func (m *JobConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_JobConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_JobConfiguration proto.InternalMessageInfo

type isJobConfiguration_Configuration interface {
	isJobConfiguration_Configuration()
}

type JobConfiguration_Query_ struct {
	Query *JobConfiguration_Query `protobuf:"bytes,5,opt,name=query,proto3,oneof"`
}

type JobConfiguration_Load_ struct {
	Load *JobConfiguration_Load `protobuf:"bytes,6,opt,name=load,proto3,oneof"`
}

type JobConfiguration_Extract_ struct {
	Extract *JobConfiguration_Extract `protobuf:"bytes,7,opt,name=extract,proto3,oneof"`
}

type JobConfiguration_TableCopy_ struct {
	TableCopy *JobConfiguration_TableCopy `protobuf:"bytes,8,opt,name=table_copy,json=tableCopy,proto3,oneof"`
}

func (*JobConfiguration_Query_) isJobConfiguration_Configuration() {}

func (*JobConfiguration_Load_) isJobConfiguration_Configuration() {}

func (*JobConfiguration_Extract_) isJobConfiguration_Configuration() {}

func (*JobConfiguration_TableCopy_) isJobConfiguration_Configuration() {}

func (m *JobConfiguration) GetConfiguration() isJobConfiguration_Configuration {
	if m != nil {
		return m.Configuration
	}
	return nil
}

func (m *JobConfiguration) GetQuery() *JobConfiguration_Query {
	if x, ok := m.GetConfiguration().(*JobConfiguration_Query_); ok {
		return x.Query
	}
	return nil
}

func (m *JobConfiguration) GetLoad() *JobConfiguration_Load {
	if x, ok := m.GetConfiguration().(*JobConfiguration_Load_); ok {
		return x.Load
	}
	return nil
}

func (m *JobConfiguration) GetExtract() *JobConfiguration_Extract {
	if x, ok := m.GetConfiguration().(*JobConfiguration_Extract_); ok {
		return x.Extract
	}
	return nil
}

func (m *JobConfiguration) GetTableCopy() *JobConfiguration_TableCopy {
	if x, ok := m.GetConfiguration().(*JobConfiguration_TableCopy_); ok {
		return x.TableCopy
	}
	return nil
}

func (m *JobConfiguration) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*JobConfiguration) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _JobConfiguration_OneofMarshaler, _JobConfiguration_OneofUnmarshaler, _JobConfiguration_OneofSizer, []interface{}{
		(*JobConfiguration_Query_)(nil),
		(*JobConfiguration_Load_)(nil),
		(*JobConfiguration_Extract_)(nil),
		(*JobConfiguration_TableCopy_)(nil),
	}
}

func _JobConfiguration_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*JobConfiguration)
	// configuration
	switch x := m.Configuration.(type) {
	case *JobConfiguration_Query_:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Query); err != nil {
			return err
		}
	case *JobConfiguration_Load_:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Load); err != nil {
			return err
		}
	case *JobConfiguration_Extract_:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Extract); err != nil {
			return err
		}
	case *JobConfiguration_TableCopy_:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TableCopy); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("JobConfiguration.Configuration has unexpected type %T", x)
	}
	return nil
}

func _JobConfiguration_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*JobConfiguration)
	switch tag {
	case 5: // configuration.query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobConfiguration_Query)
		err := b.DecodeMessage(msg)
		m.Configuration = &JobConfiguration_Query_{msg}
		return true, err
	case 6: // configuration.load
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobConfiguration_Load)
		err := b.DecodeMessage(msg)
		m.Configuration = &JobConfiguration_Load_{msg}
		return true, err
	case 7: // configuration.extract
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobConfiguration_Extract)
		err := b.DecodeMessage(msg)
		m.Configuration = &JobConfiguration_Extract_{msg}
		return true, err
	case 8: // configuration.table_copy
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobConfiguration_TableCopy)
		err := b.DecodeMessage(msg)
		m.Configuration = &JobConfiguration_TableCopy_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _JobConfiguration_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*JobConfiguration)
	// configuration
	switch x := m.Configuration.(type) {
	case *JobConfiguration_Query_:
		s := proto.Size(x.Query)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JobConfiguration_Load_:
		s := proto.Size(x.Load)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JobConfiguration_Extract_:
		s := proto.Size(x.Extract)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JobConfiguration_TableCopy_:
		s := proto.Size(x.TableCopy)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Describes a query job, which executes a SQL-like query.
type JobConfiguration_Query struct {
	// The SQL query to run.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The table where results are written.
	DestinationTable *TableName `protobuf:"bytes,2,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Describes when a job is allowed to create a table:
	// `CREATE_IF_NEEDED`, `CREATE_NEVER`.
	CreateDisposition string `protobuf:"bytes,3,opt,name=create_disposition,json=createDisposition,proto3" json:"create_disposition,omitempty"`
	// Describes how writes affect existing tables:
	// `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
	WriteDisposition string `protobuf:"bytes,4,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
	// If a table name is specified without a dataset in a query,
	// this dataset will be added to table name.
	DefaultDataset *DatasetName `protobuf:"bytes,5,opt,name=default_dataset,json=defaultDataset,proto3" json:"default_dataset,omitempty"`
	// Describes data sources outside BigQuery, if needed.
	TableDefinitions     []*TableDefinition `protobuf:"bytes,6,rep,name=table_definitions,json=tableDefinitions,proto3" json:"table_definitions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *JobConfiguration_Query) Reset()         { *m = JobConfiguration_Query{} }
func (m *JobConfiguration_Query) String() string { return proto.CompactTextString(m) }
func (*JobConfiguration_Query) ProtoMessage()    {}
func (*JobConfiguration_Query) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{26, 0}
}
func (m *JobConfiguration_Query) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobConfiguration_Query.Unmarshal(m, b)
}
func (m *JobConfiguration_Query) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobConfiguration_Query.Marshal(b, m, deterministic)
}
func (dst *JobConfiguration_Query) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobConfiguration_Query.Merge(dst, src)
}
func (m *JobConfiguration_Query) XXX_Size() int {
	return xxx_messageInfo_JobConfiguration_Query.Size(m)
}
func (m *JobConfiguration_Query) XXX_DiscardUnknown() {
	xxx_messageInfo_JobConfiguration_Query.DiscardUnknown(m)
}

var xxx_messageInfo_JobConfiguration_Query proto.InternalMessageInfo

func (m *JobConfiguration_Query) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *JobConfiguration_Query) GetDestinationTable() *TableName {
	if m != nil {
		return m.DestinationTable
	}
	return nil
}

func (m *JobConfiguration_Query) GetCreateDisposition() string {
	if m != nil {
		return m.CreateDisposition
	}
	return ""
}

func (m *JobConfiguration_Query) GetWriteDisposition() string {
	if m != nil {
		return m.WriteDisposition
	}
	return ""
}

func (m *JobConfiguration_Query) GetDefaultDataset() *DatasetName {
	if m != nil {
		return m.DefaultDataset
	}
	return nil
}

func (m *JobConfiguration_Query) GetTableDefinitions() []*TableDefinition {
	if m != nil {
		return m.TableDefinitions
	}
	return nil
}

// Describes a load job, which loads data from an external source via
// the  import pipeline.
type JobConfiguration_Load struct {
	// URIs for the data to be imported. Only Google Cloud Storage URIs are
	// supported.
	SourceUris []string `protobuf:"bytes,1,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
	// The table schema in JSON format representation of a TableSchema.
	SchemaJson string `protobuf:"bytes,6,opt,name=schema_json,json=schemaJson,proto3" json:"schema_json,omitempty"`
	// The table where the imported data is written.
	DestinationTable *TableName `protobuf:"bytes,3,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Describes when a job is allowed to create a table:
	// `CREATE_IF_NEEDED`, `CREATE_NEVER`.
	CreateDisposition string `protobuf:"bytes,4,opt,name=create_disposition,json=createDisposition,proto3" json:"create_disposition,omitempty"`
	// Describes how writes affect existing tables:
	// `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
	WriteDisposition     string   `protobuf:"bytes,5,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobConfiguration_Load) Reset()         { *m = JobConfiguration_Load{} }
func (m *JobConfiguration_Load) String() string { return proto.CompactTextString(m) }
func (*JobConfiguration_Load) ProtoMessage()    {}
func (*JobConfiguration_Load) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{26, 1}
}
func (m *JobConfiguration_Load) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobConfiguration_Load.Unmarshal(m, b)
}
func (m *JobConfiguration_Load) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobConfiguration_Load.Marshal(b, m, deterministic)
}
func (dst *JobConfiguration_Load) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobConfiguration_Load.Merge(dst, src)
}
func (m *JobConfiguration_Load) XXX_Size() int {
	return xxx_messageInfo_JobConfiguration_Load.Size(m)
}
func (m *JobConfiguration_Load) XXX_DiscardUnknown() {
	xxx_messageInfo_JobConfiguration_Load.DiscardUnknown(m)
}

var xxx_messageInfo_JobConfiguration_Load proto.InternalMessageInfo

func (m *JobConfiguration_Load) GetSourceUris() []string {
	if m != nil {
		return m.SourceUris
	}
	return nil
}

func (m *JobConfiguration_Load) GetSchemaJson() string {
	if m != nil {
		return m.SchemaJson
	}
	return ""
}

func (m *JobConfiguration_Load) GetDestinationTable() *TableName {
	if m != nil {
		return m.DestinationTable
	}
	return nil
}

func (m *JobConfiguration_Load) GetCreateDisposition() string {
	if m != nil {
		return m.CreateDisposition
	}
	return ""
}

func (m *JobConfiguration_Load) GetWriteDisposition() string {
	if m != nil {
		return m.WriteDisposition
	}
	return ""
}

// Describes an extract job, which exports data to an external source
// via the  export pipeline.
type JobConfiguration_Extract struct {
	// Google Cloud Storage URIs where extracted data should be written.
	DestinationUris []string `protobuf:"bytes,1,rep,name=destination_uris,json=destinationUris,proto3" json:"destination_uris,omitempty"`
	// The source table.
	SourceTable          *TableName `protobuf:"bytes,2,opt,name=source_table,json=sourceTable,proto3" json:"source_table,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *JobConfiguration_Extract) Reset()         { *m = JobConfiguration_Extract{} }
func (m *JobConfiguration_Extract) String() string { return proto.CompactTextString(m) }
func (*JobConfiguration_Extract) ProtoMessage()    {}
func (*JobConfiguration_Extract) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{26, 2}
}
func (m *JobConfiguration_Extract) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobConfiguration_Extract.Unmarshal(m, b)
}
func (m *JobConfiguration_Extract) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobConfiguration_Extract.Marshal(b, m, deterministic)
}
func (dst *JobConfiguration_Extract) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobConfiguration_Extract.Merge(dst, src)
}
func (m *JobConfiguration_Extract) XXX_Size() int {
	return xxx_messageInfo_JobConfiguration_Extract.Size(m)
}
func (m *JobConfiguration_Extract) XXX_DiscardUnknown() {
	xxx_messageInfo_JobConfiguration_Extract.DiscardUnknown(m)
}

var xxx_messageInfo_JobConfiguration_Extract proto.InternalMessageInfo

func (m *JobConfiguration_Extract) GetDestinationUris() []string {
	if m != nil {
		return m.DestinationUris
	}
	return nil
}

func (m *JobConfiguration_Extract) GetSourceTable() *TableName {
	if m != nil {
		return m.SourceTable
	}
	return nil
}

// Describes a copy job, which copies an existing table to another table.
type JobConfiguration_TableCopy struct {
	// Source tables.
	SourceTables []*TableName `protobuf:"bytes,1,rep,name=source_tables,json=sourceTables,proto3" json:"source_tables,omitempty"`
	// Destination table.
	DestinationTable *TableName `protobuf:"bytes,2,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Describes when a job is allowed to create a table:
	// `CREATE_IF_NEEDED`, `CREATE_NEVER`.
	CreateDisposition string `protobuf:"bytes,3,opt,name=create_disposition,json=createDisposition,proto3" json:"create_disposition,omitempty"`
	// Describes how writes affect existing tables:
	// `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
	WriteDisposition     string   `protobuf:"bytes,4,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobConfiguration_TableCopy) Reset()         { *m = JobConfiguration_TableCopy{} }
func (m *JobConfiguration_TableCopy) String() string { return proto.CompactTextString(m) }
func (*JobConfiguration_TableCopy) ProtoMessage()    {}
func (*JobConfiguration_TableCopy) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{26, 3}
}
func (m *JobConfiguration_TableCopy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobConfiguration_TableCopy.Unmarshal(m, b)
}
func (m *JobConfiguration_TableCopy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobConfiguration_TableCopy.Marshal(b, m, deterministic)
}
func (dst *JobConfiguration_TableCopy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobConfiguration_TableCopy.Merge(dst, src)
}
func (m *JobConfiguration_TableCopy) XXX_Size() int {
	return xxx_messageInfo_JobConfiguration_TableCopy.Size(m)
}
func (m *JobConfiguration_TableCopy) XXX_DiscardUnknown() {
	xxx_messageInfo_JobConfiguration_TableCopy.DiscardUnknown(m)
}

var xxx_messageInfo_JobConfiguration_TableCopy proto.InternalMessageInfo

func (m *JobConfiguration_TableCopy) GetSourceTables() []*TableName {
	if m != nil {
		return m.SourceTables
	}
	return nil
}

func (m *JobConfiguration_TableCopy) GetDestinationTable() *TableName {
	if m != nil {
		return m.DestinationTable
	}
	return nil
}

func (m *JobConfiguration_TableCopy) GetCreateDisposition() string {
	if m != nil {
		return m.CreateDisposition
	}
	return ""
}

func (m *JobConfiguration_TableCopy) GetWriteDisposition() string {
	if m != nil {
		return m.WriteDisposition
	}
	return ""
}

// Describes an external data source used in a query.
type TableDefinition struct {
	// Name of the table, used in queries.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Google Cloud Storage URIs for the data to be imported.
	SourceUris           []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableDefinition) Reset()         { *m = TableDefinition{} }
func (m *TableDefinition) String() string { return proto.CompactTextString(m) }
func (*TableDefinition) ProtoMessage()    {}
func (*TableDefinition) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{27}
}
func (m *TableDefinition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableDefinition.Unmarshal(m, b)
}
func (m *TableDefinition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableDefinition.Marshal(b, m, deterministic)
}
func (dst *TableDefinition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableDefinition.Merge(dst, src)
}
func (m *TableDefinition) XXX_Size() int {
	return xxx_messageInfo_TableDefinition.Size(m)
}
func (m *TableDefinition) XXX_DiscardUnknown() {
	xxx_messageInfo_TableDefinition.DiscardUnknown(m)
}

var xxx_messageInfo_TableDefinition proto.InternalMessageInfo

func (m *TableDefinition) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TableDefinition) GetSourceUris() []string {
	if m != nil {
		return m.SourceUris
	}
	return nil
}

// Running state of a job.
type JobStatus struct {
	// State of a job: `PENDING`, `RUNNING`, or `DONE`.
	State string `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	// If the job did not complete successfully, this field describes why.
	Error                *status.Status `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *JobStatus) Reset()         { *m = JobStatus{} }
func (m *JobStatus) String() string { return proto.CompactTextString(m) }
func (*JobStatus) ProtoMessage()    {}
func (*JobStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{28}
}
func (m *JobStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobStatus.Unmarshal(m, b)
}
func (m *JobStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobStatus.Marshal(b, m, deterministic)
}
func (dst *JobStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobStatus.Merge(dst, src)
}
func (m *JobStatus) XXX_Size() int {
	return xxx_messageInfo_JobStatus.Size(m)
}
func (m *JobStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_JobStatus.DiscardUnknown(m)
}

var xxx_messageInfo_JobStatus proto.InternalMessageInfo

func (m *JobStatus) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *JobStatus) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Job statistics that may change after a job starts.
type JobStatistics struct {
	// Time when the job was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the job started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time when the job ended.
	EndTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Total bytes processed for a job.
	TotalProcessedBytes int64 `protobuf:"varint,4,opt,name=total_processed_bytes,json=totalProcessedBytes,proto3" json:"total_processed_bytes,omitempty"`
	// Processed bytes, adjusted by the job's CPU usage.
	TotalBilledBytes int64 `protobuf:"varint,5,opt,name=total_billed_bytes,json=totalBilledBytes,proto3" json:"total_billed_bytes,omitempty"`
	// The tier assigned by CPU-based billing.
	BillingTier          int32    `protobuf:"varint,7,opt,name=billing_tier,json=billingTier,proto3" json:"billing_tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobStatistics) Reset()         { *m = JobStatistics{} }
func (m *JobStatistics) String() string { return proto.CompactTextString(m) }
func (*JobStatistics) ProtoMessage()    {}
func (*JobStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{29}
}
func (m *JobStatistics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobStatistics.Unmarshal(m, b)
}
func (m *JobStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobStatistics.Marshal(b, m, deterministic)
}
func (dst *JobStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobStatistics.Merge(dst, src)
}
func (m *JobStatistics) XXX_Size() int {
	return xxx_messageInfo_JobStatistics.Size(m)
}
func (m *JobStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_JobStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_JobStatistics proto.InternalMessageInfo

func (m *JobStatistics) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *JobStatistics) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *JobStatistics) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *JobStatistics) GetTotalProcessedBytes() int64 {
	if m != nil {
		return m.TotalProcessedBytes
	}
	return 0
}

func (m *JobStatistics) GetTotalBilledBytes() int64 {
	if m != nil {
		return m.TotalBilledBytes
	}
	return 0
}

func (m *JobStatistics) GetBillingTier() int32 {
	if m != nil {
		return m.BillingTier
	}
	return 0
}

// The fully-qualified name for a dataset.
type DatasetName struct {
	// The project ID.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The dataset ID within the project.
	DatasetId            string   `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatasetName) Reset()         { *m = DatasetName{} }
func (m *DatasetName) String() string { return proto.CompactTextString(m) }
func (*DatasetName) ProtoMessage()    {}
func (*DatasetName) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{30}
}
func (m *DatasetName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatasetName.Unmarshal(m, b)
}
func (m *DatasetName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatasetName.Marshal(b, m, deterministic)
}
func (dst *DatasetName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatasetName.Merge(dst, src)
}
func (m *DatasetName) XXX_Size() int {
	return xxx_messageInfo_DatasetName.Size(m)
}
func (m *DatasetName) XXX_DiscardUnknown() {
	xxx_messageInfo_DatasetName.DiscardUnknown(m)
}

var xxx_messageInfo_DatasetName proto.InternalMessageInfo

func (m *DatasetName) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DatasetName) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

// The fully-qualified name for a table.
type TableName struct {
	// The project ID.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The dataset ID within the project.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The table ID of the table within the dataset.
	TableId              string   `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableName) Reset()         { *m = TableName{} }
func (m *TableName) String() string { return proto.CompactTextString(m) }
func (*TableName) ProtoMessage()    {}
func (*TableName) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{31}
}
func (m *TableName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableName.Unmarshal(m, b)
}
func (m *TableName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableName.Marshal(b, m, deterministic)
}
func (dst *TableName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableName.Merge(dst, src)
}
func (m *TableName) XXX_Size() int {
	return xxx_messageInfo_TableName.Size(m)
}
func (m *TableName) XXX_DiscardUnknown() {
	xxx_messageInfo_TableName.DiscardUnknown(m)
}

var xxx_messageInfo_TableName proto.InternalMessageInfo

func (m *TableName) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *TableName) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *TableName) GetTableId() string {
	if m != nil {
		return m.TableId
	}
	return ""
}

// The fully-qualified name for a job.
type JobName struct {
	// The project ID.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job ID within the project.
	JobId                string   `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobName) Reset()         { *m = JobName{} }
func (m *JobName) String() string { return proto.CompactTextString(m) }
func (*JobName) ProtoMessage()    {}
func (*JobName) Descriptor() ([]byte, []int) {
	return fileDescriptor_audit_data_eac9a4c7657c5709, []int{32}
}
func (m *JobName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobName.Unmarshal(m, b)
}
func (m *JobName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobName.Marshal(b, m, deterministic)
}
func (dst *JobName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobName.Merge(dst, src)
}
func (m *JobName) XXX_Size() int {
	return xxx_messageInfo_JobName.Size(m)
}
func (m *JobName) XXX_DiscardUnknown() {
	xxx_messageInfo_JobName.DiscardUnknown(m)
}

var xxx_messageInfo_JobName proto.InternalMessageInfo

func (m *JobName) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *JobName) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func init() {
	proto.RegisterType((*AuditData)(nil), "google.cloud.bigquery.logging.v1.AuditData")
	proto.RegisterType((*TableInsertRequest)(nil), "google.cloud.bigquery.logging.v1.TableInsertRequest")
	proto.RegisterType((*TableUpdateRequest)(nil), "google.cloud.bigquery.logging.v1.TableUpdateRequest")
	proto.RegisterType((*TableInsertResponse)(nil), "google.cloud.bigquery.logging.v1.TableInsertResponse")
	proto.RegisterType((*TableUpdateResponse)(nil), "google.cloud.bigquery.logging.v1.TableUpdateResponse")
	proto.RegisterType((*DatasetListRequest)(nil), "google.cloud.bigquery.logging.v1.DatasetListRequest")
	proto.RegisterType((*DatasetInsertRequest)(nil), "google.cloud.bigquery.logging.v1.DatasetInsertRequest")
	proto.RegisterType((*DatasetInsertResponse)(nil), "google.cloud.bigquery.logging.v1.DatasetInsertResponse")
	proto.RegisterType((*DatasetUpdateRequest)(nil), "google.cloud.bigquery.logging.v1.DatasetUpdateRequest")
	proto.RegisterType((*DatasetUpdateResponse)(nil), "google.cloud.bigquery.logging.v1.DatasetUpdateResponse")
	proto.RegisterType((*JobInsertRequest)(nil), "google.cloud.bigquery.logging.v1.JobInsertRequest")
	proto.RegisterType((*JobInsertResponse)(nil), "google.cloud.bigquery.logging.v1.JobInsertResponse")
	proto.RegisterType((*JobQueryRequest)(nil), "google.cloud.bigquery.logging.v1.JobQueryRequest")
	proto.RegisterType((*JobQueryResponse)(nil), "google.cloud.bigquery.logging.v1.JobQueryResponse")
	proto.RegisterType((*JobGetQueryResultsRequest)(nil), "google.cloud.bigquery.logging.v1.JobGetQueryResultsRequest")
	proto.RegisterType((*JobGetQueryResultsResponse)(nil), "google.cloud.bigquery.logging.v1.JobGetQueryResultsResponse")
	proto.RegisterType((*JobQueryDoneResponse)(nil), "google.cloud.bigquery.logging.v1.JobQueryDoneResponse")
	proto.RegisterType((*JobCompletedEvent)(nil), "google.cloud.bigquery.logging.v1.JobCompletedEvent")
	proto.RegisterType((*TableDataListRequest)(nil), "google.cloud.bigquery.logging.v1.TableDataListRequest")
	proto.RegisterType((*Table)(nil), "google.cloud.bigquery.logging.v1.Table")
	proto.RegisterType((*TableInfo)(nil), "google.cloud.bigquery.logging.v1.TableInfo")
	proto.RegisterType((*TableViewDefinition)(nil), "google.cloud.bigquery.logging.v1.TableViewDefinition")
	proto.RegisterType((*Dataset)(nil), "google.cloud.bigquery.logging.v1.Dataset")
	proto.RegisterType((*DatasetInfo)(nil), "google.cloud.bigquery.logging.v1.DatasetInfo")
	proto.RegisterType((*BigQueryAcl)(nil), "google.cloud.bigquery.logging.v1.BigQueryAcl")
	proto.RegisterType((*BigQueryAcl_Entry)(nil), "google.cloud.bigquery.logging.v1.BigQueryAcl.Entry")
	proto.RegisterType((*Job)(nil), "google.cloud.bigquery.logging.v1.Job")
	proto.RegisterType((*JobConfiguration)(nil), "google.cloud.bigquery.logging.v1.JobConfiguration")
	proto.RegisterType((*JobConfiguration_Query)(nil), "google.cloud.bigquery.logging.v1.JobConfiguration.Query")
	proto.RegisterType((*JobConfiguration_Load)(nil), "google.cloud.bigquery.logging.v1.JobConfiguration.Load")
	proto.RegisterType((*JobConfiguration_Extract)(nil), "google.cloud.bigquery.logging.v1.JobConfiguration.Extract")
	proto.RegisterType((*JobConfiguration_TableCopy)(nil), "google.cloud.bigquery.logging.v1.JobConfiguration.TableCopy")
	proto.RegisterType((*TableDefinition)(nil), "google.cloud.bigquery.logging.v1.TableDefinition")
	proto.RegisterType((*JobStatus)(nil), "google.cloud.bigquery.logging.v1.JobStatus")
	proto.RegisterType((*JobStatistics)(nil), "google.cloud.bigquery.logging.v1.JobStatistics")
	proto.RegisterType((*DatasetName)(nil), "google.cloud.bigquery.logging.v1.DatasetName")
	proto.RegisterType((*TableName)(nil), "google.cloud.bigquery.logging.v1.TableName")
	proto.RegisterType((*JobName)(nil), "google.cloud.bigquery.logging.v1.JobName")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/logging/v1/audit_data.proto", fileDescriptor_audit_data_eac9a4c7657c5709)
}

var fileDescriptor_audit_data_eac9a4c7657c5709 = []byte{
	// 2036 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x59, 0x4f, 0x73, 0x1b, 0x49,
	0x15, 0x8f, 0x2c, 0xc9, 0x92, 0x9e, 0xec, 0xd8, 0xee, 0xd8, 0x9b, 0x58, 0x90, 0xdd, 0x30, 0x40,
	0xb1, 0x29, 0x13, 0xa9, 0x9c, 0x65, 0x09, 0x90, 0xad, 0x4a, 0xd9, 0xb1, 0x89, 0x93, 0xfd, 0x83,
	0x19, 0x1c, 0x17, 0xbb, 0xc5, 0xae, 0x6a, 0x34, 0xd3, 0xd6, 0xb6, 0x76, 0x34, 0x3d, 0x99, 0x69,
	0xc5, 0x31, 0x17, 0x0a, 0x8a, 0x1b, 0x47, 0x3e, 0x0c, 0x07, 0x2e, 0x50, 0x7c, 0x01, 0x8e, 0x5c,
	0xb8, 0xf0, 0x41, 0x28, 0xaa, 0x5f, 0x77, 0x8f, 0x66, 0x46, 0x72, 0x79, 0xc6, 0x68, 0x0f, 0x7b,
	0x9b, 0x79, 0xdd, 0xbf, 0xf7, 0xeb, 0x7e, 0xfd, 0xfe, 0xf5, 0x0c, 0xec, 0x0e, 0x39, 0x1f, 0xfa,
	0xb4, 0xe7, 0xfa, 0x7c, 0xe2, 0xf5, 0x06, 0x6c, 0xf8, 0x6a, 0x42, 0xa3, 0x8b, 0x9e, 0xcf, 0x87,
	0x43, 0x16, 0x0c, 0x7b, 0xaf, 0x77, 0x7b, 0xce, 0xc4, 0x63, 0xa2, 0xef, 0x39, 0xc2, 0xe9, 0x86,
	0x11, 0x17, 0x9c, 0xdc, 0x53, 0x90, 0x2e, 0x42, 0xba, 0x06, 0xd2, 0xd5, 0x90, 0xee, 0xeb, 0xdd,
	0xce, 0xb7, 0xb5, 0x52, 0x27, 0x64, 0x3d, 0x27, 0x08, 0xb8, 0x70, 0x04, 0xe3, 0x41, 0xac, 0xf0,
	0x9d, 0xb7, 0xf5, 0x28, 0xbe, 0x0d, 0x26, 0x67, 0x3d, 0x6f, 0x12, 0xe1, 0x04, 0x3d, 0xfe, 0x4e,
	0x7e, 0x5c, 0xb0, 0x31, 0x8d, 0x85, 0x33, 0x0e, 0xf5, 0x84, 0xdb, 0x7a, 0x42, 0x14, 0xba, 0xbd,
	0x58, 0x38, 0x62, 0xa2, 0x35, 0x5b, 0xff, 0x5e, 0x83, 0xd6, 0x9e, 0x5c, 0xee, 0x81, 0x23, 0x1c,
	0xf2, 0x25, 0x6c, 0x0a, 0x67, 0xe0, 0xd3, 0x3e, 0x0b, 0x62, 0x1a, 0x89, 0x7e, 0x44, 0x5f, 0x4d,
	0x68, 0x2c, 0xee, 0x54, 0xee, 0x55, 0xde, 0x6d, 0x3f, 0xfc, 0x51, 0xf7, 0xaa, 0x6d, 0x74, 0x4f,
	0x24, 0xfa, 0x39, 0x82, 0x6d, 0x85, 0x3d, 0xba, 0x61, 0x13, 0x31, 0x23, 0x9d, 0x32, 0x4d, 0x42,
	0xcf, 0x11, 0x34, 0x61, 0x5a, 0x2f, 0xc5, 0xf4, 0x12, 0xc1, 0x79, 0xa6, 0x8c, 0x54, 0x32, 0xc9,
	0x93, 0x88, 0xa9, 0xe8, 0xfb, 0x2c, 0x9e, 0xee, 0x69, 0xa9, 0x28, 0xd3, 0x81, 0x42, 0x7f, 0xc4,
	0xe2, 0xf4, 0x9e, 0xbc, 0x19, 0x29, 0x09, 0xe0, 0x2d, 0xc3, 0x94, 0xb3, 0x5f, 0x15, 0xb9, 0x7e,
	0x5c, 0x98, 0x2b, 0x6f, 0x41, 0xb3, 0x83, 0xac, 0x0d, 0x53, 0x7c, 0x39, 0x2b, 0xd6, 0x4a, 0xf2,
	0xe5, 0xed, 0x68, 0xf8, 0xb2, 0x96, 0x1c, 0x00, 0x19, 0xf1, 0x41, 0x7e, 0x6f, 0x75, 0xe4, 0x7a,
	0x78, 0x35, 0xd7, 0x0b, 0x3e, 0xc8, 0xef, 0x6b, 0x7d, 0x94, 0x93, 0x91, 0x3e, 0x6c, 0x48, 0x0e,
	0x04, 0x27, 0x14, 0xcb, 0x48, 0xb1, 0x5b, 0x88, 0xe2, 0x97, 0x52, 0x36, 0x65, 0x58, 0x1b, 0x65,
	0x45, 0xe4, 0x77, 0x70, 0x57, 0x12, 0x0c, 0xa9, 0x48, 0x48, 0xe2, 0x89, 0x2f, 0xe2, 0x84, 0xac,
	0x81, 0x64, 0x8f, 0x0b, 0x91, 0x3d, 0xa3, 0x42, 0x2b, 0x47, 0x1d, 0x53, 0xda, 0xed, 0xd1, 0x65,
	0x83, 0x84, 0xc3, 0x6d, 0xe5, 0xf9, 0xd2, 0xc6, 0x59, 0x97, 0x6c, 0x16, 0x3d, 0x36, 0x74, 0x7e,
	0x79, 0x76, 0x59, 0xa7, 0x54, 0x21, 0x95, 0x93, 0x93, 0xaf, 0x60, 0x2b, 0x17, 0xd4, 0x71, 0xc8,
	0x83, 0x98, 0xde, 0x69, 0x21, 0xdd, 0xfb, 0x25, 0xa3, 0x5a, 0x81, 0x8f, 0x2a, 0xf6, 0x2d, 0x31,
	0x2b, 0x9e, 0x92, 0x25, 0x1e, 0xa9, 0xc9, 0xa0, 0x14, 0x99, 0x71, 0xbc, 0x1c, 0x59, 0x56, 0x4c,
	0x5e, 0xc1, 0xed, 0x99, 0x80, 0xd3, 0x74, 0x6d, 0xa4, 0x7b, 0x54, 0x3a, 0xe2, 0x12, 0xc2, 0x2d,
	0x6f, 0xde, 0x40, 0x9a, 0x32, 0xbf, 0xc3, 0x95, 0x92, 0x94, 0x33, 0x7b, 0xdc, 0xf2, 0xe6, 0x0d,
	0x10, 0x0a, 0xb7, 0x32, 0x61, 0xa7, 0xe9, 0x08, 0xd2, 0xbd, 0x57, 0x2a, 0xee, 0x12, 0xaa, 0x8d,
	0x51, 0x5e, 0x68, 0xa2, 0x3b, 0x09, 0x0a, 0xc5, 0xb2, 0x5a, 0x22, 0xba, 0x8d, 0xb7, 0x1b, 0x92,
	0xf5, 0x51, 0x4e, 0x46, 0xfe, 0x50, 0x81, 0xb7, 0x2f, 0x8b, 0x3e, 0x4d, 0x78, 0x13, 0x09, 0x3f,
	0xb8, 0x5e, 0xf8, 0x25, 0xd4, 0x9d, 0xd1, 0xa5, 0xa3, 0x32, 0x00, 0xa7, 0x1b, 0xf5, 0x78, 0x90,
	0x3a, 0xc2, 0xb5, 0xa2, 0x01, 0x68, 0x76, 0x7b, 0xc0, 0x83, 0xf4, 0x09, 0x6e, 0x8e, 0xe6, 0xc8,
	0x89, 0xab, 0x0e, 0xd0, 0xe5, 0xe3, 0xd0, 0xa7, 0x82, 0x7a, 0x7d, 0xfa, 0x9a, 0x06, 0xe2, 0xce,
	0x46, 0x89, 0x03, 0x7c, 0x6a, 0xb0, 0x87, 0x12, 0x8a, 0xc7, 0x97, 0x15, 0xed, 0xb7, 0xa0, 0xa1,
	0xd3, 0xc8, 0x3e, 0x40, 0xd3, 0xec, 0xc8, 0xfa, 0x14, 0xc8, 0x6c, 0x4d, 0x26, 0x4f, 0x71, 0x06,
	0x9f, 0x44, 0x2e, 0xd5, 0xb5, 0xfd, 0x07, 0x05, 0x03, 0xd3, 0x4e, 0x80, 0x89, 0xea, 0x6c, 0x91,
	0x58, 0x88, 0xea, 0xcf, 0xe0, 0xd6, 0x9c, 0x9c, 0xb3, 0x58, 0xdd, 0xb9, 0x28, 0x5b, 0x88, 0xee,
	0x1e, 0x90, 0xd9, 0x6e, 0x81, 0x6c, 0x43, 0x13, 0xd3, 0xbc, 0xe3, 0xfb, 0xa8, 0xba, 0x69, 0x37,
	0xe4, 0xfb, 0x9e, 0xef, 0x5b, 0x9f, 0xc3, 0xe6, 0xbc, 0x92, 0x4f, 0x0e, 0x67, 0x56, 0x73, 0xbf,
	0x70, 0x5e, 0x49, 0xad, 0xe7, 0x0b, 0xd8, 0x9a, 0x9b, 0xdf, 0x16, 0xa5, 0x7f, 0xba, 0xfc, 0xac,
	0x13, 0x2c, 0x7c, 0xf9, 0xb9, 0xc3, 0x5a, 0x90, 0xfe, 0x97, 0xb0, 0x9e, 0x6f, 0x4a, 0xc8, 0xde,
	0x8c, 0xea, 0xef, 0x17, 0x8a, 0xd0, 0x94, 0xda, 0x53, 0xd8, 0x98, 0xc9, 0xb9, 0x8b, 0xd0, 0xfb,
	0xaf, 0x0a, 0xac, 0xe5, 0x3a, 0x1c, 0xb2, 0x09, 0x75, 0x44, 0xa1, 0xce, 0x96, 0xad, 0x5e, 0xc8,
	0x3b, 0xd0, 0x1e, 0x3b, 0x6f, 0x4c, 0x72, 0xc5, 0x56, 0x77, 0xd5, 0x86, 0xb1, 0xf3, 0x46, 0xe7,
	0x42, 0x72, 0x0a, 0x6b, 0x1e, 0x3d, 0x73, 0x26, 0xbe, 0xba, 0xa6, 0xc4, 0xd4, 0xf4, 0xa8, 0x0f,
	0x0a, 0xdb, 0xf1, 0x13, 0x67, 0x4c, 0xed, 0x9b, 0x5a, 0x8b, 0x96, 0x91, 0xbb, 0x00, 0x61, 0xc4,
	0x47, 0xd4, 0x15, 0x7d, 0xe6, 0x61, 0x1b, 0xda, 0xb2, 0x5b, 0x5a, 0xf2, 0xdc, 0x23, 0xb7, 0xa1,
	0xe1, 0xc9, 0xa4, 0x3f, 0x09, 0xb0, 0x6d, 0x6c, 0xda, 0xcb, 0x5e, 0x74, 0x61, 0x4f, 0x02, 0x2b,
	0xc4, 0x93, 0xc8, 0x16, 0x8b, 0xef, 0xc2, 0xaa, 0xe0, 0xc2, 0xf1, 0x93, 0x6d, 0xc8, 0x2d, 0xd6,
	0xec, 0x15, 0x14, 0x9a, 0x8d, 0x3c, 0x82, 0xea, 0x88, 0x0f, 0x74, 0x33, 0x5f, 0xd0, 0xa2, 0x12,
	0x61, 0x7d, 0x0a, 0xdb, 0x97, 0x36, 0x70, 0x79, 0xfb, 0x55, 0x66, 0xec, 0xf7, 0x2d, 0x68, 0xc5,
	0xc2, 0x91, 0xe5, 0x98, 0x9f, 0x23, 0x79, 0xcd, 0x6e, 0xa2, 0xc0, 0xe6, 0xe7, 0xd6, 0x6f, 0xa1,
	0x73, 0x79, 0x71, 0xfa, 0x9a, 0xb7, 0xf5, 0x0b, 0xd8, 0x9c, 0x57, 0x9b, 0x8c, 0xc2, 0x4a, 0x69,
	0x85, 0x5f, 0xa1, 0x33, 0x67, 0x8b, 0x8d, 0x3c, 0x66, 0xac, 0x61, 0xfd, 0xc0, 0x19, 0x53, 0xed,
	0x7a, 0x2d, 0x94, 0x48, 0xaf, 0xb8, 0xfe, 0xea, 0x4f, 0x60, 0x73, 0x5e, 0x6b, 0x9b, 0x35, 0x77,
	0x25, 0x6b, 0xee, 0x2b, 0x9d, 0xdd, 0xfa, 0x6b, 0x15, 0xea, 0xa8, 0x96, 0xbc, 0x00, 0x50, 0xdd,
	0x69, 0xb2, 0xee, 0xf6, 0xc3, 0x9d, 0x82, 0x69, 0x1e, 0xfd, 0xbd, 0x25, 0xcc, 0x23, 0x79, 0x02,
	0x35, 0x16, 0x9c, 0x71, 0xbd, 0xcb, 0x9d, 0xc2, 0x5d, 0xf4, 0x19, 0xb7, 0x11, 0x28, 0xd7, 0x1d,
	0xbb, 0x5f, 0xd2, 0xb1, 0xd3, 0x1f, 0xc5, 0x3c, 0xc0, 0xe6, 0xbf, 0x65, 0x83, 0x12, 0xbd, 0x88,
	0x79, 0x40, 0x9e, 0x43, 0xed, 0x35, 0xa3, 0xe7, 0xfa, 0x36, 0x57, 0xb4, 0x75, 0x3e, 0x65, 0xf4,
	0xfc, 0x80, 0x9e, 0xb1, 0x80, 0x09, 0xc6, 0x03, 0x1b, 0x55, 0x90, 0xc7, 0xd0, 0xa6, 0x6f, 0x42,
	0x16, 0xd1, 0xbe, 0x60, 0x63, 0xaa, 0xef, 0x6c, 0x1d, 0xa3, 0xd1, 0x7c, 0x36, 0xe8, 0x9e, 0x98,
	0xcf, 0x06, 0x36, 0xa8, 0xe9, 0x52, 0x20, 0xc1, 0x6e, 0x44, 0x65, 0xaf, 0x8b, 0xe0, 0xe5, 0xab,
	0xc1, 0x6a, 0x3a, 0x82, 0x9f, 0xc0, 0xaa, 0x88, 0x26, 0x81, 0x9b, 0xc0, 0x1b, 0x57, 0xc2, 0x57,
	0x0c, 0x40, 0x8a, 0x2c, 0x1b, 0x5a, 0x89, 0xe5, 0x64, 0xf0, 0x9c, 0x45, 0x8c, 0x06, 0x9e, 0x7f,
	0x91, 0xf6, 0xbd, 0x15, 0x23, 0xc4, 0x93, 0xb9, 0x07, 0x6d, 0x8f, 0xc6, 0x6e, 0xc4, 0x42, 0x69,
	0x01, 0x3c, 0xa0, 0x96, 0x9d, 0x16, 0x59, 0x3b, 0xba, 0x07, 0xc8, 0xda, 0x6a, 0x7e, 0x32, 0xb5,
	0xfe, 0x52, 0x85, 0x86, 0xc9, 0x6f, 0xc7, 0xb0, 0x62, 0xda, 0xff, 0x94, 0x0b, 0x95, 0x4c, 0x9a,
	0x6d, 0x6f, 0xfa, 0x42, 0xf6, 0x32, 0x6e, 0xf4, 0xa0, 0xc4, 0x85, 0x25, 0x71, 0xa4, 0xdc, 0xf9,
	0xd4, 0x4a, 0x9d, 0xcf, 0x63, 0x68, 0xeb, 0x8b, 0x4c, 0x51, 0xcf, 0x50, 0xd3, 0xf5, 0xe1, 0x56,
	0x1d, 0xd7, 0xd7, 0x1e, 0x51, 0x60, 0xed, 0xfb, 0x6c, 0x88, 0xa9, 0x69, 0xcf, 0xf5, 0x6d, 0x89,
	0x24, 0xbf, 0x81, 0xbb, 0xa6, 0x0e, 0xa9, 0xc0, 0xd4, 0x5e, 0x6a, 0xbe, 0x6f, 0xe9, 0x2b, 0xf1,
	0xf6, 0xcc, 0x7a, 0x0e, 0xf4, 0x04, 0xbb, 0xa3, 0xf1, 0x78, 0x9e, 0x87, 0x88, 0x36, 0x63, 0xd6,
	0x09, 0xb4, 0x53, 0xd6, 0x5a, 0x94, 0xf3, 0xfc, 0x7d, 0x09, 0xda, 0xa9, 0x8d, 0x90, 0x8f, 0xa1,
	0x41, 0x03, 0x11, 0x31, 0x2a, 0x53, 0x79, 0xb5, 0x58, 0x4b, 0x9f, 0xc2, 0x77, 0x0f, 0x03, 0x11,
	0x5d, 0xd8, 0x46, 0x47, 0xe7, 0x3f, 0x15, 0xa8, 0xa3, 0x88, 0x10, 0xa8, 0x45, 0xdc, 0x37, 0xcb,
	0xc4, 0x67, 0x99, 0x34, 0x86, 0x11, 0x9f, 0x84, 0x7d, 0x3a, 0x76, 0x98, 0xaf, 0x97, 0x07, 0x28,
	0x3a, 0x94, 0x12, 0x99, 0x9a, 0x27, 0x31, 0x8d, 0xf4, 0x78, 0x55, 0xa5, 0x66, 0x29, 0x51, 0xc3,
	0x6f, 0xc1, 0xb2, 0xc7, 0xc7, 0x0e, 0x0b, 0x74, 0x71, 0xd6, 0x6f, 0xd2, 0x36, 0x71, 0x48, 0x5d,
	0xe6, 0xf8, 0x7d, 0x54, 0x86, 0x8e, 0xd0, 0xb2, 0x57, 0xb4, 0xf0, 0x99, 0x94, 0x91, 0x23, 0x68,
	0xc9, 0x6c, 0xa2, 0x8c, 0xb7, 0x5c, 0x3e, 0x7b, 0x36, 0x25, 0x5a, 0x3e, 0x59, 0xff, 0x5c, 0x82,
	0xea, 0x0b, 0x3e, 0x20, 0x07, 0xd0, 0x94, 0x57, 0xa3, 0x54, 0x2c, 0xdd, 0x2f, 0x54, 0x2e, 0x50,
	0x5d, 0x63, 0xa4, 0x1e, 0xcc, 0x47, 0x23, 0x97, 0x07, 0x67, 0x6c, 0x68, 0x3c, 0x67, 0xa9, 0xc4,
	0xcd, 0xf5, 0x69, 0x1a, 0x89, 0xf7, 0xd6, 0x8c, 0x44, 0xd6, 0x0d, 0x49, 0xa0, 0xbe, 0x9c, 0xea,
	0x4e, 0x69, 0xa7, 0x90, 0xe6, 0x5f, 0x21, 0xc4, 0x6e, 0x8d, 0xcc, 0x23, 0x39, 0x85, 0x9b, 0x46,
	0x17, 0x8b, 0x05, 0x73, 0x63, 0x1d, 0xb0, 0xbd, 0xc2, 0xfa, 0x14, 0xcc, 0x5e, 0x1d, 0xa5, 0x5f,
	0xad, 0xbf, 0xb5, 0xb1, 0x87, 0xca, 0x2e, 0xfc, 0xd8, 0x64, 0x34, 0x15, 0xd7, 0x3f, 0x29, 0x6f,
	0x8d, 0x2e, 0xfa, 0xe9, 0xd1, 0x0d, 0xd3, 0x5a, 0x7e, 0x0c, 0x35, 0x9f, 0x3b, 0x9e, 0x3e, 0xfe,
	0x47, 0xd7, 0x50, 0xf8, 0x11, 0x77, 0xbc, 0xa3, 0x1b, 0x36, 0xaa, 0x21, 0xa7, 0xd0, 0xa0, 0x6f,
	0x44, 0xe4, 0xb8, 0xe6, 0xc3, 0xdb, 0xcf, 0xae, 0xa1, 0xf1, 0x50, 0x69, 0x38, 0xba, 0x61, 0x1b,
	0x65, 0xe4, 0x73, 0x53, 0xe9, 0x5d, 0x1e, 0x5e, 0xe8, 0x2c, 0xf2, 0xc1, 0x35, 0x54, 0xa3, 0xf3,
	0x3e, 0xe5, 0xa1, 0xb4, 0x80, 0x2a, 0xfe, 0xf2, 0x25, 0xdd, 0xc8, 0xb6, 0xd2, 0x8d, 0x6c, 0xe7,
	0x4f, 0x55, 0xa8, 0xa3, 0xc5, 0x2e, 0xe9, 0xcc, 0x7f, 0x0d, 0x1b, 0x1e, 0x8d, 0x05, 0x0b, 0x50,
	0xbd, 0x4a, 0x7a, 0x25, 0x5b, 0x08, 0xf4, 0xfd, 0xf5, 0x94, 0x16, 0xd5, 0xdb, 0x3c, 0x00, 0xa2,
	0xab, 0x80, 0xc7, 0xe2, 0x90, 0xc7, 0x58, 0xd2, 0x74, 0x02, 0xd8, 0x50, 0x23, 0x07, 0xd3, 0x01,
	0xb2, 0x03, 0x1b, 0xe7, 0x11, 0xcb, 0xcd, 0x56, 0x39, 0x61, 0x1d, 0x07, 0xd2, 0x93, 0xe7, 0x5c,
	0x17, 0xea, 0x8b, 0xb8, 0x2e, 0x7c, 0x01, 0x1b, 0xfa, 0x5b, 0x68, 0x52, 0x84, 0xe3, 0x3b, 0xcb,
	0x98, 0x44, 0x77, 0x8b, 0x7e, 0x05, 0x9d, 0xb6, 0x3a, 0xeb, 0x22, 0x2b, 0x88, 0x3b, 0xff, 0xad,
	0x40, 0x4d, 0xba, 0x1b, 0xf6, 0x5a, 0x78, 0x89, 0xea, 0x4f, 0x22, 0xa6, 0xf2, 0xb4, 0xec, 0xb5,
	0x50, 0xf4, 0x32, 0x62, 0x71, 0xbe, 0x19, 0x5b, 0x9e, 0x69, 0xc6, 0xe6, 0x1e, 0x5c, 0xf5, 0xeb,
	0x3b, 0xb8, 0x5a, 0xa9, 0x83, 0xab, 0xcf, 0x3f, 0xb8, 0xce, 0x1f, 0x2b, 0xd0, 0xd0, 0xd1, 0x41,
	0xee, 0x43, 0x9a, 0x3b, 0x6d, 0x88, 0xb5, 0x94, 0x1c, 0xad, 0xf1, 0x09, 0xac, 0x68, 0x73, 0x5d,
	0xdb, 0x41, 0xb5, 0xbd, 0x51, 0xd0, 0xf9, 0xf3, 0x92, 0x6e, 0xe2, 0x30, 0x78, 0x8e, 0x61, 0x35,
	0xad, 0xdd, 0x94, 0xcd, 0x52, 0xea, 0x57, 0x52, 0xea, 0xe3, 0x6f, 0x66, 0x54, 0xed, 0xaf, 0xc1,
	0x6a, 0xa6, 0x64, 0x59, 0x3f, 0x87, 0xb5, 0x9c, 0x4f, 0xcb, 0x1e, 0x20, 0xd5, 0xaa, 0xe0, 0x73,
	0xde, 0x99, 0x97, 0xf2, 0xce, 0x6c, 0x7d, 0x08, 0xad, 0xa4, 0xf4, 0xc8, 0x3c, 0x24, 0x6b, 0x8d,
	0x51, 0xa1, 0x5e, 0xc8, 0xbb, 0x50, 0xa7, 0x51, 0xc4, 0x23, 0x6d, 0x25, 0x62, 0xac, 0x14, 0x85,
	0x6e, 0x57, 0xd7, 0x2c, 0x35, 0xc1, 0xfa, 0xc7, 0x12, 0xac, 0x66, 0x0a, 0x4f, 0xbe, 0xdf, 0xac,
	0x94, 0xea, 0x37, 0x7f, 0x0a, 0xa0, 0xae, 0x72, 0x88, 0x5d, 0xba, 0x12, 0xab, 0x2e, 0x7e, 0x08,
	0x7d, 0x1f, 0x9a, 0x34, 0xf0, 0x14, 0xb0, 0x7a, 0x25, 0xb0, 0x41, 0x03, 0x0f, 0x61, 0x0f, 0x61,
	0x4b, 0x5d, 0xb8, 0xc3, 0x88, 0xbb, 0x34, 0x8e, 0xa9, 0xd7, 0x1f, 0x5c, 0x08, 0xaa, 0xea, 0x6e,
	0xd5, 0xbe, 0x85, 0x83, 0xc7, 0x66, 0x6c, 0x5f, 0x0e, 0x91, 0x1f, 0x02, 0x51, 0x98, 0x01, 0xf3,
	0xfd, 0x04, 0x50, 0x47, 0xc0, 0x3a, 0x8e, 0xec, 0xe3, 0x80, 0x9a, 0xfd, 0x1d, 0x58, 0x91, 0xf3,
	0x58, 0x30, 0xec, 0x0b, 0x46, 0x23, 0xac, 0x64, 0x75, 0xbb, 0xad, 0x65, 0x27, 0x8c, 0x46, 0xd6,
	0x87, 0x49, 0x2b, 0x8a, 0x1d, 0x4b, 0xf6, 0x3b, 0x49, 0x25, 0xff, 0x9d, 0xe4, 0x2e, 0x40, 0xf2,
	0x63, 0xc3, 0xd3, 0x4d, 0x5e, 0xcb, 0xfc, 0x90, 0xf0, 0x2c, 0x4f, 0x47, 0xd3, 0xff, 0xaf, 0x8a,
	0x6c, 0x43, 0x53, 0xff, 0x1c, 0xf2, 0xb4, 0x57, 0x37, 0xd4, 0x6f, 0x1d, 0xcf, 0x7a, 0x02, 0x0d,
	0xdd, 0x69, 0x5d, 0xc5, 0xb1, 0x05, 0xcb, 0xf8, 0x87, 0xc2, 0xe8, 0xaf, 0x8f, 0xf8, 0xe0, 0xb9,
	0xb7, 0xff, 0xfb, 0x0a, 0x7c, 0xcf, 0xe5, 0xe3, 0x2b, 0x03, 0x70, 0xff, 0x66, 0xf2, 0x07, 0xfa,
	0x58, 0x9e, 0xe3, 0x71, 0xe5, 0xb3, 0x67, 0x1a, 0x33, 0xe4, 0xbe, 0x13, 0x0c, 0xbb, 0x3c, 0x1a,
	0xf6, 0x86, 0x34, 0xc0, 0x53, 0xee, 0xa9, 0x21, 0x27, 0x64, 0xf1, 0xe5, 0xbf, 0xe0, 0x1f, 0xeb,
	0xc7, 0xc1, 0x32, 0x62, 0xde, 0xfb, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x76, 0x60, 0x19, 0x87,
	0xb5, 0x1f, 0x00, 0x00,
}
