package computervision

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"io"
)

// AzureRegions enumerates the values for azure regions.
type AzureRegions string

const (
	// Australiaeast ...
	Australiaeast AzureRegions = "australiaeast"
	// Brazilsouth ...
	Brazilsouth AzureRegions = "brazilsouth"
	// Eastasia ...
	Eastasia AzureRegions = "eastasia"
	// Eastus ...
	Eastus AzureRegions = "eastus"
	// Eastus2 ...
	Eastus2 AzureRegions = "eastus2"
	// Northeurope ...
	Northeurope AzureRegions = "northeurope"
	// Southcentralus ...
	Southcentralus AzureRegions = "southcentralus"
	// Southeastasia ...
	Southeastasia AzureRegions = "southeastasia"
	// Westcentralus ...
	Westcentralus AzureRegions = "westcentralus"
	// Westeurope ...
	Westeurope AzureRegions = "westeurope"
	// Westus ...
	Westus AzureRegions = "westus"
	// Westus2 ...
	Westus2 AzureRegions = "westus2"
)

// PossibleAzureRegionsValues returns an array of possible values for the AzureRegions const type.
func PossibleAzureRegionsValues() []AzureRegions {
	return []AzureRegions{Australiaeast, Brazilsouth, Eastasia, Eastus, Eastus2, Northeurope, Southcentralus, Southeastasia, Westcentralus, Westeurope, Westus, Westus2}
}

// Details enumerates the values for details.
type Details string

const (
	// Celebrities ...
	Celebrities Details = "Celebrities"
	// Landmarks ...
	Landmarks Details = "Landmarks"
)

// PossibleDetailsValues returns an array of possible values for the Details const type.
func PossibleDetailsValues() []Details {
	return []Details{Celebrities, Landmarks}
}

// ErrorCodes enumerates the values for error codes.
type ErrorCodes string

const (
	// BadArgument ...
	BadArgument ErrorCodes = "BadArgument"
	// FailedToProcess ...
	FailedToProcess ErrorCodes = "FailedToProcess"
	// InternalServerError ...
	InternalServerError ErrorCodes = "InternalServerError"
	// InvalidDetails ...
	InvalidDetails ErrorCodes = "InvalidDetails"
	// InvalidImageFormat ...
	InvalidImageFormat ErrorCodes = "InvalidImageFormat"
	// InvalidImageSize ...
	InvalidImageSize ErrorCodes = "InvalidImageSize"
	// InvalidImageURL ...
	InvalidImageURL ErrorCodes = "InvalidImageUrl"
	// NotSupportedImage ...
	NotSupportedImage ErrorCodes = "NotSupportedImage"
	// NotSupportedLanguage ...
	NotSupportedLanguage ErrorCodes = "NotSupportedLanguage"
	// NotSupportedVisualFeature ...
	NotSupportedVisualFeature ErrorCodes = "NotSupportedVisualFeature"
	// StorageException ...
	StorageException ErrorCodes = "StorageException"
	// Timeout ...
	Timeout ErrorCodes = "Timeout"
	// Unspecified ...
	Unspecified ErrorCodes = "Unspecified"
)

// PossibleErrorCodesValues returns an array of possible values for the ErrorCodes const type.
func PossibleErrorCodesValues() []ErrorCodes {
	return []ErrorCodes{BadArgument, FailedToProcess, InternalServerError, InvalidDetails, InvalidImageFormat, InvalidImageSize, InvalidImageURL, NotSupportedImage, NotSupportedLanguage, NotSupportedVisualFeature, StorageException, Timeout, Unspecified}
}

// Gender enumerates the values for gender.
type Gender string

const (
	// Female ...
	Female Gender = "Female"
	// Male ...
	Male Gender = "Male"
)

// PossibleGenderValues returns an array of possible values for the Gender const type.
func PossibleGenderValues() []Gender {
	return []Gender{Female, Male}
}

// OcrLanguages enumerates the values for ocr languages.
type OcrLanguages string

const (
	// Ar ...
	Ar OcrLanguages = "ar"
	// Cs ...
	Cs OcrLanguages = "cs"
	// Da ...
	Da OcrLanguages = "da"
	// De ...
	De OcrLanguages = "de"
	// El ...
	El OcrLanguages = "el"
	// En ...
	En OcrLanguages = "en"
	// Es ...
	Es OcrLanguages = "es"
	// Fi ...
	Fi OcrLanguages = "fi"
	// Fr ...
	Fr OcrLanguages = "fr"
	// Hu ...
	Hu OcrLanguages = "hu"
	// It ...
	It OcrLanguages = "it"
	// Ja ...
	Ja OcrLanguages = "ja"
	// Ko ...
	Ko OcrLanguages = "ko"
	// Nb ...
	Nb OcrLanguages = "nb"
	// Nl ...
	Nl OcrLanguages = "nl"
	// Pl ...
	Pl OcrLanguages = "pl"
	// Pt ...
	Pt OcrLanguages = "pt"
	// Ro ...
	Ro OcrLanguages = "ro"
	// Ru ...
	Ru OcrLanguages = "ru"
	// Sk ...
	Sk OcrLanguages = "sk"
	// SrCyrl ...
	SrCyrl OcrLanguages = "sr-Cyrl"
	// SrLatn ...
	SrLatn OcrLanguages = "sr-Latn"
	// Sv ...
	Sv OcrLanguages = "sv"
	// Tr ...
	Tr OcrLanguages = "tr"
	// Unk ...
	Unk OcrLanguages = "unk"
	// ZhHans ...
	ZhHans OcrLanguages = "zh-Hans"
	// ZhHant ...
	ZhHant OcrLanguages = "zh-Hant"
)

// PossibleOcrLanguagesValues returns an array of possible values for the OcrLanguages const type.
func PossibleOcrLanguagesValues() []OcrLanguages {
	return []OcrLanguages{Ar, Cs, Da, De, El, En, Es, Fi, Fr, Hu, It, Ja, Ko, Nb, Nl, Pl, Pt, Ro, Ru, Sk, SrCyrl, SrLatn, Sv, Tr, Unk, ZhHans, ZhHant}
}

// TextOperationStatusCodes enumerates the values for text operation status codes.
type TextOperationStatusCodes string

const (
	// Failed ...
	Failed TextOperationStatusCodes = "Failed"
	// NotStarted ...
	NotStarted TextOperationStatusCodes = "Not Started"
	// Running ...
	Running TextOperationStatusCodes = "Running"
	// Succeeded ...
	Succeeded TextOperationStatusCodes = "Succeeded"
)

// PossibleTextOperationStatusCodesValues returns an array of possible values for the TextOperationStatusCodes const type.
func PossibleTextOperationStatusCodesValues() []TextOperationStatusCodes {
	return []TextOperationStatusCodes{Failed, NotStarted, Running, Succeeded}
}

// VisualFeatureTypes enumerates the values for visual feature types.
type VisualFeatureTypes string

const (
	// VisualFeatureTypesAdult ...
	VisualFeatureTypesAdult VisualFeatureTypes = "Adult"
	// VisualFeatureTypesCategories ...
	VisualFeatureTypesCategories VisualFeatureTypes = "Categories"
	// VisualFeatureTypesColor ...
	VisualFeatureTypesColor VisualFeatureTypes = "Color"
	// VisualFeatureTypesDescription ...
	VisualFeatureTypesDescription VisualFeatureTypes = "Description"
	// VisualFeatureTypesFaces ...
	VisualFeatureTypesFaces VisualFeatureTypes = "Faces"
	// VisualFeatureTypesImageType ...
	VisualFeatureTypesImageType VisualFeatureTypes = "ImageType"
	// VisualFeatureTypesTags ...
	VisualFeatureTypesTags VisualFeatureTypes = "Tags"
)

// PossibleVisualFeatureTypesValues returns an array of possible values for the VisualFeatureTypes const type.
func PossibleVisualFeatureTypesValues() []VisualFeatureTypes {
	return []VisualFeatureTypes{VisualFeatureTypesAdult, VisualFeatureTypesCategories, VisualFeatureTypesColor, VisualFeatureTypesDescription, VisualFeatureTypesFaces, VisualFeatureTypesImageType, VisualFeatureTypesTags}
}

// AdultInfo an object describing whether the image contains adult-oriented content and/or is racy.
type AdultInfo struct {
	// IsAdultContent - A value indicating if the image contains adult-oriented content.
	IsAdultContent *bool `json:"isAdultContent,omitempty"`
	// IsRacyContent - A value indicating if the image is race.
	IsRacyContent *bool `json:"isRacyContent,omitempty"`
	// AdultScore - Score from 0 to 1 that indicates how much of adult content is within the image.
	AdultScore *float64 `json:"adultScore,omitempty"`
	// RacyScore - Score from 0 to 1 that indicates how suggestive is the image.
	RacyScore *float64 `json:"racyScore,omitempty"`
}

// Category an object describing identified category.
type Category struct {
	// Name - Name of the category.
	Name *string `json:"name,omitempty"`
	// Score - Scoring of the category.
	Score  *float64        `json:"score,omitempty"`
	Detail *CategoryDetail `json:"detail,omitempty"`
}

// CategoryDetail an object describing additional category details.
type CategoryDetail struct {
	// Celebrities - An array of celebrities if any identified.
	Celebrities *[]CelebritiesModel `json:"celebrities,omitempty"`
}

// CelebritiesModel an object describing possible celebrity identification.
type CelebritiesModel struct {
	// Name - Name of the celebrity.
	Name *string `json:"name,omitempty"`
	// Confidence - Level of confidence ranging from 0 to 1.
	Confidence    *float64       `json:"confidence,omitempty"`
	FaceRectangle *FaceRectangle `json:"faceRectangle,omitempty"`
}

// CelebrityResults list of celebrities recognized in the image.
type CelebrityResults struct {
	Celebrities *[]CelebritiesModel `json:"celebrities,omitempty"`
	// RequestID - Id of the REST API request.
	RequestID *string        `json:"requestId,omitempty"`
	Metadata  *ImageMetadata `json:"metadata,omitempty"`
}

// ColorInfo an object providing additional metadata describing color attributes.
type ColorInfo struct {
	// DominantColorForeground - Possible dominant foreground color.
	DominantColorForeground *string `json:"dominantColorForeground,omitempty"`
	// DominantColorBackground - Possible dominant background color.
	DominantColorBackground *string `json:"dominantColorBackground,omitempty"`
	// DominantColors - An array of possible dominant colors.
	DominantColors *[]string `json:"dominantColors,omitempty"`
	// AccentColor - Possible accent color.
	AccentColor *string `json:"accentColor,omitempty"`
	// IsBWImg - A value indicating if the image is black and white.
	IsBWImg *bool `json:"isBWImg,omitempty"`
}

// DomainModelResults result of image analysis using a specific domain model including additional metadata.
type DomainModelResults struct {
	autorest.Response `json:"-"`
	// Result - Model-specific response
	Result interface{} `json:"result,omitempty"`
	// RequestID - Id of the REST API request.
	RequestID *string        `json:"requestId,omitempty"`
	Metadata  *ImageMetadata `json:"metadata,omitempty"`
}

// Error ...
type Error struct {
	// Code - The error code. Possible values include: 'InvalidImageURL', 'InvalidImageFormat', 'InvalidImageSize', 'NotSupportedVisualFeature', 'NotSupportedImage', 'InvalidDetails', 'NotSupportedLanguage', 'BadArgument', 'FailedToProcess', 'Timeout', 'InternalServerError', 'Unspecified', 'StorageException'
	Code ErrorCodes `json:"code,omitempty"`
	// Message - A message explaining the error reported by the service.
	Message *string `json:"message,omitempty"`
	// RequestID - A unique request identifier.
	RequestID *string `json:"requestId,omitempty"`
}

// FaceDescription an object describing a face identified in the image.
type FaceDescription struct {
	// Age - Possible age of the face.
	Age *int32 `json:"age,omitempty"`
	// Gender - Possible gender of the face. Possible values include: 'Male', 'Female'
	Gender        Gender         `json:"gender,omitempty"`
	FaceRectangle *FaceRectangle `json:"faceRectangle,omitempty"`
}

// FaceRectangle an object describing face rectangle.
type FaceRectangle struct {
	// Left - X-coordinate of the top left point of the face.
	Left *int32 `json:"left,omitempty"`
	// Top - Y-coordinate of the top left point of the face.
	Top *int32 `json:"top,omitempty"`
	// Width - Width measured from the top-left point of the face.
	Width *int32 `json:"width,omitempty"`
	// Height - Height measured from the top-left point of the face.
	Height *int32 `json:"height,omitempty"`
}

// ImageAnalysis result of AnalyzeImage operation.
type ImageAnalysis struct {
	autorest.Response `json:"-"`
	// Categories - An array indicating identified categories.
	Categories *[]Category `json:"categories,omitempty"`
	Adult      *AdultInfo  `json:"adult,omitempty"`
	Color      *ColorInfo  `json:"color,omitempty"`
	ImageType  *ImageType  `json:"imageType,omitempty"`
	// Tags - A list of tags with confidence level.
	Tags        *[]ImageTag              `json:"tags,omitempty"`
	Description *ImageDescriptionDetails `json:"description,omitempty"`
	// Faces - An array of possible faces within the image.
	Faces *[]FaceDescription `json:"faces,omitempty"`
	// RequestID - Id of the request for tracking purposes.
	RequestID *string        `json:"requestId,omitempty"`
	Metadata  *ImageMetadata `json:"metadata,omitempty"`
}

// ImageCaption an image caption, i.e. a brief description of what the image depicts.
type ImageCaption struct {
	// Text - The text of the caption
	Text *string `json:"text,omitempty"`
	// Confidence - The level of confidence the service has in the caption
	Confidence *float64 `json:"confidence,omitempty"`
}

// ImageDescription a collection of content tags, along with a list of captions sorted by confidence level, and
// image metadata.
type ImageDescription struct {
	autorest.Response        `json:"-"`
	*ImageDescriptionDetails `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageDescription.
func (ID ImageDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ID.ImageDescriptionDetails != nil {
		objectMap["description"] = ID.ImageDescriptionDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImageDescription struct.
func (ID *ImageDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var imageDescriptionDetails ImageDescriptionDetails
				err = json.Unmarshal(*v, &imageDescriptionDetails)
				if err != nil {
					return err
				}
				ID.ImageDescriptionDetails = &imageDescriptionDetails
			}
		}
	}

	return nil
}

// ImageDescriptionDetails a collection of content tags, along with a list of captions sorted by confidence level,
// and image metadata.
type ImageDescriptionDetails struct {
	// Tags - A collection of image tags.
	Tags *[]string `json:"tags,omitempty"`
	// Captions - A list of captions, sorted by confidence level.
	Captions *[]ImageCaption `json:"captions,omitempty"`
	// RequestID - Id of the REST API request.
	RequestID *string        `json:"requestId,omitempty"`
	Metadata  *ImageMetadata `json:"metadata,omitempty"`
}

// ImageMetadata image metadata
type ImageMetadata struct {
	// Width - Image width
	Width *int32 `json:"width,omitempty"`
	// Height - Image height
	Height *int32 `json:"height,omitempty"`
	// Format - Image format
	Format *string `json:"format,omitempty"`
}

// ImageTag an image caption, i.e. a brief description of what the image depicts.
type ImageTag struct {
	// Name - The tag value
	Name *string `json:"name,omitempty"`
	// Confidence - The level of confidence the service has in the caption
	Confidence *float64 `json:"confidence,omitempty"`
}

// ImageType an object providing possible image types and matching confidence levels.
type ImageType struct {
	// ClipArtType - Confidence level that the image is a clip art.
	ClipArtType *float64 `json:"clipArtType,omitempty"`
	// LineDrawingType - Confidence level that the image is a line drawing.
	LineDrawingType *float64 `json:"lineDrawingType,omitempty"`
}

// ImageURL ...
type ImageURL struct {
	// URL - Publicly reachable URL of an image
	URL *string `json:"url,omitempty"`
}

// LandmarkResults list of landmarks recognized in the image.
type LandmarkResults struct {
	Landmarks *[]LandmarkResultsLandmarksItem `json:"landmarks,omitempty"`
	// RequestID - Id of the REST API request.
	RequestID *string        `json:"requestId,omitempty"`
	Metadata  *ImageMetadata `json:"metadata,omitempty"`
}

// LandmarkResultsLandmarksItem a landmark recognized in the image
type LandmarkResultsLandmarksItem struct {
	// Name - Name of the landmark.
	Name *string `json:"name,omitempty"`
	// Confidence - Confidence level for the landmark recognition.
	Confidence *float64 `json:"confidence,omitempty"`
}

// Line ...
type Line struct {
	BoundingBox *[]int32 `json:"boundingBox,omitempty"`
	Text        *string  `json:"text,omitempty"`
	Words       *[]Word  `json:"words,omitempty"`
}

// ListModelsResult result of the List Domain Models operation.
type ListModelsResult struct {
	autorest.Response `json:"-"`
	// ModelsProperty - An array of supported models.
	ModelsProperty *[]ModelDescription `json:"models,omitempty"`
}

// ModelDescription an object describing supported model by name and categories.
type ModelDescription struct {
	Name       *string   `json:"name,omitempty"`
	Categories *[]string `json:"categories,omitempty"`
}

// OcrLine an object describing a single recognized line of text.
type OcrLine struct {
	// BoundingBox - Bounding box of a recognized line. The four integers represent the x-coordinate of the left edge, the y-coordinate of the top edge, width, and height of the bounding box, in the coordinate system of the input image, after it has been rotated around its center according to the detected text angle (see textAngle property), with the origin at the top-left corner, and the y-axis pointing down.
	BoundingBox *string `json:"boundingBox,omitempty"`
	// Words - An array of objects, where each object represents a recognized word.
	Words *[]OcrWord `json:"words,omitempty"`
}

// OcrRegion a region consists of multiple lines (e.g. a column of text in a multi-column document).
type OcrRegion struct {
	// BoundingBox - Bounding box of a recognized region. The four integers represent the x-coordinate of the left edge, the y-coordinate of the top edge, width, and height of the bounding box, in the coordinate system of the input image, after it has been rotated around its center according to the detected text angle (see textAngle property), with the origin at the top-left corner, and the y-axis pointing down.
	BoundingBox *string    `json:"boundingBox,omitempty"`
	Lines       *[]OcrLine `json:"lines,omitempty"`
}

// OcrResult ...
type OcrResult struct {
	autorest.Response `json:"-"`
	// Language - The BCP-47 language code of the text in the image.
	Language *string `json:"language,omitempty"`
	// TextAngle - The angle, in degrees, of the detected text with respect to the closest horizontal or vertical direction. After rotating the input image clockwise by this angle, the recognized text lines become horizontal or vertical. In combination with the orientation property it can be used to overlay recognition results correctly on the original image, by rotating either the original image or recognition results by a suitable angle around the center of the original image. If the angle cannot be confidently detected, this property is not present. If the image contains text at different angles, only part of the text will be recognized correctly.
	TextAngle *float64 `json:"textAngle,omitempty"`
	// Orientation - Orientation of the text recognized in the image. The value (up,down,left, or right) refers to the direction that the top of the recognized text is facing, after the image has been rotated around its center according to the detected text angle (see textAngle property).
	Orientation *string `json:"orientation,omitempty"`
	// Regions - An array of objects, where each object represents a region of recognized text.
	Regions *[]OcrRegion `json:"regions,omitempty"`
}

// OcrWord information on a recognized word.
type OcrWord struct {
	// BoundingBox - Bounding box of a recognized word. The four integers represent the x-coordinate of the left edge, the y-coordinate of the top edge, width, and height of the bounding box, in the coordinate system of the input image, after it has been rotated around its center according to the detected text angle (see textAngle property), with the origin at the top-left corner, and the y-axis pointing down.
	BoundingBox *string `json:"boundingBox,omitempty"`
	// Text - String value of a recognized word.
	Text *string `json:"text,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RecognitionResult ...
type RecognitionResult struct {
	Lines *[]Line `json:"lines,omitempty"`
}

// TagResult the results of a image tag operation, including any tags and image metadata.
type TagResult struct {
	autorest.Response `json:"-"`
	// Tags - A list of tags with confidence level.
	Tags *[]ImageTag `json:"tags,omitempty"`
	// RequestID - Id of the REST API request.
	RequestID *string        `json:"requestId,omitempty"`
	Metadata  *ImageMetadata `json:"metadata,omitempty"`
}

// TextOperationResult ...
type TextOperationResult struct {
	autorest.Response `json:"-"`
	// Status - Status of the text operation. Possible values include: 'NotStarted', 'Running', 'Failed', 'Succeeded'
	Status            TextOperationStatusCodes `json:"status,omitempty"`
	RecognitionResult *RecognitionResult       `json:"recognitionResult,omitempty"`
}

// Word ...
type Word struct {
	BoundingBox *[]int32 `json:"boundingBox,omitempty"`
	Text        *string  `json:"text,omitempty"`
}
