package keyvault

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/keyvault/2015-06-01/keyvault"

// ActionType enumerates the values for action type.
type ActionType string

const (
	// AutoRenew ...
	AutoRenew ActionType = "AutoRenew"
	// EmailContacts ...
	EmailContacts ActionType = "EmailContacts"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{AutoRenew, EmailContacts}
}

// JSONWebKeyEncryptionAlgorithm enumerates the values for json web key encryption algorithm.
type JSONWebKeyEncryptionAlgorithm string

const (
	// RSA15 ...
	RSA15 JSONWebKeyEncryptionAlgorithm = "RSA1_5"
	// RSAOAEP ...
	RSAOAEP JSONWebKeyEncryptionAlgorithm = "RSA-OAEP"
	// RSAOAEP256 ...
	RSAOAEP256 JSONWebKeyEncryptionAlgorithm = "RSA-OAEP-256"
)

// PossibleJSONWebKeyEncryptionAlgorithmValues returns an array of possible values for the JSONWebKeyEncryptionAlgorithm const type.
func PossibleJSONWebKeyEncryptionAlgorithmValues() []JSONWebKeyEncryptionAlgorithm {
	return []JSONWebKeyEncryptionAlgorithm{RSA15, RSAOAEP, RSAOAEP256}
}

// JSONWebKeyOperation enumerates the values for json web key operation.
type JSONWebKeyOperation string

const (
	// Decrypt ...
	Decrypt JSONWebKeyOperation = "decrypt"
	// Encrypt ...
	Encrypt JSONWebKeyOperation = "encrypt"
	// Sign ...
	Sign JSONWebKeyOperation = "sign"
	// UnwrapKey ...
	UnwrapKey JSONWebKeyOperation = "unwrapKey"
	// Verify ...
	Verify JSONWebKeyOperation = "verify"
	// WrapKey ...
	WrapKey JSONWebKeyOperation = "wrapKey"
)

// PossibleJSONWebKeyOperationValues returns an array of possible values for the JSONWebKeyOperation const type.
func PossibleJSONWebKeyOperationValues() []JSONWebKeyOperation {
	return []JSONWebKeyOperation{Decrypt, Encrypt, Sign, UnwrapKey, Verify, WrapKey}
}

// JSONWebKeySignatureAlgorithm enumerates the values for json web key signature algorithm.
type JSONWebKeySignatureAlgorithm string

const (
	// PS256 ...
	PS256 JSONWebKeySignatureAlgorithm = "PS256"
	// PS384 ...
	PS384 JSONWebKeySignatureAlgorithm = "PS384"
	// PS512 ...
	PS512 JSONWebKeySignatureAlgorithm = "PS512"
	// RS256 ...
	RS256 JSONWebKeySignatureAlgorithm = "RS256"
	// RS384 ...
	RS384 JSONWebKeySignatureAlgorithm = "RS384"
	// RS512 ...
	RS512 JSONWebKeySignatureAlgorithm = "RS512"
	// RSNULL ...
	RSNULL JSONWebKeySignatureAlgorithm = "RSNULL"
)

// PossibleJSONWebKeySignatureAlgorithmValues returns an array of possible values for the JSONWebKeySignatureAlgorithm const type.
func PossibleJSONWebKeySignatureAlgorithmValues() []JSONWebKeySignatureAlgorithm {
	return []JSONWebKeySignatureAlgorithm{PS256, PS384, PS512, RS256, RS384, RS512, RSNULL}
}

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// EC ...
	EC JSONWebKeyType = "EC"
	// Oct ...
	Oct JSONWebKeyType = "oct"
	// RSA ...
	RSA JSONWebKeyType = "RSA"
	// RSAHSM ...
	RSAHSM JSONWebKeyType = "RSA-HSM"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{EC, Oct, RSA, RSAHSM}
}

// KeyUsageType enumerates the values for key usage type.
type KeyUsageType string

const (
	// CRLSign ...
	CRLSign KeyUsageType = "cRLSign"
	// DataEncipherment ...
	DataEncipherment KeyUsageType = "dataEncipherment"
	// DecipherOnly ...
	DecipherOnly KeyUsageType = "decipherOnly"
	// DigitalSignature ...
	DigitalSignature KeyUsageType = "digitalSignature"
	// EncipherOnly ...
	EncipherOnly KeyUsageType = "encipherOnly"
	// KeyAgreement ...
	KeyAgreement KeyUsageType = "keyAgreement"
	// KeyCertSign ...
	KeyCertSign KeyUsageType = "keyCertSign"
	// KeyEncipherment ...
	KeyEncipherment KeyUsageType = "keyEncipherment"
	// NonRepudiation ...
	NonRepudiation KeyUsageType = "nonRepudiation"
)

// PossibleKeyUsageTypeValues returns an array of possible values for the KeyUsageType const type.
func PossibleKeyUsageTypeValues() []KeyUsageType {
	return []KeyUsageType{CRLSign, DataEncipherment, DecipherOnly, DigitalSignature, EncipherOnly, KeyAgreement, KeyCertSign, KeyEncipherment, NonRepudiation}
}

// Action the action that will be executed.
type Action struct {
	// ActionType - The type of the action. Possible values include: 'EmailContacts', 'AutoRenew'
	ActionType ActionType `json:"action_type,omitempty"`
}

// AdministratorDetails details of the organization administrator of the certificate issuer
type AdministratorDetails struct {
	// FirstName - First name.
	FirstName *string `json:"first_name,omitempty"`
	// LastName - Last name.
	LastName *string `json:"last_name,omitempty"`
	// EmailAddress - Email address.
	EmailAddress *string `json:"email,omitempty"`
	// Phone - Phone number.
	Phone *string `json:"phone,omitempty"`
}

// Attributes the object attributes managed by the KeyVault service
type Attributes struct {
	// Enabled - Determines whether the object is enabled
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in UTC
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// BackupKeyResult the backup key result, containing the backup blob
type BackupKeyResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The backup blob containing the backed up key (a URL-encoded base64 string)
	Value *string `json:"value,omitempty"`
}

// CertificateAttributes the certificate management attributes
type CertificateAttributes struct {
	// Enabled - Determines whether the object is enabled
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in UTC
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// CertificateBundle a certificate bundle consists of a certificate (X509) plus its attributes.
type CertificateBundle struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The certificate id
	ID *string `json:"id,omitempty"`
	// Kid - READ-ONLY; The key id
	Kid *string `json:"kid,omitempty"`
	// Sid - READ-ONLY; The secret id
	Sid *string `json:"sid,omitempty"`
	// X509Thumbprint - READ-ONLY; Thumbprint of the certificate. (a URL-encoded base64 string)
	X509Thumbprint *string `json:"x5t,omitempty"`
	// Policy - READ-ONLY; The management policy.
	Policy *CertificatePolicy `json:"policy,omitempty"`
	// Cer - CER contents of x509 certificate.
	Cer *[]byte `json:"cer,omitempty"`
	// ContentType - The content type of the secret
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The certificate attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateBundle.
func (cb CertificateBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cb.Cer != nil {
		objectMap["cer"] = cb.Cer
	}
	if cb.ContentType != nil {
		objectMap["contentType"] = cb.ContentType
	}
	if cb.Attributes != nil {
		objectMap["attributes"] = cb.Attributes
	}
	if cb.Tags != nil {
		objectMap["tags"] = cb.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateCreateParameters the certificate create parameters
type CertificateCreateParameters struct {
	// CertificatePolicy - The management policy for the certificate
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional)
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateCreateParameters.
func (ccp CertificateCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.CertificatePolicy != nil {
		objectMap["policy"] = ccp.CertificatePolicy
	}
	if ccp.CertificateAttributes != nil {
		objectMap["attributes"] = ccp.CertificateAttributes
	}
	if ccp.Tags != nil {
		objectMap["tags"] = ccp.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateImportParameters the certificate import parameters
type CertificateImportParameters struct {
	// Base64EncodedCertificate - Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
	Base64EncodedCertificate *string `json:"value,omitempty"`
	// Password - If the private key in base64EncodedCertificate is encrypted, the password used for encryption
	Password *string `json:"pwd,omitempty"`
	// CertificatePolicy - The management policy for the certificate
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional)
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateImportParameters.
func (cip CertificateImportParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cip.Base64EncodedCertificate != nil {
		objectMap["value"] = cip.Base64EncodedCertificate
	}
	if cip.Password != nil {
		objectMap["pwd"] = cip.Password
	}
	if cip.CertificatePolicy != nil {
		objectMap["policy"] = cip.CertificatePolicy
	}
	if cip.CertificateAttributes != nil {
		objectMap["attributes"] = cip.CertificateAttributes
	}
	if cip.Tags != nil {
		objectMap["tags"] = cip.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateIssuerItem the certificate issuer item containing certificate issuer metadata
type CertificateIssuerItem struct {
	// ID - Certificate Identifier
	ID *string `json:"id,omitempty"`
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
}

// CertificateIssuerListResult the certificate issuer list result
type CertificateIssuerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of certificate issuers in the vault along with a link to the next page of certificate issuers
	Value *[]CertificateIssuerItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of certificate issuers.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateIssuerListResultIterator provides access to a complete listing of CertificateIssuerItem
// values.
type CertificateIssuerListResultIterator struct {
	i    int
	page CertificateIssuerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateIssuerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateIssuerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateIssuerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateIssuerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateIssuerListResultIterator) Response() CertificateIssuerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateIssuerListResultIterator) Value() CertificateIssuerItem {
	if !iter.page.NotDone() {
		return CertificateIssuerItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateIssuerListResultIterator type.
func NewCertificateIssuerListResultIterator(page CertificateIssuerListResultPage) CertificateIssuerListResultIterator {
	return CertificateIssuerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cilr CertificateIssuerListResult) IsEmpty() bool {
	return cilr.Value == nil || len(*cilr.Value) == 0
}

// certificateIssuerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cilr CertificateIssuerListResult) certificateIssuerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if cilr.NextLink == nil || len(to.String(cilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cilr.NextLink)))
}

// CertificateIssuerListResultPage contains a page of CertificateIssuerItem values.
type CertificateIssuerListResultPage struct {
	fn   func(context.Context, CertificateIssuerListResult) (CertificateIssuerListResult, error)
	cilr CertificateIssuerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateIssuerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateIssuerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cilr)
	if err != nil {
		return err
	}
	page.cilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateIssuerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateIssuerListResultPage) NotDone() bool {
	return !page.cilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateIssuerListResultPage) Response() CertificateIssuerListResult {
	return page.cilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateIssuerListResultPage) Values() []CertificateIssuerItem {
	if page.cilr.IsEmpty() {
		return nil
	}
	return *page.cilr.Value
}

// Creates a new instance of the CertificateIssuerListResultPage type.
func NewCertificateIssuerListResultPage(getNextPage func(context.Context, CertificateIssuerListResult) (CertificateIssuerListResult, error)) CertificateIssuerListResultPage {
	return CertificateIssuerListResultPage{fn: getNextPage}
}

// CertificateIssuerSetParameters the certificate issuer set parameters.
type CertificateIssuerSetParameters struct {
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// CertificateIssuerUpdateParameters the certificate issuer update parameters.
type CertificateIssuerUpdateParameters struct {
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// CertificateItem the certificate item containing certificate metadata
type CertificateItem struct {
	// ID - Certificate Identifier
	ID *string `json:"id,omitempty"`
	// Attributes - The certificate management attributes
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
	// X509Thumbprint - Thumbprint of the certificate. (a URL-encoded base64 string)
	X509Thumbprint *string `json:"x5t,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateItem.
func (ci CertificateItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.ID != nil {
		objectMap["id"] = ci.ID
	}
	if ci.Attributes != nil {
		objectMap["attributes"] = ci.Attributes
	}
	if ci.Tags != nil {
		objectMap["tags"] = ci.Tags
	}
	if ci.X509Thumbprint != nil {
		objectMap["x5t"] = ci.X509Thumbprint
	}
	return json.Marshal(objectMap)
}

// CertificateListResult the certificate list result
type CertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of certificates in the vault along with a link to the next page of certificates
	Value *[]CertificateItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of certificates.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateListResultIterator provides access to a complete listing of CertificateItem values.
type CertificateListResultIterator struct {
	i    int
	page CertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateListResultIterator) Response() CertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateListResultIterator) Value() CertificateItem {
	if !iter.page.NotDone() {
		return CertificateItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateListResultIterator type.
func NewCertificateListResultIterator(page CertificateListResultPage) CertificateListResultIterator {
	return CertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CertificateListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// certificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CertificateListResult) certificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CertificateListResultPage contains a page of CertificateItem values.
type CertificateListResultPage struct {
	fn  func(context.Context, CertificateListResult) (CertificateListResult, error)
	clr CertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateListResultPage) Response() CertificateListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateListResultPage) Values() []CertificateItem {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CertificateListResultPage type.
func NewCertificateListResultPage(getNextPage func(context.Context, CertificateListResult) (CertificateListResult, error)) CertificateListResultPage {
	return CertificateListResultPage{fn: getNextPage}
}

// CertificateMergeParameters the certificate merge parameters
type CertificateMergeParameters struct {
	// X509Certificates - The certificate or the certificate chain to merge
	X509Certificates *[][]byte `json:"x5c,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional)
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateMergeParameters.
func (cmp CertificateMergeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmp.X509Certificates != nil {
		objectMap["x5c"] = cmp.X509Certificates
	}
	if cmp.CertificateAttributes != nil {
		objectMap["attributes"] = cmp.CertificateAttributes
	}
	if cmp.Tags != nil {
		objectMap["tags"] = cmp.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateOperation a certificate operation is returned in case of async requests.
type CertificateOperation struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The certificate id
	ID *string `json:"id,omitempty"`
	// IssuerParameters - Parameters for the issuer of the X509 component of a certificate.
	IssuerParameters *IssuerParameters `json:"issuer,omitempty"`
	// Csr - The Certificate Signing Request (CSR) that is being used in the certificate operation.
	Csr *[]byte `json:"csr,omitempty"`
	// CancellationRequested - Indicates if cancellation was requested on the certificate operation.
	CancellationRequested *bool `json:"cancellation_requested,omitempty"`
	// Status - Status of the certificate operation.
	Status *string `json:"status,omitempty"`
	// StatusDetails - The status details of the certificate operation.
	StatusDetails *string `json:"status_details,omitempty"`
	// Error - Error encountered, if any, during the certificate operation.
	Error *Error `json:"error,omitempty"`
	// Target - Location which contains the result of the certificate operation.
	Target *string `json:"target,omitempty"`
	// RequestID - Identifier for the certificate operation.
	RequestID *string `json:"request_id,omitempty"`
}

// CertificateOperationUpdateParameter the certificate operation update parameters.
type CertificateOperationUpdateParameter struct {
	// CancellationRequested - Indicates if cancellation was requested on the certificate operation.
	CancellationRequested *bool `json:"cancellation_requested,omitempty"`
}

// CertificatePolicy management policy for a certificate.
type CertificatePolicy struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The certificate id
	ID *string `json:"id,omitempty"`
	// KeyProperties - Properties of the key backing a certificate.
	KeyProperties *KeyProperties `json:"key_props,omitempty"`
	// SecretProperties - Properties of the secret backing a certificate.
	SecretProperties *SecretProperties `json:"secret_props,omitempty"`
	// X509CertificateProperties - Properties of the X509 component of a certificate.
	X509CertificateProperties *X509CertificateProperties `json:"x509_props,omitempty"`
	// LifetimeActions - Actions that will be performed by Key Vault over the lifetime of a certificate.
	LifetimeActions *[]LifetimeAction `json:"lifetime_actions,omitempty"`
	// IssuerParameters - Parameters for the issuer of the X509 component of a certificate.
	IssuerParameters *IssuerParameters `json:"issuer,omitempty"`
	// Attributes - The certificate attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
}

// CertificateUpdateParameters the certificate update parameters
type CertificateUpdateParameters struct {
	// CertificatePolicy - The management policy for the certificate
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional)
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateUpdateParameters.
func (cup CertificateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.CertificatePolicy != nil {
		objectMap["policy"] = cup.CertificatePolicy
	}
	if cup.CertificateAttributes != nil {
		objectMap["attributes"] = cup.CertificateAttributes
	}
	if cup.Tags != nil {
		objectMap["tags"] = cup.Tags
	}
	return json.Marshal(objectMap)
}

// Contact the contact information for the vault certificates.
type Contact struct {
	// EmailAddress - Email address.
	EmailAddress *string `json:"email,omitempty"`
	// Name - Name.
	Name *string `json:"name,omitempty"`
	// Phone - Phone number.
	Phone *string `json:"phone,omitempty"`
}

// Contacts the contacts for the vault certificates.
type Contacts struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Identifier for the contacts collection.
	ID *string `json:"id,omitempty"`
	// ContactList - The contact list for the vault certificates.
	ContactList *[]Contact `json:"contacts,omitempty"`
}

// Error the key vault server error
type Error struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// ErrorType the key vault error exception
type ErrorType struct {
	// Error - READ-ONLY
	Error *Error `json:"error,omitempty"`
}

// IssuerAttributes the attributes of an issuer managed by the KeyVault service
type IssuerAttributes struct {
	// Enabled - Determines whether the issuer is enabled
	Enabled *bool `json:"enabled,omitempty"`
	// Created - READ-ONLY; Creation time in UTC
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// IssuerBundle the issuer for Key Vault certificate
type IssuerBundle struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Identifier for the issuer object.
	ID *string `json:"id,omitempty"`
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// IssuerCredentials the credentials to be used for the certificate issuer.
type IssuerCredentials struct {
	// AccountID - The user name/account name/account id.
	AccountID *string `json:"account_id,omitempty"`
	// Password - The password/secret/account key.
	Password *string `json:"pwd,omitempty"`
}

// IssuerParameters parameters for the issuer of the X509 component of a certificate.
type IssuerParameters struct {
	// Name - Name of the referenced issuer object or reserved names e.g. 'Self', 'Unknown'.
	Name *string `json:"name,omitempty"`
	// CertificateType - Type of certificate to be requested from the issuer provider.
	CertificateType *string `json:"cty,omitempty"`
}

// JSONWebKey as of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18
type JSONWebKey struct {
	// Kid - Key Identifier
	Kid *string `json:"kid,omitempty"`
	// Kty - Supported JsonWebKey key types (kty) for Elliptic Curve, RSA, HSM, Octet, usually RSA. Possible values include: 'EC', 'RSA', 'RSAHSM', 'Oct'
	Kty    JSONWebKeyType `json:"kty,omitempty"`
	KeyOps *[]string      `json:"key_ops,omitempty"`
	// N - RSA modulus (a URL-encoded base64 string)
	N *string `json:"n,omitempty"`
	// E - RSA public exponent (a URL-encoded base64 string)
	E *string `json:"e,omitempty"`
	// D - RSA private exponent (a URL-encoded base64 string)
	D *string `json:"d,omitempty"`
	// DP - RSA Private Key Parameter (a URL-encoded base64 string)
	DP *string `json:"dp,omitempty"`
	// DQ - RSA Private Key Parameter (a URL-encoded base64 string)
	DQ *string `json:"dq,omitempty"`
	// QI - RSA Private Key Parameter (a URL-encoded base64 string)
	QI *string `json:"qi,omitempty"`
	// P - RSA secret prime (a URL-encoded base64 string)
	P *string `json:"p,omitempty"`
	// Q - RSA secret prime, with p < q (a URL-encoded base64 string)
	Q *string `json:"q,omitempty"`
	// K - Symmetric key (a URL-encoded base64 string)
	K *string `json:"k,omitempty"`
	// T - HSM Token, used with Bring Your Own Key (a URL-encoded base64 string)
	T *string `json:"key_hsm,omitempty"`
}

// KeyAttributes the attributes of a key managed by the KeyVault service
type KeyAttributes struct {
	// Enabled - Determines whether the object is enabled
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in UTC
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// KeyBundle a KeyBundle consisting of a WebKey plus its Attributes
type KeyBundle struct {
	autorest.Response `json:"-"`
	// Key - The Json web key
	Key *JSONWebKey `json:"key,omitempty"`
	// Attributes - The key management attributes
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
	// Managed - READ-ONLY; True if the key's lifetime is managed by key vault i.e. if this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyBundle.
func (kb KeyBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kb.Key != nil {
		objectMap["key"] = kb.Key
	}
	if kb.Attributes != nil {
		objectMap["attributes"] = kb.Attributes
	}
	if kb.Tags != nil {
		objectMap["tags"] = kb.Tags
	}
	return json.Marshal(objectMap)
}

// KeyCreateParameters the key create parameters
type KeyCreateParameters struct {
	// Kty - The type of key to create. Valid key types, see JsonWebKeyType. Supported JsonWebKey key types (kty) for Elliptic Curve, RSA, HSM, Octet. Possible values include: 'EC', 'RSA', 'RSAHSM', 'Oct'
	Kty JSONWebKeyType `json:"kty,omitempty"`
	// KeySize - The key size in bits. e.g. 1024 or 2048.
	KeySize       *int32                 `json:"key_size,omitempty"`
	KeyOps        *[]JSONWebKeyOperation `json:"key_ops,omitempty"`
	KeyAttributes *KeyAttributes         `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for KeyCreateParameters.
func (kcp KeyCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kcp.Kty != "" {
		objectMap["kty"] = kcp.Kty
	}
	if kcp.KeySize != nil {
		objectMap["key_size"] = kcp.KeySize
	}
	if kcp.KeyOps != nil {
		objectMap["key_ops"] = kcp.KeyOps
	}
	if kcp.KeyAttributes != nil {
		objectMap["attributes"] = kcp.KeyAttributes
	}
	if kcp.Tags != nil {
		objectMap["tags"] = kcp.Tags
	}
	return json.Marshal(objectMap)
}

// KeyImportParameters the key import parameters
type KeyImportParameters struct {
	// Hsm - Whether to import as a hardware key (HSM) or software key
	Hsm *bool `json:"Hsm,omitempty"`
	// Key - The Json web key
	Key *JSONWebKey `json:"key,omitempty"`
	// KeyAttributes - The key management attributes
	KeyAttributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for KeyImportParameters.
func (kip KeyImportParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kip.Hsm != nil {
		objectMap["Hsm"] = kip.Hsm
	}
	if kip.Key != nil {
		objectMap["key"] = kip.Key
	}
	if kip.KeyAttributes != nil {
		objectMap["attributes"] = kip.KeyAttributes
	}
	if kip.Tags != nil {
		objectMap["tags"] = kip.Tags
	}
	return json.Marshal(objectMap)
}

// KeyItem the key item containing key metadata
type KeyItem struct {
	// Kid - Key Identifier
	Kid *string `json:"kid,omitempty"`
	// Attributes - The key management attributes
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
	// Managed - READ-ONLY; True if the key's lifetime is managed by key vault i.e. if this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyItem.
func (ki KeyItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ki.Kid != nil {
		objectMap["kid"] = ki.Kid
	}
	if ki.Attributes != nil {
		objectMap["attributes"] = ki.Attributes
	}
	if ki.Tags != nil {
		objectMap["tags"] = ki.Tags
	}
	return json.Marshal(objectMap)
}

// KeyListResult the key list result
type KeyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of keys in the vault along with a link to the next page of keys
	Value *[]KeyItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// KeyListResultIterator provides access to a complete listing of KeyItem values.
type KeyListResultIterator struct {
	i    int
	page KeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *KeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *KeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter KeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter KeyListResultIterator) Response() KeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter KeyListResultIterator) Value() KeyItem {
	if !iter.page.NotDone() {
		return KeyItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the KeyListResultIterator type.
func NewKeyListResultIterator(page KeyListResultPage) KeyListResultIterator {
	return KeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (klr KeyListResult) IsEmpty() bool {
	return klr.Value == nil || len(*klr.Value) == 0
}

// keyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (klr KeyListResult) keyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if klr.NextLink == nil || len(to.String(klr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(klr.NextLink)))
}

// KeyListResultPage contains a page of KeyItem values.
type KeyListResultPage struct {
	fn  func(context.Context, KeyListResult) (KeyListResult, error)
	klr KeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *KeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.klr)
	if err != nil {
		return err
	}
	page.klr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *KeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page KeyListResultPage) NotDone() bool {
	return !page.klr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page KeyListResultPage) Response() KeyListResult {
	return page.klr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page KeyListResultPage) Values() []KeyItem {
	if page.klr.IsEmpty() {
		return nil
	}
	return *page.klr.Value
}

// Creates a new instance of the KeyListResultPage type.
func NewKeyListResultPage(getNextPage func(context.Context, KeyListResult) (KeyListResult, error)) KeyListResultPage {
	return KeyListResultPage{fn: getNextPage}
}

// KeyOperationResult the key operation result
type KeyOperationResult struct {
	autorest.Response `json:"-"`
	// Kid - READ-ONLY; Key identifier
	Kid *string `json:"kid,omitempty"`
	// Result - READ-ONLY; a URL-encoded base64 string
	Result *string `json:"value,omitempty"`
}

// KeyOperationsParameters the key operations parameters
type KeyOperationsParameters struct {
	// Algorithm - algorithm identifier. Possible values include: 'RSAOAEP', 'RSAOAEP256', 'RSA15'
	Algorithm JSONWebKeyEncryptionAlgorithm `json:"alg,omitempty"`
	// Value - a URL-encoded base64 string
	Value *string `json:"value,omitempty"`
}

// KeyProperties properties of the key pair backing a certificate.
type KeyProperties struct {
	// Exportable - Indicates if the private key can be exported.
	Exportable *bool `json:"exportable,omitempty"`
	// KeyType - The key type.
	KeyType *string `json:"kty,omitempty"`
	// KeySize - The key size in bits. e.g. 2048.
	KeySize *int32 `json:"key_size,omitempty"`
	// ReuseKey - Indicates if the same key pair will be used on certificate renewal.
	ReuseKey *bool `json:"reuse_key,omitempty"`
}

// KeyRestoreParameters the key restore parameters
type KeyRestoreParameters struct {
	// KeyBundleBackup - the backup blob associated with a key bundle (a URL-encoded base64 string)
	KeyBundleBackup *string `json:"value,omitempty"`
}

// KeySignParameters the key operations parameters
type KeySignParameters struct {
	// Algorithm - The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL'
	Algorithm JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`
	// Value - a URL-encoded base64 string
	Value *string `json:"value,omitempty"`
}

// KeyUpdateParameters the key update parameters
type KeyUpdateParameters struct {
	// KeyOps - Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
	KeyOps        *[]JSONWebKeyOperation `json:"key_ops,omitempty"`
	KeyAttributes *KeyAttributes         `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for KeyUpdateParameters.
func (kup KeyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kup.KeyOps != nil {
		objectMap["key_ops"] = kup.KeyOps
	}
	if kup.KeyAttributes != nil {
		objectMap["attributes"] = kup.KeyAttributes
	}
	if kup.Tags != nil {
		objectMap["tags"] = kup.Tags
	}
	return json.Marshal(objectMap)
}

// KeyVerifyParameters the key verify parameters
type KeyVerifyParameters struct {
	// Algorithm - The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL'
	Algorithm JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`
	// Digest - The digest used for signing (a URL-encoded base64 string)
	Digest *string `json:"digest,omitempty"`
	// Signature - The signature to be verified (a URL-encoded base64 string)
	Signature *string `json:"value,omitempty"`
}

// KeyVerifyResult the key verify result
type KeyVerifyResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; true if the signature is verified, false otherwise.
	Value *bool `json:"value,omitempty"`
}

// LifetimeAction action and its trigger that will be performed by Key Vault over the lifetime of a
// certificate.
type LifetimeAction struct {
	// Trigger - The condition that will execute the action.
	Trigger *Trigger `json:"trigger,omitempty"`
	// Action - The action that will be executed.
	Action *Action `json:"action,omitempty"`
}

// OrganizationDetails details of the organization of the certificate issuer.
type OrganizationDetails struct {
	// ID - Id of the organization.
	ID *string `json:"id,omitempty"`
	// AdminDetails - Details of the organization administrator.
	AdminDetails *[]AdministratorDetails `json:"admin_details,omitempty"`
}

// PendingCertificateSigningRequestResult the pending certificate signing request result
type PendingCertificateSigningRequestResult struct {
	// Value - READ-ONLY; The pending certificate signing request as Base64 encoded string.
	Value *string `json:"value,omitempty"`
}

// SecretAttributes the secret management attributes
type SecretAttributes struct {
	// Enabled - Determines whether the object is enabled
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in UTC
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in UTC
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// SecretBundle a Secret consisting of a value, id and its attributes.
type SecretBundle struct {
	autorest.Response `json:"-"`
	// Value - The secret value
	Value *string `json:"value,omitempty"`
	// ID - The secret id
	ID *string `json:"id,omitempty"`
	// ContentType - The content type of the secret
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The secret management attributes
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
	// Kid - READ-ONLY; If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV certificate.
	Kid *string `json:"kid,omitempty"`
	// Managed - READ-ONLY; True if the secret's lifetime is managed by key vault i.e. if this is a secret backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretBundle.
func (sb SecretBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sb.Value != nil {
		objectMap["value"] = sb.Value
	}
	if sb.ID != nil {
		objectMap["id"] = sb.ID
	}
	if sb.ContentType != nil {
		objectMap["contentType"] = sb.ContentType
	}
	if sb.Attributes != nil {
		objectMap["attributes"] = sb.Attributes
	}
	if sb.Tags != nil {
		objectMap["tags"] = sb.Tags
	}
	return json.Marshal(objectMap)
}

// SecretItem the secret item containing secret metadata
type SecretItem struct {
	// ID - Secret Identifier
	ID *string `json:"id,omitempty"`
	// Attributes - The secret management attributes
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
	// ContentType - Type of the secret value such as a password
	ContentType *string `json:"contentType,omitempty"`
	// Managed - READ-ONLY; True if the secret's lifetime is managed by key vault i.e. if this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretItem.
func (si SecretItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.ID != nil {
		objectMap["id"] = si.ID
	}
	if si.Attributes != nil {
		objectMap["attributes"] = si.Attributes
	}
	if si.Tags != nil {
		objectMap["tags"] = si.Tags
	}
	if si.ContentType != nil {
		objectMap["contentType"] = si.ContentType
	}
	return json.Marshal(objectMap)
}

// SecretListResult the secret list result
type SecretListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A response message containing a list of secrets in the vault along with a link to the next page of secrets
	Value *[]SecretItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of secrets.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecretListResultIterator provides access to a complete listing of SecretItem values.
type SecretListResultIterator struct {
	i    int
	page SecretListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecretListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecretListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecretListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecretListResultIterator) Response() SecretListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecretListResultIterator) Value() SecretItem {
	if !iter.page.NotDone() {
		return SecretItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecretListResultIterator type.
func NewSecretListResultIterator(page SecretListResultPage) SecretListResultIterator {
	return SecretListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SecretListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// secretListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SecretListResult) secretListResultPreparer(ctx context.Context) (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SecretListResultPage contains a page of SecretItem values.
type SecretListResultPage struct {
	fn  func(context.Context, SecretListResult) (SecretListResult, error)
	slr SecretListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecretListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecretListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecretListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecretListResultPage) Response() SecretListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecretListResultPage) Values() []SecretItem {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SecretListResultPage type.
func NewSecretListResultPage(getNextPage func(context.Context, SecretListResult) (SecretListResult, error)) SecretListResultPage {
	return SecretListResultPage{fn: getNextPage}
}

// SecretProperties properties of the key backing a certificate.
type SecretProperties struct {
	// ContentType - The media type (MIME type).
	ContentType *string `json:"contentType,omitempty"`
}

// SecretSetParameters the secret set parameters
type SecretSetParameters struct {
	// Value - The value of the secret
	Value *string `json:"value,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
	// ContentType - Type of the secret value such as a password
	ContentType *string `json:"contentType,omitempty"`
	// SecretAttributes - The secret management attributes
	SecretAttributes *SecretAttributes `json:"attributes,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretSetParameters.
func (ssp SecretSetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssp.Value != nil {
		objectMap["value"] = ssp.Value
	}
	if ssp.Tags != nil {
		objectMap["tags"] = ssp.Tags
	}
	if ssp.ContentType != nil {
		objectMap["contentType"] = ssp.ContentType
	}
	if ssp.SecretAttributes != nil {
		objectMap["attributes"] = ssp.SecretAttributes
	}
	return json.Marshal(objectMap)
}

// SecretUpdateParameters the secret update parameters
type SecretUpdateParameters struct {
	// ContentType - Type of the secret value such as a password
	ContentType *string `json:"contentType,omitempty"`
	// SecretAttributes - The secret management attributes
	SecretAttributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SecretUpdateParameters.
func (sup SecretUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.ContentType != nil {
		objectMap["contentType"] = sup.ContentType
	}
	if sup.SecretAttributes != nil {
		objectMap["attributes"] = sup.SecretAttributes
	}
	if sup.Tags != nil {
		objectMap["tags"] = sup.Tags
	}
	return json.Marshal(objectMap)
}

// SubjectAlternativeNames the subject alternate names of a X509 object.
type SubjectAlternativeNames struct {
	// Emails - Email addresses.
	Emails *[]string `json:"emails,omitempty"`
	// DNSNames - Domain names.
	DNSNames *[]string `json:"dns_names,omitempty"`
	// Upns - User principal names.
	Upns *[]string `json:"upns,omitempty"`
}

// Trigger a condition to be satisfied for an action to be executed.
type Trigger struct {
	// LifetimePercentage - Percentage of lifetime as which to trigger. Value should be between 1 and 99.
	LifetimePercentage *int32 `json:"lifetime_percentage,omitempty"`
	// DaysBeforeExpiry - Days before expiry.
	DaysBeforeExpiry *int32 `json:"days_before_expiry,omitempty"`
}

// X509CertificateProperties properties of the X509 component of a certificate.
type X509CertificateProperties struct {
	// Subject - The subject name. Should be a valid X509 Distinguished Name.
	Subject *string `json:"subject,omitempty"`
	// Ekus - The enhanced key usage.
	Ekus *[]string `json:"ekus,omitempty"`
	// SubjectAlternativeNames - The subject alternative names.
	SubjectAlternativeNames *SubjectAlternativeNames `json:"sans,omitempty"`
	// KeyUsage - List of key usages.
	KeyUsage *[]KeyUsageType `json:"key_usage,omitempty"`
	// ValidityInMonths - The duration that the certificate is valid in months.
	ValidityInMonths *int32 `json:"validity_months,omitempty"`
}
