var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { createDragDropManager, } from 'dnd-core';
import checkDecoratorArguments from './utils/checkDecoratorArguments';
import { isRefable } from './utils/isRefable';
const invariant = require('invariant');
const hoistStatics = require('hoist-non-react-statics');
/**
 * Create the React Context
 */
export const context = React.createContext({
    dragDropManager: undefined,
});
export const { Consumer, Provider } = context;
/**
 * Creates the context object we're providing
 * @param backend
 * @param context
 */
export function createChildContext(backend, context, debugMode) {
    return {
        dragDropManager: createDragDropManager(backend, context, debugMode),
    };
}
/**
 * A React component that provides the React-DnD context
 */
export const DragDropContextProvider = (_a) => {
    var { children } = _a, props = __rest(_a, ["children"]);
    const contextValue = 'manager' in props
        ? { dragDropManager: props.manager }
        : createChildContext(props.backend, props.context, props.debugMode);
    return React.createElement(Provider, { value: contextValue }, children);
};
/**
 * Wrap the root component of your application with DragDropContext decorator to set up React DnD.
 * This lets you specify the backend, and sets up the shared DnD state behind the scenes.
 * @param backendFactory The DnD backend factory
 * @param backendContext The backend context
 */
export function DragDropContext(backendFactory, backendContext, debugMode) {
    checkDecoratorArguments('DragDropContext', 'backend', backendFactory);
    const childContext = createChildContext(backendFactory, backendContext, debugMode);
    return function decorateContext(DecoratedComponent) {
        const Decorated = DecoratedComponent;
        const displayName = Decorated.displayName || Decorated.name || 'Component';
        class DragDropContextContainer extends React.Component {
            constructor() {
                super(...arguments);
                this.ref = React.createRef();
                this.getManager = () => childContext.dragDropManager;
            }
            getDecoratedComponentInstance() {
                invariant(this.ref.current, 'In order to access an instance of the decorated component, it must either be a class component or use React.forwardRef()');
                return this.ref.current;
            }
            render() {
                return (React.createElement(Provider, { value: childContext },
                    React.createElement(Decorated, Object.assign({}, this.props, { ref: isRefable(Decorated) ? this.ref : null }))));
            }
        }
        DragDropContextContainer.DecoratedComponent = DecoratedComponent;
        DragDropContextContainer.displayName = `DragDropContext(${displayName})`;
        return hoistStatics(DragDropContextContainer, DecoratedComponent);
    };
}
