"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var wrapConnectorHooks_1 = require("./wrapConnectorHooks");
var isRef_1 = require("./utils/isRef");
var shallowEqual = require('shallowequal');
var TargetConnector = /** @class */ (function () {
    function TargetConnector(backend) {
        var _this = this;
        this.backend = backend;
        this.hooks = wrapConnectorHooks_1.default({
            dropTarget: function (node, options) {
                _this.dropTargetOptions = options;
                if (isRef_1.isRef(node)) {
                    _this.dropTargetRef = node;
                }
                else {
                    _this.dropTargetNode = node;
                }
                _this.reconnect();
            },
        });
        this.handlerId = null;
        // The drop target may either be attached via ref or connect function
        this.dropTargetRef = null;
        this.dropTargetOptionsInternal = null;
        this.lastConnectedHandlerId = null;
        this.lastConnectedDropTarget = null;
        this.lastConnectedDropTargetOptions = null;
    }
    Object.defineProperty(TargetConnector.prototype, "connectTarget", {
        get: function () {
            return this.dropTarget;
        },
        enumerable: true,
        configurable: true
    });
    TargetConnector.prototype.reconnect = function () {
        // if nothing has changed then don't resubscribe
        var didChange = this.didHandlerIdChange() ||
            this.didDropTargetChange() ||
            this.didOptionsChange();
        if (didChange) {
            this.disconnectDropTarget();
        }
        var dropTarget = this.dropTarget;
        if (!this.handlerId) {
            return;
        }
        if (!dropTarget) {
            this.lastConnectedDropTarget = dropTarget;
            return;
        }
        if (didChange) {
            this.lastConnectedHandlerId = this.handlerId;
            this.lastConnectedDropTarget = dropTarget;
            this.lastConnectedDropTargetOptions = this.dropTargetOptions;
            this.unsubscribeDropTarget = this.backend.connectDropTarget(this.handlerId, dropTarget, this.dropTargetOptions);
        }
    };
    TargetConnector.prototype.receiveHandlerId = function (newHandlerId) {
        if (newHandlerId === this.handlerId) {
            return;
        }
        this.handlerId = newHandlerId;
        this.reconnect();
    };
    Object.defineProperty(TargetConnector.prototype, "dropTargetOptions", {
        get: function () {
            return this.dropTargetOptionsInternal;
        },
        set: function (options) {
            this.dropTargetOptionsInternal = options;
        },
        enumerable: true,
        configurable: true
    });
    TargetConnector.prototype.didHandlerIdChange = function () {
        return this.lastConnectedHandlerId !== this.handlerId;
    };
    TargetConnector.prototype.didDropTargetChange = function () {
        return this.lastConnectedDropTarget !== this.dropTarget;
    };
    TargetConnector.prototype.didOptionsChange = function () {
        return !shallowEqual(this.lastConnectedDropTargetOptions, this.dropTargetOptions);
    };
    TargetConnector.prototype.disconnectDropTarget = function () {
        if (this.unsubscribeDropTarget) {
            this.unsubscribeDropTarget();
            this.unsubscribeDropTarget = undefined;
        }
    };
    Object.defineProperty(TargetConnector.prototype, "dropTarget", {
        get: function () {
            return (this.dropTargetNode || (this.dropTargetRef && this.dropTargetRef.current));
        },
        enumerable: true,
        configurable: true
    });
    return TargetConnector;
}());
exports.default = TargetConnector;
