import * as React from 'react';
import { DragDropManager, BackendFactory } from 'dnd-core';
import { ContextComponent } from './interfaces';
/**
 * The React context type
 */
export interface DragDropContext<BC> {
    dragDropManager: DragDropManager<BC> | undefined;
}
/**
 * Create the React Context
 */
export declare const context: React.Context<DragDropContext<any>>;
export declare const Consumer: React.ExoticComponent<React.ConsumerProps<DragDropContext<any>>>, Provider: React.ProviderExoticComponent<React.ProviderProps<DragDropContext<any>>>;
/**
 * Creates the context object we're providing
 * @param backend
 * @param context
 */
export declare function createChildContext<BackendContext>(backend: BackendFactory, context?: BackendContext, debugMode?: boolean): {
    dragDropManager: DragDropManager<BackendContext | undefined>;
};
export declare type DragDropContextProviderProps<BackendContext> = {
    manager: DragDropManager<BackendContext>;
} | {
    backend: BackendFactory;
    context?: BackendContext;
    debugMode?: boolean;
};
/**
 * A React component that provides the React-DnD context
 */
export declare const DragDropContextProvider: React.FC<DragDropContextProviderProps<any>>;
/**
 * Wrap the root component of your application with DragDropContext decorator to set up React DnD.
 * This lets you specify the backend, and sets up the shared DnD state behind the scenes.
 * @param backendFactory The DnD backend factory
 * @param backendContext The backend context
 */
export declare function DragDropContext(backendFactory: BackendFactory, backendContext?: any, debugMode?: boolean): <TargetClass extends React.ComponentType<any>>(DecoratedComponent: TargetClass) => TargetClass & ContextComponent<any>;
