"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartThreshold = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const cloneDeep_1 = tslib_1.__importDefault(require("lodash/cloneDeep"));
const victory_line_1 = require("victory-line");
const ChartLine_1 = require("../ChartLine");
const ChartUtils_1 = require("../ChartUtils");
const ChartThreshold = (_a) => {
    var { style = {}, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getThresholdTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["style", "themeColor", "themeVariant", "theme"]);
    // Returned style prop takes precedence over default theme
    const getStrokeDasharray = () => {
        if (style && style.data && style.data.strokeDasharray) {
            return style.data.strokeDasharray;
        }
        return ChartUtils_1.getThresholdTheme(themeColor, themeVariant).line.style.data.strokeDasharray;
    };
    const getStrokeWidth = () => {
        if (style && style.data && style.data.strokeWidth) {
            return style.data.strokeWidth;
        }
        return ChartUtils_1.getThresholdTheme(themeColor, themeVariant).line.style.data.strokeWidth;
    };
    // Clone style and apply strokeDasharray prop
    const thresholdStyle = cloneDeep_1.default(style);
    if (thresholdStyle.data) {
        thresholdStyle.data.strokeDasharray = getStrokeDasharray();
        thresholdStyle.data.strokeWidth = getStrokeWidth();
    }
    else {
        thresholdStyle.data = {
            strokeDasharray: getStrokeDasharray(),
            strokeWidth: getStrokeWidth()
        };
    }
    return React.createElement(ChartLine_1.ChartLine, Object.assign({ style: thresholdStyle, theme: theme }, rest));
};
exports.ChartThreshold = ChartThreshold;
exports.ChartThreshold.displayName = 'ChartThreshold';
// Note: VictoryLine.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartThreshold, victory_line_1.VictoryLine);
//# sourceMappingURL=ChartThreshold.js.map