var _curry2 = require('./internal/_curry2');
var _dispatchable = require('./internal/_dispatchable');
var _makeFlat = require('./internal/_makeFlat');
var _xchain = require('./internal/_xchain');
var map = require('./map');


/**
 * `chain` maps a function over a list and concatenates the results. `chain`
 * is also known as `flatMap` in some libraries
 *
 * Dispatches to the `chain` method of the second argument, if present.
 *
 * @func
 * @memberOf R
 * @since v0.3.0
 * @category List
 * @sig (a -> [b]) -> [a] -> [b]
 * @param {Function} fn
 * @param {Array} list
 * @return {Array}
 * @example
 *
 *      var duplicate = n => [n, n];
 *      R.chain(duplicate, [1, 2, 3]); //=> [1, 1, 2, 2, 3, 3]
 */
module.exports = _curry2(_dispatchable('chain', _xchain, function chain(fn, monad) {
  if (typeof monad === 'function') {
    return function() {
      return monad.call(this, fn.apply(this, arguments)).apply(this, arguments);
    };
  }
  return _makeFlat(false)(map(fn, monad));
}));
