import { LabelProps } from '@patternfly/react-core';
import React, { ReactNode } from 'react';
export declare function AcmPage(props: {
    header: ReactNode;
    children: ReactNode;
    hasDrawer?: boolean;
}): JSX.Element;
export interface AcmPageHeaderProps {
    title: string;
    titleTooltip?: string | React.ReactNode;
    label?: string | React.ReactNode;
    labelColor?: LabelProps['color'];
    description?: string | React.ReactNode;
    breadcrumb?: {
        text: string;
        to?: string;
    }[];
    navigation?: React.ReactNode;
    controls?: React.ReactNode;
    switches?: React.ReactNode;
    actions?: React.ReactNode;
}
export declare function AcmPageHeader(props: AcmPageHeaderProps): JSX.Element;
export declare function AcmPageCard(props: {
    children: ReactNode;
}): JSX.Element;
export declare function AcmBreadcrumb(props: {
    breadcrumb?: {
        text: string;
        to?: string;
    }[] | undefined;
}): JSX.Element | null;
export declare type AcmPageContentProps = {
    /** Content ID is needed because react needs the key to detect content changes */
    id: string;
    /** React children for this component */
    children: ReactNode;
    variant?: 'light';
};
export declare function AcmPageContent(props: AcmPageContentProps): JSX.Element;
