import React, { ReactNode } from 'react';
import { CardProps, CardActionsProps } from '@patternfly/react-core';
declare type CardHeaderActions = {
    text: string;
    handleAction: () => void;
};
interface CardHeaderProps {
    title: string;
    description: string;
    actions?: CardHeaderActions[];
    onActionClick?: (event: React.SyntheticEvent) => void;
    hasIcon?: boolean;
}
interface CardFooterProps {
    countDescription?: string;
    countLink?: string | ReactNode;
}
interface CardDropdownProps {
    dropdownItems: {
        text: string;
        handleAction: () => void;
    }[];
    toggle?: React.ReactNode;
    onSelect?: (event: React.SyntheticEvent) => void;
}
export declare type AcmCountCardProps = CardProps & {
    key?: number;
    id?: string;
    label?: string;
    loading?: boolean;
    onCardClick?: () => void;
    cardHeader?: CardHeaderProps;
    cardFooter?: CardFooterProps;
    count?: number;
    countTitle?: string;
    isFlat?: boolean;
    onKeyPress?: (e: React.KeyboardEvent) => void;
};
declare type SkeletonCard = CardProps & {
    id?: string;
};
export declare function CardDropdown(props: CardDropdownProps & CardActionsProps): JSX.Element;
export declare const loadingCard: (props: SkeletonCard) => JSX.Element;
export declare const AcmCountCard: (props: AcmCountCardProps) => JSX.Element;
export {};
