"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmPageContent = exports.AcmBreadcrumb = exports.AcmPageCard = exports.AcmPageHeader = exports.AcmPage = void 0;
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var react_1 = __importStar(require("react"));
var react_router_dom_1 = require("react-router-dom");
var AcmAlert_1 = require("../AcmAlert/AcmAlert");
var AcmDrawer_1 = require("../AcmDrawer/AcmDrawer");
var AcmErrorBoundary_1 = require("../AcmErrorBoundary/AcmErrorBoundary");
function AcmPage(props) {
    /* istanbul ignore if */
    if (props.hasDrawer) {
        return (react_1.default.createElement(AcmDrawer_1.AcmDrawerProvider, null,
            react_1.default.createElement(AcmDrawer_1.AcmDrawer, null,
                react_1.default.createElement(react_core_1.Page, { additionalGroupedContent: react_1.default.createElement(react_1.Fragment, null, props.header), groupProps: { sticky: 'top' } }, props.children))));
    }
    else {
        return (react_1.default.createElement(react_core_1.Page, { additionalGroupedContent: react_1.default.createElement(react_1.Fragment, null, props.header), groupProps: { sticky: 'top' } }, props.children));
    }
}
exports.AcmPage = AcmPage;
function AcmPageHeader(props) {
    return (react_1.default.createElement(react_core_1.PageSection, { variant: react_core_1.PageSectionVariants.light, padding: { default: 'noPadding' } },
        react_1.default.createElement(react_core_1.Split, null,
            react_1.default.createElement(react_core_1.SplitItem, { isFilled: true },
                react_1.default.createElement(react_core_1.Stack, { hasGutter: true },
                    react_1.default.createElement(react_core_1.StackItem, { isFilled: true },
                        react_1.default.createElement(react_core_1.PageSection, { variant: react_core_1.PageSectionVariants.light, style: {
                                paddingBottom: props.navigation ? 'inherit' : undefined,
                                paddingTop: props.breadcrumb
                                    ? 'var(--pf-c-page__main-breadcrumb--PaddingTop)'
                                    : undefined,
                            } },
                            react_1.default.createElement(react_core_1.Stack, { hasGutter: true },
                                props.breadcrumb && (react_1.default.createElement(react_core_1.StackItem, null,
                                    react_1.default.createElement(AcmBreadcrumb, { breadcrumb: props.breadcrumb }))),
                                react_1.default.createElement(react_core_1.StackItem, { isFilled: true },
                                    react_1.default.createElement(react_core_1.Split, { hasGutter: true },
                                        react_1.default.createElement(react_core_1.SplitItem, null,
                                            react_1.default.createElement(react_core_1.TextContent, null,
                                                react_1.default.createElement(react_core_1.Title, { headingLevel: "h1" },
                                                    props.title,
                                                    props.titleTooltip && (react_1.default.createElement(react_core_1.Popover, { hasAutoWidth: true, bodyContent: props.titleTooltip },
                                                        react_1.default.createElement(react_core_1.Button, { variant: "link", style: {
                                                                padding: 0,
                                                                marginLeft: '8px',
                                                                verticalAlign: 'middle',
                                                            } },
                                                            react_1.default.createElement(react_icons_1.OutlinedQuestionCircleIcon, null))))))),
                                        props.switches && (react_1.default.createElement(react_core_1.SplitItem, null,
                                            react_1.default.createElement("span", { style: {
                                                    paddingLeft: '24px',
                                                    height: '100%',
                                                    display: 'flex',
                                                    alignItems: 'center',
                                                } }, props.switches)))),
                                    props.description && (react_1.default.createElement("div", { style: { paddingTop: '8px' } }, props.description)))))),
                    props.navigation && (react_1.default.createElement(react_core_1.StackItem, null,
                        react_1.default.createElement(react_core_1.PageSection, { variant: react_core_1.PageSectionVariants.light, type: "nav", style: { paddingTop: 0, paddingBottom: 0 } }, props.navigation))))),
            react_1.default.createElement(react_core_1.SplitItem, null,
                react_1.default.createElement(react_core_1.PageSection, { variant: react_core_1.PageSectionVariants.light, style: { height: '100%' } },
                    react_1.default.createElement(react_core_1.Stack, { hasGutter: true },
                        props.controls && (react_1.default.createElement(react_core_1.StackItem, { style: { display: 'flex', flexDirection: 'column', alignItems: 'flex-end' } }, props.controls)),
                        props.actions && (react_1.default.createElement(react_core_1.StackItem, { style: {
                                display: 'flex',
                                flexDirection: 'column',
                                alignItems: 'flex-end',
                                justifyContent: 'flex-end',
                            }, isFilled: true }, props.actions))))))));
}
exports.AcmPageHeader = AcmPageHeader;
function AcmPageCard(props) {
    return (react_1.default.createElement(react_core_1.PageSection, null,
        react_1.default.createElement(react_core_1.Card, null,
            react_1.default.createElement(react_core_1.CardBody, null, props.children))));
}
exports.AcmPageCard = AcmPageCard;
function AcmBreadcrumb(props) {
    var breadcrumb = props.breadcrumb;
    if (breadcrumb === null || breadcrumb === void 0 ? void 0 : breadcrumb.length) {
        return (react_1.default.createElement(react_core_1.Breadcrumb, null, breadcrumb.map(function (crumb, i) { return (react_1.default.createElement(react_core_1.BreadcrumbItem, { key: i }, breadcrumb.length > 1 && i === breadcrumb.length - 1 ? (react_1.default.createElement("a", { "aria-current": "page", className: "pf-c-breadcrumb__link pf-m-current" }, crumb.text)) : (react_1.default.createElement(react_router_dom_1.Link, { to: crumb.to, className: "pf-c-breadcrumb__link" }, crumb.text)))); })));
    }
    return null;
}
exports.AcmBreadcrumb = AcmBreadcrumb;
function AcmPageContent(props) {
    return (react_1.default.createElement(AcmErrorBoundary_1.AcmErrorBoundary, { key: props.id },
        react_1.default.createElement(AcmAlert_1.AcmAlertProvider, null,
            react_1.default.createElement(AcmAlert_1.AcmAlertContext.Consumer, null, function (context) { return (react_1.default.createElement(react_1.Fragment, null, context.alertInfos.length > 0 && (react_1.default.createElement(react_core_1.PageSection, { variant: props.variant, style: { paddingBottom: 0 } },
                react_1.default.createElement(AcmAlert_1.AcmAlertGroup, { isInline: true, canClose: true }))))); }),
            props.children)));
}
exports.AcmPageContent = AcmPageContent;
//# sourceMappingURL=AcmPage.js.map