"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getThresholdTheme = exports.getTheme = exports.getLightThemeColors = exports.getDarkThemeColors = exports.getDonutUtilizationTheme = exports.getDonutThresholdStaticTheme = exports.getDonutThresholdDynamicTheme = exports.getDonutTheme = exports.getBulletQualitativeRangeTheme = exports.getBulletPrimarySegmentedMeasureTheme = exports.getBulletPrimaryNegativeMeasureTheme = exports.getBulletPrimaryDotMeasureTheme = exports.getBulletGroupTitleTheme = exports.getBulletComparativeWarningMeasureTheme = exports.getBulletComparativeMeasureTheme = exports.getBulletComparativeErrorMeasureTheme = exports.getBulletTheme = exports.getAxisTheme = exports.getCustomTheme = void 0;
const tslib_1 = require("tslib");
const cloneDeep_1 = tslib_1.__importDefault(require("lodash/cloneDeep"));
const merge_1 = tslib_1.__importDefault(require("lodash/merge"));
const blue_color_theme_1 = require("../ChartTheme/themes/dark/blue-color-theme");
const cyan_color_theme_1 = require("../ChartTheme/themes/dark/cyan-color-theme");
const gold_color_theme_1 = require("../ChartTheme/themes/dark/gold-color-theme");
const gray_color_theme_1 = require("../ChartTheme/themes/dark/gray-color-theme");
const green_color_theme_1 = require("../ChartTheme/themes/dark/green-color-theme");
const multi_color_ordered_theme_1 = require("../ChartTheme/themes/dark/multi-color-ordered-theme");
const multi_color_unordered_theme_1 = require("../ChartTheme/themes/dark/multi-color-unordered-theme");
const orange_color_theme_1 = require("../ChartTheme/themes/dark/orange-color-theme");
const purple_color_theme_1 = require("../ChartTheme/themes/dark/purple-color-theme");
const blue_color_theme_2 = require("../ChartTheme/themes/light/blue-color-theme");
const cyan_color_theme_2 = require("../ChartTheme/themes/light/cyan-color-theme");
const gold_color_theme_2 = require("../ChartTheme/themes/light/gold-color-theme");
const gray_color_theme_2 = require("../ChartTheme/themes/light/gray-color-theme");
const green_color_theme_2 = require("../ChartTheme/themes/light/green-color-theme");
const multi_color_ordered_theme_2 = require("../ChartTheme/themes/light/multi-color-ordered-theme");
const multi_color_unordered_theme_2 = require("../ChartTheme/themes/light/multi-color-unordered-theme");
const orange_color_theme_2 = require("../ChartTheme/themes/light/orange-color-theme");
const purple_color_theme_2 = require("../ChartTheme/themes/light/purple-color-theme");
const ChartTheme_1 = require("../ChartTheme/ChartTheme");
// Apply custom properties to base and color themes
exports.getCustomTheme = (themeColor, themeVariant, customTheme) => merge_1.default(exports.getTheme(themeColor, themeVariant), customTheme);
// Returns axis theme
exports.getAxisTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartAxisTheme);
// Returns bullet chart theme
exports.getBulletTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletTheme);
// Returns comparative error measure theme for bullet chart
exports.getBulletComparativeErrorMeasureTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletComparativeErrorMeasureTheme);
// Returns comparative measure theme for bullet chart
exports.getBulletComparativeMeasureTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletComparativeMeasureTheme);
// Returns comparative warning measure theme for bullet chart
exports.getBulletComparativeWarningMeasureTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletComparativeWarningMeasureTheme);
// Returns group title theme for bullet chart
exports.getBulletGroupTitleTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletGroupTitleTheme);
// Returns primary dot measure theme for bullet chart
exports.getBulletPrimaryDotMeasureTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletPrimaryDotMeasureTheme);
// Returns primary negative measure theme for bullet chart
exports.getBulletPrimaryNegativeMeasureTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletPrimaryNegativeMeasureTheme);
// Returns primary segmented measure theme for bullet chart
exports.getBulletPrimarySegmentedMeasureTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletPrimarySegmentedMeasureTheme);
// Returns qualitative range theme for bullet chart
exports.getBulletQualitativeRangeTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartBulletQualitativeRangeTheme);
// Returns donut theme
exports.getDonutTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartDonutTheme);
// Returns dynamic donut threshold theme
exports.getDonutThresholdDynamicTheme = (themeColor, themeVariant) => {
    const theme = exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartDonutThresholdDynamicTheme);
    // Merge just the first color of dynamic (blue, green, etc.) with static (grey) for expected colorScale
    theme.legend.colorScale = [theme.pie.colorScale[0], ...ChartTheme_1.ChartDonutThresholdDynamicTheme.legend.colorScale];
    // Merge the threshold colors in case users want to show the unused data
    theme.pie.colorScale = [theme.pie.colorScale[0], ...ChartTheme_1.ChartDonutThresholdStaticTheme.pie.colorScale];
    return theme;
};
// Returns static donut threshold theme
exports.getDonutThresholdStaticTheme = (themeColor, themeVariant, invert) => {
    const staticTheme = cloneDeep_1.default(ChartTheme_1.ChartDonutThresholdStaticTheme);
    if (invert && staticTheme.pie.colorScale instanceof Array) {
        staticTheme.pie.colorScale = staticTheme.pie.colorScale.reverse();
    }
    return exports.getCustomTheme(themeColor, themeVariant, staticTheme);
};
// Returns donut utilization theme
exports.getDonutUtilizationTheme = (themeColor, themeVariant) => {
    const theme = exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartDonutUtilizationDynamicTheme);
    // Merge just the first color of dynamic (blue, green, etc.) with static (grey) for expected colorScale
    theme.pie.colorScale = [theme.pie.colorScale[0], ...ChartTheme_1.ChartDonutUtilizationStaticTheme.pie.colorScale];
    theme.legend.colorScale = [theme.legend.colorScale[0], ...ChartTheme_1.ChartDonutUtilizationStaticTheme.legend.colorScale];
    return theme;
};
// Returns dark theme colors
exports.getDarkThemeColors = (themeColor) => {
    switch (themeColor) {
        case ChartTheme_1.ChartThemeColor.blue:
            return blue_color_theme_1.DarkBlueColorTheme;
        case ChartTheme_1.ChartThemeColor.cyan:
            return cyan_color_theme_1.DarkCyanColorTheme;
        case ChartTheme_1.ChartThemeColor.gold:
            return gold_color_theme_1.DarkGoldColorTheme;
        case ChartTheme_1.ChartThemeColor.gray:
            return gray_color_theme_1.DarkGrayColorTheme;
        case ChartTheme_1.ChartThemeColor.green:
            return green_color_theme_1.DarkGreenColorTheme;
        case ChartTheme_1.ChartThemeColor.multi:
        case ChartTheme_1.ChartThemeColor.multiOrdered:
            return multi_color_ordered_theme_1.DarkMultiColorOrderedTheme;
        case ChartTheme_1.ChartThemeColor.multiUnordered:
            return multi_color_unordered_theme_1.DarkMultiColorUnorderedTheme;
        case ChartTheme_1.ChartThemeColor.orange:
            return orange_color_theme_1.DarkOrangeColorTheme;
        case ChartTheme_1.ChartThemeColor.purple:
            return purple_color_theme_1.DarkPurpleColorTheme;
        default:
            return blue_color_theme_1.DarkBlueColorTheme;
    }
};
// Returns light theme colors
exports.getLightThemeColors = (themeColor) => {
    switch (themeColor) {
        case ChartTheme_1.ChartThemeColor.blue:
            return blue_color_theme_2.LightBlueColorTheme;
        case ChartTheme_1.ChartThemeColor.cyan:
            return cyan_color_theme_2.LightCyanColorTheme;
        case ChartTheme_1.ChartThemeColor.gold:
            return gold_color_theme_2.LightGoldColorTheme;
        case ChartTheme_1.ChartThemeColor.gray:
            return gray_color_theme_2.LightGrayColorTheme;
        case ChartTheme_1.ChartThemeColor.green:
            return green_color_theme_2.LightGreenColorTheme;
        case ChartTheme_1.ChartThemeColor.multi:
        case ChartTheme_1.ChartThemeColor.multiOrdered:
            return multi_color_ordered_theme_2.LightMultiColorOrderedTheme;
        case ChartTheme_1.ChartThemeColor.multiUnordered:
            return multi_color_unordered_theme_2.LightMultiColorUnorderedTheme;
        case ChartTheme_1.ChartThemeColor.orange:
            return orange_color_theme_2.LightOrangeColorTheme;
        case ChartTheme_1.ChartThemeColor.purple:
            return purple_color_theme_2.LightPurpleColorTheme;
        default:
            return blue_color_theme_2.LightBlueColorTheme;
    }
};
// Applies theme color and variant to base theme
exports.getTheme = (themeColor, themeVariant) => {
    // Deep clone
    const baseTheme = Object.assign({}, JSON.parse(JSON.stringify(ChartTheme_1.ChartBaseTheme)));
    switch (themeVariant) {
        case ChartTheme_1.ChartThemeVariant.dark:
            return merge_1.default(baseTheme, exports.getDarkThemeColors(themeColor));
        case ChartTheme_1.ChartThemeVariant.light:
            return merge_1.default(baseTheme, exports.getLightThemeColors(themeColor));
        default:
            return merge_1.default(baseTheme, exports.getLightThemeColors(themeColor));
    }
};
// Returns threshold theme
exports.getThresholdTheme = (themeColor, themeVariant) => exports.getCustomTheme(themeColor, themeVariant, ChartTheme_1.ChartThresholdTheme);
//# sourceMappingURL=chart-theme.js.map