"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartBulletGroupTitle = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const victory_core_1 = require("victory-core");
const ChartContainer_1 = require("../ChartContainer");
const ChartLabel_1 = require("../ChartLabel");
const ChartTheme_1 = require("../ChartTheme");
const ChartUtils_1 = require("../ChartUtils");
exports.ChartBulletGroupTitle = ({ ariaDesc, ariaTitle, capHeight = 1.1, dividerComponent = React.createElement(victory_core_1.Line, null), padding, standalone = true, subTitle, themeColor, themeVariant, title, titleComponent = React.createElement(ChartLabel_1.ChartLabel, null), 
// destructure last
theme = ChartUtils_1.getBulletGroupTitleTheme(themeColor, themeVariant), height = theme.chart.height, width = theme.chart.width }) => {
    const defaultPadding = {
        bottom: ChartUtils_1.getPaddingForSide('bottom', padding, theme.chart.padding),
        left: ChartUtils_1.getPaddingForSide('left', padding, theme.chart.padding),
        right: ChartUtils_1.getPaddingForSide('right', padding, theme.chart.padding),
        top: ChartUtils_1.getPaddingForSide('top', padding, theme.chart.padding)
    };
    const labelPadding = {
        bottom: ChartUtils_1.getPaddingForSide('bottom', padding, Number(theme.legend.style.labels.padding)),
        left: ChartUtils_1.getPaddingForSide('left', padding, Number(theme.legend.style.labels.padding)),
        right: ChartUtils_1.getPaddingForSide('right', padding, Number(theme.legend.style.labels.padding)),
        top: ChartUtils_1.getPaddingForSide('top', padding, Number(theme.legend.style.labels.padding))
    };
    // Horizontal divider to render under the group title
    const getDivider = () => {
        const titleSize = ChartUtils_1.getLabelTextSize({ text: title, theme });
        const subTitleSize = ChartUtils_1.getLabelTextSize({ text: subTitle, theme });
        const dy = title && subTitle
            ? titleSize.height + subTitleSize.height + labelPadding.top + labelPadding.bottom
            : titleSize.height + labelPadding.top + labelPadding.bottom;
        return React.cloneElement(dividerComponent, Object.assign({ x1: defaultPadding.left, x2: width - defaultPadding.right, y1: defaultPadding.top + dy, y2: defaultPadding.top + dy, style: theme.line.style.data }, dividerComponent.props));
    };
    // Returns title
    const getTitle = () => {
        const titleProps = titleComponent ? titleComponent.props : {};
        const showBoth = title && subTitle;
        return React.cloneElement(titleComponent, Object.assign(Object.assign(Object.assign({}, (showBoth && { capHeight })), { style: [ChartTheme_1.ChartBulletStyles.label.groupTitle, ChartTheme_1.ChartBulletStyles.label.subTitle], text: showBoth ? [title, subTitle] : title, textAnchor: 'middle', verticalAnchor: 'middle', x: ChartUtils_1.getBulletLabelX({
                chartWidth: width,
                labelPosition: 'top'
            }), y: ChartUtils_1.getBulletLabelY({
                chartHeight: height,
                dy: defaultPadding.top,
                labelPosition: 'top'
            }) }), titleProps));
    };
    const groupTitle = Boolean(title) && (React.createElement(React.Fragment, null,
        getTitle(),
        getDivider()));
    return standalone ? (React.createElement(ChartContainer_1.ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, groupTitle)) : (React.createElement(React.Fragment, null, groupTitle));
};
exports.ChartBulletGroupTitle.displayName = 'ChartBulletGroupTitle';
//# sourceMappingURL=ChartBulletGroupTitle.js.map