import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryTooltip } from 'victory-tooltip';
import { ChartLabel } from '../ChartLabel';
import { getTheme } from '../ChartUtils';
export const ChartTooltip = (_a) => {
    var { constrainToVisibleArea = false, labelComponent = React.createElement(ChartLabel, null), // Note that Victory provides its own label component here
    labelTextAnchor, themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["constrainToVisibleArea", "labelComponent", "labelTextAnchor", "themeColor", "themeVariant", "theme"]);
    const chartLabelComponent = React.cloneElement(labelComponent, Object.assign({ textAnchor: labelTextAnchor, theme }, labelComponent.props));
    return (React.createElement(VictoryTooltip, Object.assign({ constrainToVisibleArea: constrainToVisibleArea, labelComponent: chartLabelComponent, theme: theme }, rest)));
};
ChartTooltip.displayName = 'ChartTooltip';
// Note: VictoryTooltip.defaultEvents must be hoisted
hoistNonReactStatics(ChartTooltip, VictoryTooltip);
//# sourceMappingURL=ChartTooltip.js.map