import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { Helpers } from 'victory-core';
import { VictoryTooltip } from 'victory-tooltip';
import { ChartLabel } from '../ChartLabel';
import { ChartTooltip } from '../ChartTooltip';
import { getTheme, getCursorTooltipCenterOffset, getCursorTooltipPoniterOrientation } from '../ChartUtils';
import { ChartCursorFlyout } from './ChartCursorFlyout';
export const ChartCursorTooltip = (_a) => {
    var { constrainToVisibleArea = true, flyoutComponent = React.createElement(ChartCursorFlyout, null), labelComponent = React.createElement(ChartLabel, null), labelTextAnchor = 'start', showPointer = true, style, themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant), centerOffset = getCursorTooltipCenterOffset({ offsetCursorDimensionX: true, theme }), pointerOrientation = getCursorTooltipPoniterOrientation({ horizontal: true, theme }), pointerLength = showPointer && theme && theme.tooltip ? theme.tooltip.pointerLength : 0, pointerWidth = theme.tooltip.pointerWidth } = _a, rest = __rest(_a, ["constrainToVisibleArea", "flyoutComponent", "labelComponent", "labelTextAnchor", "showPointer", "style", "themeColor", "themeVariant", "theme", "centerOffset", "pointerOrientation", "pointerLength", "pointerWidth"]);
    // Apply text anchor style
    const applyDefaultStyle = (customStyle) => (Object.assign(Object.assign({}, customStyle), { textAnchor: labelTextAnchor // Workaround for VictoryTooltip.getLabelProps referencing the theme style only
     }));
    const newStyle = Array.isArray(style) ? style.map(applyDefaultStyle) : applyDefaultStyle(style);
    const getFlyoutComponent = () => {
        let _pointerLength = Helpers.evaluateProp(pointerLength);
        if (showPointer && _pointerLength === 0) {
            _pointerLength = theme && theme.tooltip ? Helpers.evaluateProp(theme.tooltip.pointerLength) : 10;
        }
        return React.cloneElement(flyoutComponent, Object.assign({ pointerLength: _pointerLength, pointerWidth }, flyoutComponent.props));
    };
    return (React.createElement(ChartTooltip, Object.assign({ centerOffset: centerOffset, constrainToVisibleArea: constrainToVisibleArea, flyoutComponent: getFlyoutComponent(), labelComponent: labelComponent, labelTextAnchor: labelTextAnchor, pointerOrientation: pointerOrientation, style: newStyle, theme: theme }, rest)));
};
ChartCursorTooltip.displayName = 'ChartCursorTooltip';
// Note: VictoryTooltip.defaultEvents must be hoisted
hoistNonReactStatics(ChartCursorTooltip, VictoryTooltip);
//# sourceMappingURL=ChartCursorTooltip.js.map