"use strict";

exports.__esModule = true;
exports.default = void 0;

var _resizeObserver2 = /*#__PURE__*/require("@juggle/resize-observer");

var _passiveLayoutEffect = /*#__PURE__*/_interopRequireDefault( /*#__PURE__*/require("@react-hook/passive-layout-effect"));

var _latest = /*#__PURE__*/_interopRequireDefault( /*#__PURE__*/require("@react-hook/latest"));

var _rafSchd = /*#__PURE__*/_interopRequireDefault( /*#__PURE__*/require("raf-schd"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A React hook that fires a callback whenever ResizeObserver detects a change to its size
 *
 * @param target A React ref created by `useRef()` or an HTML element
 * @param callback Invoked with a single `ResizeObserverEntry` any time
 *   the `target` resizes
 */
function useResizeObserver(target, callback) {
  const resizeObserver = getResizeObserver();
  const storedCallback = (0, _latest.default)(callback);
  (0, _passiveLayoutEffect.default)(() => {
    let didUnsubscribe = false;
    const targetEl = target && 'current' in target ? target.current : target;
    if (!targetEl) return;
    resizeObserver.subscribe(targetEl, (entry, observer) => {
      if (didUnsubscribe) return;
      storedCallback.current(entry, observer);
    });
    return () => {
      didUnsubscribe = true;
      resizeObserver.unsubscribe(targetEl);
    };
  }, [target, resizeObserver, storedCallback]);
  return resizeObserver.observer;
}

function createResizeObserver() {
  const callbacks = new Map();
  const observer = new _resizeObserver2.ResizeObserver((0, _rafSchd.default)((entries, observer) => {
    if (entries.length === 1) {
      var _callbacks$get;

      (_callbacks$get = callbacks.get(entries[0].target)) === null || _callbacks$get === void 0 ? void 0 : _callbacks$get(entries[0], observer);
    } else {
      for (let i = 0; i < entries.length; i++) {
        var _callbacks$get2;

        (_callbacks$get2 = callbacks.get(entries[i].target)) === null || _callbacks$get2 === void 0 ? void 0 : _callbacks$get2(entries[i], observer);
      }
    }
  }));
  return {
    observer,

    subscribe(target, callback) {
      observer.observe(target);
      callbacks.set(target, callback);
    },

    unsubscribe(target) {
      observer.unobserve(target);
      callbacks.delete(target);
    }

  };
}

let _resizeObserver;

const getResizeObserver = () => !_resizeObserver ? _resizeObserver = createResizeObserver() : _resizeObserver;

var _default = useResizeObserver;
exports.default = _default;