'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = isError;

var _prettyFormat = require('pretty-format');

var _prettyFormat2 = _interopRequireDefault(_prettyFormat);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

function isError(potentialError) {
  // duck-type Error, see #2549
  const isError =
    typeof potentialError === 'object' &&
    typeof potentialError.message === 'string' &&
    typeof potentialError.name === 'string';
  const message = isError
    ? null
    : `Failed: ${(0, _prettyFormat2.default)(potentialError, {maxDepth: 3})}`;

  return {isError: isError, message: message};
}
/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */
