import { Disposable, TextDocument, ProviderResult, Position as VPosition, CallHierarchyItem as VCallHierarchyItem, CallHierarchyIncomingCall as VCallHierarchyIncomingCall, CallHierarchyOutgoingCall as VCallHierarchyOutgoingCall, CancellationToken, CallHierarchyProvider as VCallHierarchyProvider } from 'vscode';
import { ClientCapabilities, ServerCapabilities, DocumentSelector, Proposed } from 'vscode-languageserver-protocol';
import { TextDocumentFeature, BaseLanguageClient } from './client';
export interface PrepareCallHierachySignature {
    (this: void, document: TextDocument, position: VPosition, token: CancellationToken): ProviderResult<VCallHierarchyItem>;
}
export interface CallHierarchyIncomingCallsSignature {
    (this: void, item: VCallHierarchyItem, token: CancellationToken): ProviderResult<VCallHierarchyIncomingCall[]>;
}
export interface CallHierarchyOutgoingCallsSignature {
    (this: void, item: VCallHierarchyItem, token: CancellationToken): ProviderResult<VCallHierarchyOutgoingCall[]>;
}
export interface CallHierarchyMiddleware {
    prepareCallHierarchy?: (this: void, document: TextDocument, positions: VPosition, token: CancellationToken, next: PrepareCallHierachySignature) => ProviderResult<VCallHierarchyItem>;
    provideCallHierarchyIncomingCalls?: (this: void, item: VCallHierarchyItem, token: CancellationToken, next: CallHierarchyIncomingCallsSignature) => ProviderResult<VCallHierarchyIncomingCall[]>;
    provideCallHierarchyOutgingCalls?: (this: void, item: VCallHierarchyItem, token: CancellationToken, next: CallHierarchyOutgoingCallsSignature) => ProviderResult<VCallHierarchyOutgoingCall[]>;
}
declare class CallHierarchyProvider implements VCallHierarchyProvider {
    private client;
    private middleware;
    constructor(client: BaseLanguageClient);
    prepareCallHierarchy(document: TextDocument, position: VPosition, token: CancellationToken): ProviderResult<VCallHierarchyItem>;
    provideCallHierarchyIncomingCalls(item: VCallHierarchyItem, token: CancellationToken): ProviderResult<VCallHierarchyIncomingCall[]>;
    provideCallHierarchyOutgoingCalls(item: VCallHierarchyItem, token: CancellationToken): ProviderResult<VCallHierarchyOutgoingCall[]>;
}
export declare class CallHierarchyFeature extends TextDocumentFeature<boolean | Proposed.CallHierarchyOptions, Proposed.CallHierarchyRegistrationOptions, CallHierarchyProvider> {
    constructor(client: BaseLanguageClient);
    fillClientCapabilities(cap: ClientCapabilities): void;
    initialize(cap: ServerCapabilities, documentSelector: DocumentSelector): void;
    protected registerLanguageProvider(options: Proposed.CallHierarchyRegistrationOptions): [Disposable, CallHierarchyProvider];
}
export {};
