function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import PropTypes from 'prop-types';
import React, { Component } from 'react';
import classNames from 'classnames';
import Icon from '../Icon';
export var NotificationButton =
/*#__PURE__*/
function (_Component) {
  _inherits(NotificationButton, _Component);

  function NotificationButton() {
    _classCallCheck(this, NotificationButton);

    return _possibleConstructorReturn(this, (NotificationButton.__proto__ || Object.getPrototypeOf(NotificationButton)).apply(this, arguments));
  }

  _createClass(NotificationButton, [{
    key: "render",
    value: function render() {
      var _props = this.props,
          ariaLabel = _props.ariaLabel,
          className = _props.className,
          iconDescription = _props.iconDescription,
          type = _props.type,
          name = _props.name,
          notificationType = _props.notificationType,
          other = _objectWithoutProperties(_props, ["ariaLabel", "className", "iconDescription", "type", "name", "notificationType"]);

      var buttonClasses = classNames({
        'bx--toast-notification__close-button': notificationType === 'toast',
        'bx--inline-notification__close-button': notificationType === 'inline'
      }, className);
      var iconClasses = classNames({
        'bx--toast-notification__icon': notificationType === 'toast',
        'bx--inline-notification__close-icon': notificationType === 'inline'
      });
      return React.createElement("button", _extends({}, other, {
        type: type,
        className: buttonClasses
      }), React.createElement(Icon, {
        description: iconDescription,
        className: iconClasses,
        "aria-label": ariaLabel,
        name: name
      }));
    }
  }]);

  return NotificationButton;
}(Component);
Object.defineProperty(NotificationButton, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    className: PropTypes.string,
    ariaLabel: PropTypes.string,
    type: PropTypes.string,
    iconDescription: PropTypes.string,
    name: PropTypes.string,
    notificationType: PropTypes.oneOf(['toast', 'inline'])
  }
});
Object.defineProperty(NotificationButton, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    ariaLabel: 'close notificaion',
    notificationType: 'toast',
    type: 'button',
    iconDescription: 'close icon',
    name: 'close'
  }
});
export var NotificationTextDetails =
/*#__PURE__*/
function (_Component2) {
  _inherits(NotificationTextDetails, _Component2);

  function NotificationTextDetails() {
    _classCallCheck(this, NotificationTextDetails);

    return _possibleConstructorReturn(this, (NotificationTextDetails.__proto__ || Object.getPrototypeOf(NotificationTextDetails)).apply(this, arguments));
  }

  _createClass(NotificationTextDetails, [{
    key: "render",
    value: function render() {
      var _props2 = this.props,
          title = _props2.title,
          subtitle = _props2.subtitle,
          caption = _props2.caption,
          notificationType = _props2.notificationType,
          other = _objectWithoutProperties(_props2, ["title", "subtitle", "caption", "notificationType"]);

      if (notificationType === 'toast') {
        return React.createElement("div", _extends({}, other, {
          className: "bx--toast-notification__details"
        }), React.createElement("h3", {
          className: "bx--toast-notification__title"
        }, title), React.createElement("div", {
          className: "bx--toast-notification__subtitle"
        }, subtitle), React.createElement("div", {
          className: "bx--toast-notification__caption"
        }, caption));
      }

      if (notificationType === 'inline') {
        return React.createElement("div", _extends({}, other, {
          className: "bx--inline-notification__text-wrapper"
        }), React.createElement("p", {
          className: "bx--inline-notification__title"
        }, title), React.createElement("div", {
          className: "bx--inline-notification__subtitle"
        }, subtitle));
      }
    }
  }]);

  return NotificationTextDetails;
}(Component);
Object.defineProperty(NotificationTextDetails, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    title: PropTypes.string,
    subtitle: PropTypes.node,
    caption: PropTypes.node,
    notificationType: PropTypes.oneOf(['toast', 'inline'])
  }
});
Object.defineProperty(NotificationTextDetails, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    title: 'title',
    subtitle: 'subtitle',
    caption: 'caption',
    notificationType: 'toast'
  }
});
export var ToastNotification =
/*#__PURE__*/
function (_Component3) {
  _inherits(ToastNotification, _Component3);

  function ToastNotification() {
    var _ref;

    var _temp, _this;

    _classCallCheck(this, ToastNotification);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _possibleConstructorReturn(_this, (_temp = _this = _possibleConstructorReturn(this, (_ref = ToastNotification.__proto__ || Object.getPrototypeOf(ToastNotification)).call.apply(_ref, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        open: true
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleCloseButtonClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        _this.setState({
          open: false
        });

        _this.props.onCloseButtonClick(evt);
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "useIconName", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(kindProp) {
        var isSuccess = kindProp === 'success';
        return isSuccess ? 'checkmark--glyph' : "".concat(kindProp, "--glyph");
      }
    }), _temp));
  }

  _createClass(ToastNotification, [{
    key: "render",
    value: function render() {
      if (!this.state.open) {
        return null;
      }

      var _props3 = this.props,
          role = _props3.role,
          notificationType = _props3.notificationType,
          onCloseButtonClick = _props3.onCloseButtonClick,
          iconDescription = _props3.iconDescription,
          className = _props3.className,
          caption = _props3.caption,
          subtitle = _props3.subtitle,
          title = _props3.title,
          kind = _props3.kind,
          hideCloseButton = _props3.hideCloseButton,
          other = _objectWithoutProperties(_props3, ["role", "notificationType", "onCloseButtonClick", "iconDescription", "className", "caption", "subtitle", "title", "kind", "hideCloseButton"]);

      var classes = classNames('bx--toast-notification', _defineProperty({}, "bx--toast-notification--".concat(this.props.kind), this.props.kind), className);
      return React.createElement("div", _extends({}, other, {
        role: role,
        kind: kind,
        className: classes
      }), React.createElement(NotificationTextDetails, {
        title: title,
        subtitle: subtitle,
        caption: caption,
        notificationType: notificationType
      }), !hideCloseButton && React.createElement(NotificationButton, {
        iconDescription: iconDescription,
        notificationType: notificationType,
        onClick: this.handleCloseButtonClick
      }));
    }
  }]);

  return ToastNotification;
}(Component);
Object.defineProperty(ToastNotification, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: PropTypes.node,
    className: PropTypes.string,
    kind: PropTypes.oneOf(['error', 'info', 'success', 'warning']).isRequired,
    title: PropTypes.string.isRequired,
    subtitle: PropTypes.node.isRequired,
    role: PropTypes.string.isRequired,
    caption: PropTypes.node,
    onCloseButtonClick: PropTypes.func,
    iconDescription: PropTypes.string.isRequired,
    notificationType: PropTypes.string,
    hideCloseButton: PropTypes.bool
  }
});
Object.defineProperty(ToastNotification, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    kind: 'error',
    title: 'provide a title',
    subtitle: 'provide a subtitle',
    caption: 'provide a caption',
    role: 'alert',
    notificationType: 'toast',
    iconDescription: 'closes notification',
    onCloseButtonClick: function onCloseButtonClick() {},
    hideCloseButton: false
  }
});
export var InlineNotification =
/*#__PURE__*/
function (_Component4) {
  _inherits(InlineNotification, _Component4);

  function InlineNotification() {
    var _ref2;

    var _temp2, _this2;

    _classCallCheck(this, InlineNotification);

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return _possibleConstructorReturn(_this2, (_temp2 = _this2 = _possibleConstructorReturn(this, (_ref2 = InlineNotification.__proto__ || Object.getPrototypeOf(InlineNotification)).call.apply(_ref2, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this2), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        open: true
      }
    }), Object.defineProperty(_assertThisInitialized(_this2), "handleCloseButtonClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        _this2.setState({
          open: false
        });

        _this2.props.onCloseButtonClick(evt);
      }
    }), Object.defineProperty(_assertThisInitialized(_this2), "useIconName", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(kindProp) {
        var isSuccess = kindProp === 'success';
        return isSuccess ? 'checkmark--glyph' : "".concat(kindProp, "--glyph");
      }
    }), _temp2));
  }

  _createClass(InlineNotification, [{
    key: "render",
    value: function render() {
      if (!this.state.open) {
        return null;
      }

      var _props4 = this.props,
          role = _props4.role,
          notificationType = _props4.notificationType,
          onCloseButtonClick = _props4.onCloseButtonClick,
          iconDescription = _props4.iconDescription,
          className = _props4.className,
          subtitle = _props4.subtitle,
          title = _props4.title,
          kind = _props4.kind,
          hideCloseButton = _props4.hideCloseButton,
          other = _objectWithoutProperties(_props4, ["role", "notificationType", "onCloseButtonClick", "iconDescription", "className", "subtitle", "title", "kind", "hideCloseButton"]);

      var classes = classNames('bx--inline-notification', _defineProperty({}, "bx--inline-notification--".concat(this.props.kind), this.props.kind), className);
      return React.createElement("div", _extends({}, other, {
        role: role,
        kind: kind,
        className: classes
      }), React.createElement("div", {
        className: "bx--inline-notification__details"
      }, React.createElement(Icon, {
        description: this.props.iconDescription,
        className: "bx--inline-notification__icon",
        "aria-label": "close",
        name: this.useIconName(kind)
      }), React.createElement(NotificationTextDetails, {
        title: title,
        subtitle: subtitle,
        notificationType: notificationType
      })), !hideCloseButton && React.createElement(NotificationButton, {
        notificationType: notificationType,
        onClick: this.handleCloseButtonClick
      }));
    }
  }]);

  return InlineNotification;
}(Component); // Deprecated

Object.defineProperty(InlineNotification, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: PropTypes.node,
    className: PropTypes.string,
    kind: PropTypes.oneOf(['error', 'info', 'success', 'warning']).isRequired,
    title: PropTypes.string.isRequired,
    subtitle: PropTypes.node.isRequired,
    role: PropTypes.string.isRequired,
    onCloseButtonClick: PropTypes.func,
    iconDescription: PropTypes.string.isRequired,
    notificationType: PropTypes.string,
    hideCloseButton: PropTypes.bool
  }
});
Object.defineProperty(InlineNotification, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    role: 'alert',
    notificationType: 'inline',
    iconDescription: 'closes notification',
    onCloseButtonClick: function onCloseButtonClick() {},
    hideCloseButton: false
  }
});

var Notification =
/*#__PURE__*/
function (_Component5) {
  _inherits(Notification, _Component5);

  function Notification() {
    var _ref3;

    var _temp3, _this3;

    _classCallCheck(this, Notification);

    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    return _possibleConstructorReturn(_this3, (_temp3 = _this3 = _possibleConstructorReturn(this, (_ref3 = Notification.__proto__ || Object.getPrototypeOf(Notification)).call.apply(_ref3, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this3), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        open: true
      }
    }), Object.defineProperty(_assertThisInitialized(_this3), "handleCloseButtonClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        _this3.setState({
          open: false
        });

        _this3.props.onCloseButtonClick(evt);
      }
    }), Object.defineProperty(_assertThisInitialized(_this3), "useIconName", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(kindProp) {
        var isSuccess = kindProp === 'success';
        return isSuccess ? 'checkmark--glyph' : "".concat(kindProp, "--glyph");
      }
    }), _temp3));
  }

  _createClass(Notification, [{
    key: "render",
    value: function render() {
      if (!this.state.open) {
        return null;
      }

      var _props5 = this.props,
          onCloseButtonClick = _props5.onCloseButtonClick,
          iconDescription = _props5.iconDescription,
          className = _props5.className,
          caption = _props5.caption,
          subtitle = _props5.subtitle,
          title = _props5.title,
          kind = _props5.kind,
          hideCloseButton = _props5.hideCloseButton,
          other = _objectWithoutProperties(_props5, ["onCloseButtonClick", "iconDescription", "className", "caption", "subtitle", "title", "kind", "hideCloseButton"]);

      var notificationClasses = {
        toast: classNames('bx--toast-notification', _defineProperty({}, "bx--toast-notification--".concat(this.props.kind), this.props.kind), className),
        inline: classNames('bx--inline-notification', _defineProperty({}, "bx--inline-notification--".concat(this.props.kind), this.props.kind), className)
      };
      var toastHTML = React.createElement("div", _extends({}, other, {
        role: "alert",
        kind: kind,
        className: notificationClasses.toast
      }), React.createElement(NotificationTextDetails, {
        title: title,
        subtitle: subtitle,
        caption: caption,
        notificationType: "toast"
      }), !hideCloseButton && React.createElement(NotificationButton, {
        notificationType: "toast",
        onClick: this.handleCloseButtonClick
      }));
      var inlineHTML = React.createElement("div", _extends({}, other, {
        role: "alert",
        kind: kind,
        className: notificationClasses.inline
      }), React.createElement("div", {
        className: "bx--inline-notification__details"
      }, React.createElement(Icon, {
        description: this.props.iconDescription,
        className: "bx--inline-notification__icon",
        "aria-label": "close",
        name: this.useIconName(kind)
      }), React.createElement(NotificationTextDetails, {
        title: title,
        subtitle: subtitle,
        notificationType: "inline"
      })), !hideCloseButton && React.createElement(NotificationButton, {
        notificationType: "inline",
        onClick: this.handleCloseButtonClick
      }));
      return caption ? toastHTML : inlineHTML;
    }
  }]);

  return Notification;
}(Component);

Object.defineProperty(Notification, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: PropTypes.node,
    className: PropTypes.string,
    kind: PropTypes.oneOf(['error', 'info', 'success', 'warning']).isRequired,
    title: PropTypes.string.isRequired,
    subtitle: PropTypes.string.isRequired,
    caption: PropTypes.string,
    onCloseButtonClick: PropTypes.func,
    iconDescription: PropTypes.string.isRequired,
    hideCloseButton: PropTypes.bool
  }
});
Object.defineProperty(Notification, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    onCloseButtonClick: function onCloseButtonClick() {},
    iconDescription: 'closes notification',
    title: 'Provide a title',
    subtitle: 'Provide a subtitle',
    hideCloseButton: false
  }
});
export { Notification as default };