"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileBelowTheFoldContent = exports.TileAboveTheFoldContent = exports.ExpandableTile = exports.SelectableTile = exports.ClickableTile = exports.Tile = void 0;

var _react = _interopRequireWildcard(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Icon = _interopRequireDefault(require("../Icon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Tile =
/*#__PURE__*/
function (_Component) {
  _inherits(Tile, _Component);

  function Tile() {
    _classCallCheck(this, Tile);

    return _possibleConstructorReturn(this, (Tile.__proto__ || Object.getPrototypeOf(Tile)).apply(this, arguments));
  }

  _createClass(Tile, [{
    key: "render",
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          other = _objectWithoutProperties(_props, ["children", "className"]);

      var tileClasses = (0, _classnames.default)('bx--tile', className);
      return _react.default.createElement("div", _extends({
        className: tileClasses
      }, other), children);
    }
  }]);

  return Tile;
}(_react.Component);

exports.Tile = Tile;
Object.defineProperty(Tile, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: _propTypes.default.node,
    className: _propTypes.default.string
  }
});

var ClickableTile =
/*#__PURE__*/
function (_Component2) {
  _inherits(ClickableTile, _Component2);

  function ClickableTile() {
    var _ref;

    var _temp, _this;

    _classCallCheck(this, ClickableTile);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _possibleConstructorReturn(_this, (_temp = _this = _possibleConstructorReturn(this, (_ref = ClickableTile.__proto__ || Object.getPrototypeOf(ClickableTile)).call.apply(_ref, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        clicked: _this.props.clicked
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        _this.setState({
          clicked: !_this.state.clicked
        }, function () {
          _this.props.handleClick(evt);
        });
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleKeyDown", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        if (evt.which === 13 || evt.which === 32) {
          _this.setState({
            clicked: !_this.state.clicked
          }, function () {
            _this.props.handleKeyDown(evt);
          });
        } else {
          _this.props.handleKeyDown(evt);
        }
      }
    }), _temp));
  }

  _createClass(ClickableTile, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(_ref2) {
      var clicked = _ref2.clicked;

      if (clicked !== this.props.clicked) {
        this.setState({
          clicked: clicked
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _props2 = this.props,
          children = _props2.children,
          href = _props2.href,
          className = _props2.className,
          handleClick = _props2.handleClick,
          handleKeyDown = _props2.handleKeyDown,
          clicked = _props2.clicked,
          other = _objectWithoutProperties(_props2, ["children", "href", "className", "handleClick", "handleKeyDown", "clicked"]);

      var classes = (0, _classnames.default)('bx--tile', 'bx--tile--clickable', {
        'bx--tile--is-clicked': this.state.clicked
      }, className);
      return _react.default.createElement("a", _extends({
        href: href,
        className: classes
      }, other, {
        onClick: this.handleClick,
        onKeyDown: this.handleKeyDown
      }), children);
    }
  }]);

  return ClickableTile;
}(_react.Component);

exports.ClickableTile = ClickableTile;
Object.defineProperty(ClickableTile, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: _propTypes.default.node,
    className: _propTypes.default.string,
    href: _propTypes.default.string
  }
});
Object.defineProperty(ClickableTile, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    clicked: false,
    handleClick: function handleClick() {},
    handleKeyDown: function handleKeyDown() {}
  }
});

var SelectableTile =
/*#__PURE__*/
function (_Component3) {
  _inherits(SelectableTile, _Component3);

  function SelectableTile() {
    var _ref3;

    var _temp2, _this2;

    _classCallCheck(this, SelectableTile);

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return _possibleConstructorReturn(_this2, (_temp2 = _this2 = _possibleConstructorReturn(this, (_ref3 = SelectableTile.__proto__ || Object.getPrototypeOf(SelectableTile)).call.apply(_ref3, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this2), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        selected: _this2.props.selected
      }
    }), Object.defineProperty(_assertThisInitialized(_this2), "handleClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        evt.preventDefault();
        var isInput = evt.target === _this2.input;

        if (!isInput) {
          _this2.setState({
            selected: !_this2.state.selected
          }, function () {
            _this2.props.handleClick(evt);
          });
        } else {
          _this2.props.handleClick(evt);
        }
      }
    }), Object.defineProperty(_assertThisInitialized(_this2), "handleKeyDown", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        evt.preventDefault();

        if (evt.which === 13 || evt.which === 32) {
          _this2.setState({
            selected: !_this2.state.selected
          }, function () {
            _this2.props.handleKeyDown(evt);
          });
        } else {
          _this2.props.handleKeyDown(evt);
        }
      }
    }), _temp2));
  }

  _createClass(SelectableTile, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(_ref4) {
      var selected = _ref4.selected;

      if (selected !== this.props.selected) {
        this.setState({
          selected: selected
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _props3 = this.props,
          children = _props3.children,
          id = _props3.id,
          tabIndex = _props3.tabIndex,
          value = _props3.value,
          name = _props3.name,
          title = _props3.title,
          className = _props3.className,
          handleClick = _props3.handleClick,
          handleKeyDown = _props3.handleKeyDown,
          other = _objectWithoutProperties(_props3, ["children", "id", "tabIndex", "value", "name", "title", "className", "handleClick", "handleKeyDown"]);

      var classes = (0, _classnames.default)('bx--tile', 'bx--tile--selectable', className);
      return (// eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
        _react.default.createElement("label", _extends({
          htmlFor: id,
          className: classes,
          tabIndex: tabIndex
        }, other, {
          onClick: this.handleClick,
          onKeyDown: this.handleKeyDown
        }), _react.default.createElement("input", {
          ref: function ref(input) {
            _this3.input = input;
          },
          tabIndex: -1,
          id: id,
          className: "bx--tile-input",
          value: value,
          type: "checkbox",
          name: name,
          title: title,
          checked: this.state.selected
        }), _react.default.createElement("div", {
          className: "bx--tile__checkmark"
        }, _react.default.createElement(_Icon.default, {
          name: "checkmark--glyph",
          description: "Tile checkmark"
        })), _react.default.createElement("div", {
          className: "bx--tile-content"
        }, children))
      );
    }
  }]);

  return SelectableTile;
}(_react.Component);

exports.SelectableTile = SelectableTile;
Object.defineProperty(SelectableTile, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: _propTypes.default.node,
    className: _propTypes.default.string,
    selected: _propTypes.default.bool,
    id: _propTypes.default.string,
    value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired,
    name: _propTypes.default.string,
    title: _propTypes.default.string
  }
});
Object.defineProperty(SelectableTile, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    value: 'value',
    title: 'title',
    selected: false,
    handleClick: function handleClick() {},
    handleKeyDown: function handleKeyDown() {}
  }
});

var ExpandableTile =
/*#__PURE__*/
function (_Component4) {
  _inherits(ExpandableTile, _Component4);

  function ExpandableTile() {
    var _ref5;

    var _temp3, _this4;

    _classCallCheck(this, ExpandableTile);

    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    return _possibleConstructorReturn(_this4, (_temp3 = _this4 = _possibleConstructorReturn(this, (_ref5 = ExpandableTile.__proto__ || Object.getPrototypeOf(ExpandableTile)).call.apply(_ref5, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this4), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        expanded: _this4.props.expanded,
        tileMaxHeight: _this4.props.tileMaxHeight,
        tilePadding: _this4.props.tilePadding
      }
    }), Object.defineProperty(_assertThisInitialized(_this4), "componentDidMount", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        if (_this4.refs[0]) {
          _this4.aboveTheFold = _reactDom.default.findDOMNode(_this4.refs[0]); // eslint-disable-line
        }

        var getStyle = window.getComputedStyle(_this4.tile, null);

        _this4.setState({
          tileMaxHeight: _this4.aboveTheFold.getBoundingClientRect().height,
          tilePadding: parseInt(getStyle.getPropertyValue('padding-top'), 10) + parseInt(getStyle.getPropertyValue('padding-bottom'), 10)
        });
      }
    }), Object.defineProperty(_assertThisInitialized(_this4), "setMaxHeight", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        if (_this4.state.expanded) {
          _this4.setState({
            tileMaxHeight: _this4.tileContent.getBoundingClientRect().height
          });
        } else {
          _this4.setState({
            tileMaxHeight: _this4.aboveTheFold.getBoundingClientRect().height
          });
        }
      }
    }), Object.defineProperty(_assertThisInitialized(_this4), "handleClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        _this4.setState({
          expanded: !_this4.state.expanded
        }, function () {
          _this4.setMaxHeight();

          _this4.props.handleClick(evt);
        });
      }
    }), Object.defineProperty(_assertThisInitialized(_this4), "getChildren", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        return _react.default.Children.map(_this4.props.children, function (child) {
          return child;
        });
      }
    }), _temp3));
  }

  _createClass(ExpandableTile, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(_ref6) {
      var expanded = _ref6.expanded,
          tileMaxHeight = _ref6.tileMaxHeight,
          tilePadding = _ref6.tilePadding;

      if (expanded !== this.props.expanded) {
        this.setState({
          expanded: expanded
        });
      }

      if (tileMaxHeight !== this.props.tileMaxHeight) {
        this.setState({
          tileMaxHeight: tileMaxHeight
        });
      }

      if (tilePadding !== this.props.tilePadding) {
        this.setState({
          tilePadding: tilePadding
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this5 = this;

      var _props4 = this.props,
          tabIndex = _props4.tabIndex,
          className = _props4.className,
          tileMaxHeight = _props4.tileMaxHeight,
          tilePadding = _props4.tilePadding,
          handleClick = _props4.handleClick,
          expanded = _props4.expanded,
          tileCollapsedIconText = _props4.tileCollapsedIconText,
          tileExpandedIconText = _props4.tileExpandedIconText,
          other = _objectWithoutProperties(_props4, ["tabIndex", "className", "tileMaxHeight", "tilePadding", "handleClick", "expanded", "tileCollapsedIconText", "tileExpandedIconText"]);

      var classes = (0, _classnames.default)('bx--tile', 'bx--tile--expandable', {
        'bx--tile--is-expanded': this.state.expanded
      }, className);
      var tileStyle = {
        maxHeight: this.state.tileMaxHeight + this.state.tilePadding
      };
      var content = this.getChildren().map(function (child, index) {
        return _react.default.cloneElement(child, {
          ref: index
        });
      });
      return (// eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
        _react.default.createElement("div", _extends({
          ref: function ref(tile) {
            _this5.tile = tile;
          },
          style: tileStyle,
          className: classes
        }, other, {
          role: "button",
          onClick: this.handleClick,
          tabIndex: tabIndex
        }), _react.default.createElement("button", {
          className: "bx--tile__chevron"
        }, _react.default.createElement(_Icon.default, {
          name: "chevron--down",
          description: this.state.expanded ? tileExpandedIconText : tileCollapsedIconText
        })), _react.default.createElement("div", {
          ref: function ref(tileContent) {
            _this5.tileContent = tileContent;
          },
          className: "bx--tile-content"
        }, content))
      );
    }
  }]);

  return ExpandableTile;
}(_react.Component);

exports.ExpandableTile = ExpandableTile;
Object.defineProperty(ExpandableTile, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: _propTypes.default.node,
    className: _propTypes.default.string,
    expanded: _propTypes.default.bool,
    tabIndex: _propTypes.default.number,
    tileCollapsedIconText: _propTypes.default.string,
    tileExpandedIconText: _propTypes.default.string
  }
});
Object.defineProperty(ExpandableTile, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    tabIndex: 0,
    expanded: false,
    tileMaxHeight: '0',
    handleClick: function handleClick() {},
    tileCollapsedIconText: 'Expand',
    tileExpandedIconText: 'Collapse'
  }
});

var TileAboveTheFoldContent =
/*#__PURE__*/
function (_Component5) {
  _inherits(TileAboveTheFoldContent, _Component5);

  function TileAboveTheFoldContent() {
    _classCallCheck(this, TileAboveTheFoldContent);

    return _possibleConstructorReturn(this, (TileAboveTheFoldContent.__proto__ || Object.getPrototypeOf(TileAboveTheFoldContent)).apply(this, arguments));
  }

  _createClass(TileAboveTheFoldContent, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      return _react.default.createElement("span", {
        className: "bx--tile-content__above-the-fold"
      }, children);
    }
  }]);

  return TileAboveTheFoldContent;
}(_react.Component);

exports.TileAboveTheFoldContent = TileAboveTheFoldContent;
Object.defineProperty(TileAboveTheFoldContent, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: _propTypes.default.node,
    className: _propTypes.default.string
  }
});

var TileBelowTheFoldContent =
/*#__PURE__*/
function (_Component6) {
  _inherits(TileBelowTheFoldContent, _Component6);

  function TileBelowTheFoldContent() {
    _classCallCheck(this, TileBelowTheFoldContent);

    return _possibleConstructorReturn(this, (TileBelowTheFoldContent.__proto__ || Object.getPrototypeOf(TileBelowTheFoldContent)).apply(this, arguments));
  }

  _createClass(TileBelowTheFoldContent, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      return _react.default.createElement("span", {
        className: "bx--tile-content__below-the-fold"
      }, children);
    }
  }]);

  return TileBelowTheFoldContent;
}(_react.Component);

exports.TileBelowTheFoldContent = TileBelowTheFoldContent;
Object.defineProperty(TileBelowTheFoldContent, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: _propTypes.default.node,
    className: _propTypes.default.string
  }
});