'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _Tile = require('../Tile');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _react3.storiesOf)('Tile', module).addWithInfo('Default', '\n      Default tile without any interactions\n    ', function () {
  return _react2.default.createElement(
    _Tile.Tile,
    null,
    'Default tile'
  );
}).addWithInfo('Clickable', '\n      Clickable tile\n    ', function () {
  return _react2.default.createElement(
    _Tile.ClickableTile,
    null,
    'Clickable Tile'
  );
}).addWithInfo('Selectable', '\n      Selectable tile\n    ', function () {
  return _react2.default.createElement(
    _Tile.SelectableTile,
    { id: 'tile-1', name: 'tiles' },
    'Selectable Tile'
  );
}).addWithInfo('Expandable', '\n      Expandable tile\n    ', function () {
  return _react2.default.createElement(
    _Tile.ExpandableTile,
    null,
    _react2.default.createElement(
      _Tile.TileAboveTheFoldContent,
      null,
      _react2.default.createElement(
        'div',
        { style: { height: '200px' } },
        'Above the fold content here'
      )
    ),
    _react2.default.createElement(
      _Tile.TileBelowTheFoldContent,
      null,
      _react2.default.createElement(
        'div',
        { style: { height: '400px' } },
        'Below the fold content here'
      )
    )
  );
});