'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _TextInput = require('../TextInput');

var _TextInput2 = _interopRequireDefault(_TextInput);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TextInputProps = {
  className: 'some-class',
  id: 'test2',
  labelText: 'Text Input label',
  onClick: (0, _addonActions.action)('onClick'),
  onChange: (0, _addonActions.action)('onChange'),
  placeholder: 'Placeholder text'
};

var introText = '\n  Text fields enable the user to interact with and input data. A single line\n  field is used when the input anticipated by the user is a single line of\n  text as opposed to a paragraph.\n';

(0, _react3.storiesOf)('TextInput', module).addWithInfo('enabled', '\n      ' + introText + '\n      The example below shows an enabled Text Input component. The default type is \'text\' and its\n      value can be either \'string\' or \'number\'.\n    ', function () {
  return _react2.default.createElement(_TextInput2.default, TextInputProps);
}).addWithInfo('disabled', '\n      ' + introText + '\n      The example below shows a disabled Text Input component.\n    ', function () {
  return _react2.default.createElement(_TextInput2.default, _extends({ disabled: true }, TextInputProps));
}).addWithInfo('email', '\n      ' + introText + '\n      The example below shows an enabled Text Input component with type \'email\'.\n    ', function () {
  return _react2.default.createElement(_TextInput2.default, _extends({}, TextInputProps, {
    type: 'email',
    placeholder: 'Please enter an email'
  }));
}).addWithInfo('password', '\n      ' + introText + '\n      The example below shows an enabled Text Input component with type \'password\'.\n    ', function () {
  return _react2.default.createElement(_TextInput2.default, _extends({}, TextInputProps, {
    type: 'password',
    placeholder: 'Please enter a password'
  }));
}).addWithInfo('invalid', '\n      ' + introText + '\n      The example below shows an invalid entry in the Text Input.\n    ', function () {
  return _react2.default.createElement(_TextInput2.default, _extends({}, TextInputProps, {
    invalid: true,
    invalidText: 'A valid value is required'
  }));
});