'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Tag = require('../Tag');

var _Tag2 = _interopRequireDefault(_Tag);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Tag', function () {
  describe('Renders as expected', function () {
    it('should render with the appropriate type', function () {
      var tag = (0, _enzyme.shallow)(_react2.default.createElement(_Tag2.default, { type: 'beta' }));
      expect(tag.hasClass('bx--tag')).toEqual(true);
      expect(tag.hasClass('bx--tag--beta')).toEqual(true);
    });

    it('should provide a default label based on the type', function () {
      var tag = (0, _enzyme.shallow)(_react2.default.createElement(_Tag2.default, { type: 'beta' }));
      expect(tag.text()).toEqual('Beta');
      tag.setProps({ type: 'ibm' });
      expect(tag.text()).toEqual('IBM');
    });
  });

  it('should allow for a custom label', function () {
    var tag = (0, _enzyme.shallow)(_react2.default.createElement(
      _Tag2.default,
      { type: 'beta' },
      'New Version!'
    ));
    expect(tag.text()).toEqual('New Version!');
  });

  it('should support extra class names', function () {
    var tag = (0, _enzyme.shallow)(_react2.default.createElement(_Tag2.default, { type: 'beta', className: 'extra-class' }));
    expect(tag.hasClass('extra-class')).toEqual(true);
  });
});