'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TabContent = require('../TabContent');

var _TabContent2 = _interopRequireDefault(_TabContent);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('TabContent', function () {
  describe('renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _TabContent2.default,
      null,
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'content'
      ),
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'content'
      )
    ));

    it('renders children as expected', function () {
      expect(wrapper.props().children.length).toEqual(2);
    });

    it('sets selected if passed in via props', function () {
      wrapper.setProps({ selected: true });
      expect(wrapper.props().selected).toEqual(true);
    });

    it('sets selected and hidden props with opposite boolean values', function () {
      wrapper.setProps({ selected: true });
      expect(wrapper.props().hidden).toEqual(false);
    });
  });
});