'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _RadioButtonGroup = require('../RadioButtonGroup');

var _RadioButtonGroup2 = _interopRequireDefault(_RadioButtonGroup);

var _RadioButton = require('../RadioButton');

var _RadioButton2 = _interopRequireDefault(_RadioButton);

var _FormGroup = require('../FormGroup');

var _FormGroup2 = _interopRequireDefault(_FormGroup);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var radioProps = {
  className: 'some-class'
};

(0, _react3.storiesOf)('RadioButtonGroup', module).addWithInfo('Default', '\n       The example below shows a Radio Button Group component with a default selected Radio Button.\n       Although you can set the checked prop on the Radio Button, when using the Radio Button component\n       as a child of the Radio Button Group, either set the defaultSelected or valueSelected which will\n       automatically set the selected prop on the corresponding Radio Button component.\n\n       Use defaultSelected when you want a radio button to be selected initially, but don\'t need to set it\n       at a later time. If you do need to set it dynamically at a later time, then use the valueSelected property instead.\n    ', function () {
  return _react2.default.createElement(
    _FormGroup2.default,
    { legendText: 'Radio Button heading' },
    _react2.default.createElement(
      _RadioButtonGroup2.default,
      {
        onChange: (0, _addonActions.action)('onChange'),
        name: 'radio-button-group',
        defaultSelected: 'default-selected',
        legend: 'Group Legend' },
      _react2.default.createElement(_RadioButton2.default, _extends({
        value: 'standard',
        id: 'radio-1',
        labelText: 'Standard Radio Button label'
      }, radioProps)),
      _react2.default.createElement(_RadioButton2.default, _extends({
        value: 'default-selected',
        labelText: 'Default selected Radio Button',
        id: 'radio-2'
      }, radioProps)),
      _react2.default.createElement(_RadioButton2.default, _extends({
        value: 'disabled',
        labelText: 'Disabled Radio Button',
        id: 'radio-3',
        disabled: true
      }, radioProps))
    )
  );
});