'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _OverflowMenu = require('../OverflowMenu');

var _OverflowMenu2 = _interopRequireDefault(_OverflowMenu);

var _OverflowMenuItem = require('../OverflowMenuItem');

var _OverflowMenuItem2 = _interopRequireDefault(_OverflowMenuItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var overflowMenuEvents = {
  onClick: (0, _addonActions.action)('onClick'),
  className: 'some-class'
};

var overflowMenuItemEvents = {
  onClick: (0, _addonActions.action)('onClick'),
  className: 'some-class'
};

(0, _react3.storiesOf)('OverflowMenu', module).addWithInfo('basic', '\n      Overflow Menu is used when additional options are available to the user and there is a space constraint.\n      Create Overflow Menu Item components for each option on the menu.\n    ', function () {
  return _react2.default.createElement(
    _OverflowMenu2.default,
    overflowMenuEvents,
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, { itemText: 'Option 1' })),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, { itemText: 'Option 2' })),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, { itemText: 'Option 3' })),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, { itemText: 'Option 4' })),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, {
      itemText: 'Danger option',
      hasDivider: true,
      isDelete: true
    }))
  );
}).addWithInfo('floating menu', '\n      Overflow Menu with the floatingMenu prop is used when you need to place an OverflowMenu\n      inside a container with "overflow" CSS set.\n    ', function () {
  return _react2.default.createElement(
    _OverflowMenu2.default,
    _extends({}, overflowMenuEvents, { floatingMenu: true }),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, { itemText: 'Option 1' })),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, { itemText: 'Option 2' })),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, { itemText: 'Option 3' })),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, { itemText: 'Option 4' })),
    _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemEvents, {
      itemText: 'Danger option',
      hasDivider: true,
      isDelete: true
    }))
  );
});