'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _OrderSummary = require('../OrderSummary');

var _Button = require('../Button');

var _Button2 = _interopRequireDefault(_Button);

var _Dropdown = require('../Dropdown');

var _Dropdown2 = _interopRequireDefault(_Dropdown);

var _DropdownItem = require('../DropdownItem');

var _DropdownItem2 = _interopRequireDefault(_DropdownItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable no-console */

(0, _react3.storiesOf)('OrderSummary', module).addWithInfo('Simple', '\n      This component is used to display the items a user will be purchasing. This version does not include OrderSummaryCategory.\n    ', function () {
  return _react2.default.createElement(
    _OrderSummary.OrderSummary,
    null,
    _react2.default.createElement(
      _OrderSummary.OrderSummaryHeader,
      { title: 'Order Summary' },
      _react2.default.createElement(
        _Dropdown2.default,
        {
          onChange: function onChange(selectedItemInfo) {
            return console.log(selectedItemInfo);
          },
          defaultText: 'USD' },
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'USD', value: 'usd' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'GBP', value: 'gbp' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'NOK', value: 'nok' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'EUR', value: 'eur' })
      )
    ),
    _react2.default.createElement(
      _OrderSummary.OrderSummaryList,
      null,
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null),
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, { text: 'Detail 2', price: '$20.00' }),
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, { text: 'Detail 3', price: '$40.00' })
    ),
    _react2.default.createElement(
      _OrderSummary.OrderSummaryTotal,
      {
        summaryText: 'Total due now:',
        summaryPrice: '$0.00',
        summaryDetails: 'estimated' },
      _react2.default.createElement(
        _Button2.default,
        null,
        'Primary Button'
      ),
      _react2.default.createElement(
        _Button2.default,
        { kind: 'secondary' },
        'Primary Button'
      )
    ),
    _react2.default.createElement(_OrderSummary.OrderSummaryFooter, {
      footerText: 'Need Help?',
      linkText: 'Contact Bluemix Sales',
      href: 'www.google.com'
    })
  );
}).addWithInfo('Category', '\n      This component is used to display the items a user will be purchasing. The category version of OrderSummary can break the items being purchased into categories.\n    ', function () {
  return _react2.default.createElement(
    _OrderSummary.OrderSummary,
    null,
    _react2.default.createElement(
      _OrderSummary.OrderSummaryHeader,
      { title: 'Order Summary' },
      _react2.default.createElement(
        _Dropdown2.default,
        {
          onChange: function onChange(selectedItemInfo) {
            return console.log(selectedItemInfo);
          },
          defaultText: 'USD' },
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'USD', value: 'usd' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'GBP', value: 'gbp' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'NOK', value: 'nok' }),
        _react2.default.createElement(_DropdownItem2.default, { itemText: 'EUR', value: 'eur' })
      )
    ),
    _react2.default.createElement(
      _OrderSummary.OrderSummaryList,
      null,
      _react2.default.createElement(
        _OrderSummary.OrderSummaryCategory,
        null,
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null),
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, { text: 'Detail 2', price: '$20.00' }),
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, { text: 'Detail 3', price: '$40.00' })
      ),
      _react2.default.createElement(
        _OrderSummary.OrderSummaryCategory,
        null,
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null),
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, { text: 'Detail 2', price: '$20.00' }),
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, { text: 'Detail 3', price: '$40.00' })
      ),
      _react2.default.createElement(
        _OrderSummary.OrderSummaryCategory,
        null,
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null),
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, { text: 'Detail 2', price: '$20.00' }),
        _react2.default.createElement(_OrderSummary.OrderSummaryListItem, { text: 'Detail 3', price: '$40.00' })
      )
    ),
    _react2.default.createElement(
      _OrderSummary.OrderSummaryTotal,
      {
        summaryText: 'Total due now:',
        summaryPrice: '$0.00',
        summaryDetails: 'estimated' },
      _react2.default.createElement(
        _Button2.default,
        null,
        'Primary Button'
      ),
      _react2.default.createElement(
        _Button2.default,
        { kind: 'secondary' },
        'Primary Button'
      )
    ),
    _react2.default.createElement(_OrderSummary.OrderSummaryFooter, {
      footerText: 'Need Help?',
      linkText: 'Contact Bluemix Sales',
      href: 'www.google.com'
    })
  );
});