'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _InteriorLeftNavList = require('../InteriorLeftNavList');

var _InteriorLeftNavList2 = _interopRequireDefault(_InteriorLeftNavList);

var _InteriorLeftNavItem = require('../InteriorLeftNavItem');

var _InteriorLeftNavItem2 = _interopRequireDefault(_InteriorLeftNavItem);

var _Icon = require('../Icon');

var _Icon2 = _interopRequireDefault(_Icon);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('InteriorLeftNavList', function () {
  describe('Renders as expected', function () {
    var openList = (0, _enzyme.shallow)(_react2.default.createElement(
      _InteriorLeftNavList2.default,
      { className: 'extra-class', title: 'test-title', open: true },
      _react2.default.createElement(
        _InteriorLeftNavItem2.default,
        { href: '' },
        _react2.default.createElement(
          'a',
          { href: 'http://www.carbondesignsystem.com' },
          'test-title'
        )
      )
    ));

    var closedList = (0, _enzyme.shallow)(_react2.default.createElement(
      _InteriorLeftNavList2.default,
      null,
      _react2.default.createElement(
        _InteriorLeftNavItem2.default,
        { href: '' },
        _react2.default.createElement(
          'a',
          { href: 'http://www.carbondesignsystem.com' },
          'test-title'
        )
      )
    ));

    var expectedChildrenList = (0, _enzyme.shallow)(_react2.default.createElement(
      _InteriorLeftNavList2.default,
      null,
      _react2.default.createElement(
        _InteriorLeftNavItem2.default,
        { href: '', className: 'test-child' },
        _react2.default.createElement(
          'a',
          { href: 'http://www.carbondesignsystem.com' },
          'test-title'
        )
      ),
      _react2.default.createElement(
        _InteriorLeftNavItem2.default,
        { href: '', className: 'test-child' },
        _react2.default.createElement(
          'a',
          { href: 'http://www.carbondesignsystem.com' },
          'test-title'
        )
      )
    ));

    it('renders a interior left nav list', function () {
      expect(openList.length).toEqual(1);
    });
    it('has the expected classes', function () {
      expect(openList.hasClass('left-nav-list__item--has-children')).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(openList.hasClass('extra-class')).toEqual(true);
    });
    it('should have children with tab index of zero when open', function () {
      expect(openList.find(_InteriorLeftNavItem2.default).props().tabIndex).toEqual(0);
    });
    it('should have children with tab index of negative one when closed', function () {
      expect(closedList.find(_InteriorLeftNavItem2.default).props().tabIndex).toEqual(-1);
    });
    it('has the expected class when open', function () {
      expect(openList.hasClass('left-nav-list__item--expanded')).toEqual(true);
    });
    it('should not have the expanded class when closed', function () {
      expect(closedList.hasClass('left-nav-list__item--expanded')).toEqual(false);
    });
    it('should use correct icon', function () {
      var icon = openList.find(_Icon2.default);
      expect(icon.props().name).toEqual('chevron--down');
    });
    it('should use correct icon class names', function () {
      var icon = openList.find(_Icon2.default);
      expect(icon.props().className).toEqual('left-nav-list__item-icon bx--interior-left-nav__icon');
    });
    it('should render children as expected', function () {
      expect(expectedChildrenList.find('.left-nav-list__item-link').length).toEqual(1);
      expect(expectedChildrenList.find('.left-nav-list--nested').length).toEqual(1);
      expect(expectedChildrenList.find('.test-child').length).toEqual(2);
    });
  });

  describe('Check that functions passed in as props are called', function () {
    var onListClick = jest.fn();
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_InteriorLeftNavList2.default, { onListClick: onListClick }));

    it('should call onListClick', function () {
      wrapper.simulate('click');
      expect(onListClick).toBeCalled();
    });
  });

  describe('calling the close method should close the list when open', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_InteriorLeftNavList2.default, { open: true }));

    it('should close the list', function () {
      wrapper.instance().close();
      expect(wrapper.state().open).toEqual(false);
    });
  });

  describe('actions', function () {
    var list = (0, _enzyme.mount)(_react2.default.createElement(
      _InteriorLeftNavList2.default,
      { title: 'test-title' },
      _react2.default.createElement(
        _InteriorLeftNavItem2.default,
        { href: '' },
        _react2.default.createElement(
          'a',
          { href: 'http://www.carbondesignsystem.com' },
          'test-title'
        )
      )
    ));

    it('handles click to leftNavList as expected', function () {
      list.setState({ open: false });
      list.simulate('click');
      expect(list.state().open).toEqual(true);
    });

    it('should toggle the leftNavList on Enter', function () {
      list.setState({ open: false });
      list.simulate('keypress', { which: 13 });
      expect(list.state().open).toEqual(true);
      list.simulate('keypress', { which: 13 });
      expect(list.state().open).toEqual(false);
    });

    it('should toggle the leftNavList on Space', function () {
      list.setState({ open: false });
      list.simulate('keypress', { which: 32 });
      expect(list.state().open).toEqual(true);
      list.simulate('keypress', { which: 32 });
      expect(list.state().open).toEqual(false);
    });
  });
});