'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _DatePicker = require('../DatePicker');

var _DatePicker2 = _interopRequireDefault(_DatePicker);

var _DatePickerInput = require('../DatePickerInput');

var _DatePickerInput2 = _interopRequireDefault(_DatePickerInput);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Datepickers last argument contains an instance of flatpickr
// and will cause action logger to enter an infinite loop. Just don't log that argument
var datePickerOnChangeActions = (0, _addonActions.decorateAction)([function (args) {
  return args.slice(0, args.length - 2);
}]);

var datePickerProps = {
  id: 'date-picker',
  onChange: datePickerOnChangeActions('onPickerChange')
};

var datePickerInputProps = {
  className: 'some-class',
  labelText: 'Date Picker label',
  onClick: (0, _addonActions.action)('onClick'),
  onChange: (0, _addonActions.action)('onInputChange'),
  placeholder: 'mm/dd/yyyy',
  pattern: 'd{1,2}/d{1,2}/d{4}',
  id: 'date-picker-input-id'
};

var simpleShortDatePickerInputProps = {
  placeholder: 'mm/yyyy',
  pattern: 'd{1,2}/d{4}'
};

(0, _react3.storiesOf)('DatePicker', module).addWithInfo('simple and short', '\n      A simple Date Picker consists of an input field and no calendar.\n    ', function () {
  return _react2.default.createElement(
    _DatePicker2.default,
    _extends({}, datePickerProps, { short: true, datePickerType: 'simple' }),
    _react2.default.createElement(_DatePickerInput2.default, _extends({}, datePickerInputProps, simpleShortDatePickerInputProps))
  );
}).addWithInfo('simple and normal', '\n      A simple Date Picker consists of an input field and no calendar.\n    ', function () {
  return _react2.default.createElement(
    _DatePicker2.default,
    { id: 'date-picker', datePickerType: 'simple' },
    _react2.default.createElement(_DatePickerInput2.default, datePickerInputProps)
  );
}).addWithInfo('single with calendar', '\n      A single Date Picker consists of an input field and a calendar.\n    ', function () {
  return _react2.default.createElement(
    _DatePicker2.default,
    _extends({}, datePickerProps, {
      datePickerType: 'single',
      dateFormat: 'm/d/Y' }),
    _react2.default.createElement(_DatePickerInput2.default, datePickerInputProps)
  );
}).addWithInfo('range with calendar', '\n      A range Date Picker consists of two input fields and a calendar.\n    ', function () {
  return _react2.default.createElement(
    _DatePicker2.default,
    _extends({}, datePickerProps, {
      datePickerType: 'range',
      dateFormat: 'm/d/Y' }),
    _react2.default.createElement(_DatePickerInput2.default, _extends({}, datePickerInputProps, { id: 'date-picker-input-id' })),
    _react2.default.createElement(_DatePickerInput2.default, _extends({}, datePickerInputProps, {
      id: 'date-picker-input-id-2'
    }))
  );
});