'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _enzyme = require('enzyme');

var _testHelpers = require('../ListBox/test-helpers');

var _ComboBox = require('../ComboBox');

var _ComboBox2 = _interopRequireDefault(_ComboBox);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var findInputNode = function findInputNode(wrapper) {
  return wrapper.find('.bx--text-input');
};
var clearInput = function clearInput(wrapper) {
  return wrapper.instance().handleOnInputValueChange('');
};

describe('ComboBox', function () {
  var mockProps = void 0;

  beforeEach(function () {
    mockProps = {
      items: (0, _testHelpers.generateItems)(5, _testHelpers.generateGenericItem),
      onChange: jest.fn(),
      placeholder: 'Filter...',
      type: 'default'
    };
  });

  it('should display the placeholder text when no items are selected and the control is not focused', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_ComboBox2.default, mockProps));
    expect(findInputNode(wrapper).prop('value')).toBe('');
    expect(findInputNode(wrapper).prop('placeholder')).toBe(mockProps.placeholder);
  });

  it('should display the menu of items when a user clicks on the input', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_ComboBox2.default, mockProps));
    findInputNode(wrapper).simulate('click');

    (0, _testHelpers.assertMenuOpen)(wrapper, mockProps);
  });

  it('should display the initially selected item found in `initialSelectedItem`', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_ComboBox2.default, _extends({}, mockProps, { initialSelectedItem: mockProps.items[0] })));
    expect(findInputNode(wrapper).prop('value')).toEqual(mockProps.items[0].label);
  });

  it('should call `onChange` each time an item is selected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_ComboBox2.default, mockProps));
    expect(mockProps.onChange).not.toHaveBeenCalled();

    for (var i = 0; i < mockProps.items.length; i++) {
      clearInput(wrapper);
      (0, _testHelpers.openMenu)(wrapper);
      (0, _testHelpers.findMenuItemNode)(wrapper, i).simulate('click');
      expect(mockProps.onChange).toHaveBeenCalledTimes(i + 1);
      expect(mockProps.onChange).toHaveBeenCalledWith({
        selectedItem: mockProps.items[i]
      });
    }
  });

  describe('when disabled', function () {
    it('should not let the user edit the input node', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_ComboBox2.default, _extends({}, mockProps, { disabled: true })));
      expect(findInputNode(wrapper).prop('disabled')).toBe(true);
      expect(findInputNode(wrapper).prop('value')).toBe('');

      findInputNode(wrapper).simulate('change', {
        target: {
          value: 'a'
        }
      });

      expect(findInputNode(wrapper).prop('value')).toBe('');
    });

    it('should not let the user expand the menu', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_ComboBox2.default, _extends({}, mockProps, { disabled: true })));
      (0, _testHelpers.openMenu)(wrapper);
      expect((0, _testHelpers.findMenuNode)(wrapper).length).toBe(0);
    });
  });

  describe('downshift quirks', function () {
    it('should not trigger the menu when typing a space in input', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_ComboBox2.default, mockProps));

      (0, _testHelpers.openMenu)(wrapper);
      findInputNode(wrapper).simulate('change', {
        target: {
          value: ' '
        }
      });

      expect((0, _testHelpers.findMenuNode)(wrapper).length).toBe(1);
    });

    it('should set `inputValue` to an empty string if a falsey-y value is given', function () {
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_ComboBox2.default, mockProps));

      wrapper.instance().handleOnInputValueChange('foo');
      expect(wrapper.state('inputValue')).toBe('foo');

      wrapper.instance().handleOnInputValueChange(null);
      expect(wrapper.state('inputValue')).toBe('');
    });
  });
});