'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _CodeSnippet = require('../CodeSnippet');

var _CodeSnippet2 = _interopRequireDefault(_CodeSnippet);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Code Snippet', function () {
  describe('Renders as expected', function () {
    var snippet = (0, _enzyme.shallow)(_react2.default.createElement(
      _CodeSnippet2.default,
      { className: 'some-class', type: 'terminal' },
      'node -v'
    ));

    it('should use the appropriate snippet class', function () {
      expect(snippet.hasClass('bx--snippet')).toEqual(true);
      expect(snippet.hasClass('bx--snippet--terminal')).toEqual(true);
    });

    it('should render children as expected', function () {
      expect(snippet.find('.bx--snippet-container').length).toBe(1);
    });

    it('should all for custom classes to be applied', function () {
      expect(snippet.hasClass('some-class')).toEqual(true);
    });
  });

  it('should expose a `ref` to the content through `wrappedContentRef`', function () {
    var mockRef = void 0;
    var wrappedContentRef = jest.fn(function (el) {
      return mockRef = el;
    });
    var content = 'node -v';
    (0, _enzyme.mount)(_react2.default.createElement(
      _CodeSnippet2.default,
      { type: 'terminal', wrappedContentRef: wrappedContentRef },
      content
    ));
    expect(mockRef.textContent).toBe(content);
    expect(wrappedContentRef).toHaveBeenCalledTimes(1);
  });
});