var _defaultTranslations;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import PropTypes from 'prop-types';
import React from 'react';
import isEqual from 'lodash.isequal';
import getDerivedStateFromProps from './state/getDerivedStateFromProps';
import { getNextSortState } from './state/sorting';
import denormalize from './tools/denormalize';
import { composeEventHandlers } from './tools/events';
import { defaultFilterRows } from './tools/filter';
import { defaultSortRow } from './tools/sorting';
import setupGetInstanceId from './tools/instanceId';
var getInstanceId = setupGetInstanceId();
var translationKeys = {
  expandRow: 'carbon.table.row.expand',
  collapseRow: 'carbon.table.row.collapse',
  selectAll: 'carbon.table.all.select',
  unselectAll: 'carbon.table.all.unselect',
  selectRow: 'carbon.table.row.select',
  unselectRow: 'carbon.table.row.unselect'
};
var defaultTranslations = (_defaultTranslations = {}, _defineProperty(_defaultTranslations, translationKeys.expandRow, 'Expand current row'), _defineProperty(_defaultTranslations, translationKeys.collapseRow, 'Collapse current row'), _defineProperty(_defaultTranslations, translationKeys.selectAll, 'Select all rows'), _defineProperty(_defaultTranslations, translationKeys.unselectAll, 'Unselect all rows'), _defineProperty(_defaultTranslations, translationKeys.selectRow, 'Select row'), _defineProperty(_defaultTranslations, translationKeys.unselectRow, 'Unselect row'), _defaultTranslations);

var translateWithId = function translateWithId(id) {
  return defaultTranslations[id];
};
/**
 * Data Tables are used to represent a collection of resources, displaying a
 * subset of their fields in columns, or headers. We prioritize direct updates
 * to the state of what we're rendering, so internally we end up normalizing the
 * given data and then denormalizing it when rendering.
 *
 * As a result, each part of the DataTable is accessible through look-up by id,
 * and updating the state of the single entity will cascade updates to the
 * consumer.
 */


var DataTable =
/*#__PURE__*/
function (_React$Component) {
  _inherits(DataTable, _React$Component);

  function DataTable(props) {
    var _this;

    _classCallCheck(this, DataTable);

    _this = _possibleConstructorReturn(this, (DataTable.__proto__ || Object.getPrototypeOf(DataTable)).call(this, props));

    _initialiseProps.call(_assertThisInitialized(_this));

    _this.state = getDerivedStateFromProps(props, {});
    _this.instanceId = getInstanceId();
    return _this;
  }

  _createClass(DataTable, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      var rowIds = this.props.rows.map(function (row) {
        return row.id;
      });
      var nextRowIds = nextProps.rows.map(function (row) {
        return row.id;
      });

      if (!isEqual(rowIds, nextRowIds)) {
        this.setState(function (state) {
          return getDerivedStateFromProps(nextProps, state);
        });
        return;
      }

      var headers = this.props.headers.map(function (header) {
        return header.key;
      });
      var nextHeaders = nextProps.headers.map(function (header) {
        return header.key;
      });

      if (!isEqual(headers, nextHeaders)) {
        this.setState(function (state) {
          return getDerivedStateFromProps(nextProps, state);
        });
        return;
      }

      if (!isEqual(this.props.rows, nextProps.rows)) {
        this.setState(function (state) {
          return getDerivedStateFromProps(nextProps, state);
        });
        return;
      }
    }
    /**
     * Get the props associated with the given header. Mostly used for adding in
     * sorting behavior.
     *
     * @param {Object} config
     * @param {string} config.header the header we want the props for
     * @param {Function} config.onClick a custom click handler for the header
     * @returns {Object}
     */

  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          children = _props.children,
          filterRows = _props.filterRows,
          headers = _props.headers,
          render = _props.render;
      var _state = this.state,
          filterInputValue = _state.filterInputValue,
          rowIds = _state.rowIds,
          rowsById = _state.rowsById,
          cellsById = _state.cellsById;
      var filteredRowIds = typeof filterInputValue === 'string' ? filterRows({
        rowIds: rowIds,
        headers: headers,
        cellsById: cellsById,
        inputValue: filterInputValue
      }) : rowIds;
      var renderProps = {
        // Data derived from state
        rows: denormalize(filteredRowIds, rowsById, cellsById),
        headers: this.props.headers,
        selectedRows: denormalize(this.getSelectedRows(), rowsById, cellsById),
        // Prop accessors/getters
        getHeaderProps: this.getHeaderProps,
        getRowProps: this.getRowProps,
        getSelectionProps: this.getSelectionProps,
        getBatchActionProps: this.getBatchActionProps,
        // Custom event handlers
        onInputChange: this.handleOnInputValueChange,
        // Expose internal state change actions
        sortBy: function sortBy(headerKey) {
          return _this2.handleSortBy(headerKey)();
        },
        selectAll: this.handleSelectAll,
        selectRow: function selectRow(rowId) {
          return _this2.handleOnSelectRow(rowId)();
        },
        expandRow: function expandRow(rowId) {
          return _this2.handleOnExpandRow(rowId)();
        }
      };

      if (render !== undefined) {
        return render(renderProps);
      }

      if (children !== undefined) {
        return children(renderProps);
      }

      return null;
    }
  }]);

  return DataTable;
}(React.Component);

Object.defineProperty(DataTable, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    /**
     * The `rows` prop is where you provide us with a list of all the rows that
     * you want to render in the table. The only hard requirement is that this
     * is an array of objects, and that each object has a unique `id` field
     * available on it.
     */
    rows: PropTypes.arrayOf(PropTypes.shape({
      id: PropTypes.string.isRequired
    })).isRequired,

    /**
     * The `headers` prop represents the order in which the headers should
     * appear in the table. We expect an array of objects to be passed in, where
     * `key` is the name of the key in a row object, and `header` is the name of
     * the header.
     */
    headers: PropTypes.arrayOf(PropTypes.shape({
      key: PropTypes.string.isRequired,
      header: PropTypes.string.isRequired
    })).isRequired,

    /**
     * Optional hook to manually control sorting of the rows.
     */
    sortRow: PropTypes.func,

    /**
     * Optional hook to manually control filtering of the rows from the
     * TableToolbarSearch component
     */
    filterRows: PropTypes.func,

    /**
     * Provide a string for the current locale
     */
    locale: PropTypes.string,

    /**
     * Optional method that takes in a message id and returns an
     * internationalized string. See `DataTable.translationKeys` for all
     * available message ids.
     */
    translateWithId: PropTypes.func
  }
});
Object.defineProperty(DataTable, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    sortRow: defaultSortRow,
    filterRows: defaultFilterRows,
    locale: 'en',
    translateWithId: translateWithId
  }
});
Object.defineProperty(DataTable, "translationKeys", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: Object.values(translationKeys)
});

var _initialiseProps = function _initialiseProps() {
  var _this3 = this;

  Object.defineProperty(this, "getHeaderProps", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(_ref) {
      var header = _ref.header,
          onClick = _ref.onClick,
          rest = _objectWithoutProperties(_ref, ["header", "onClick"]);

      var _this3$state = _this3.state,
          sortDirection = _this3$state.sortDirection,
          sortHeaderKey = _this3$state.sortHeaderKey;
      return _extends({}, rest, {
        key: header.key,
        sortDirection: sortDirection,
        isSortable: true,
        isSortHeader: sortHeaderKey === header.key,
        // Compose the event handlers so we don't overwrite a consumer's `onClick`
        // handler
        onClick: composeEventHandlers([_this3.handleSortBy(header.key), onClick])
      });
    }
  });
  Object.defineProperty(this, "getRowProps", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(_ref2) {
      var row = _ref2.row,
          onClick = _ref2.onClick,
          rest = _objectWithoutProperties(_ref2, ["row", "onClick"]);

      var t = _this3.props.translateWithId;
      var translationKey = row.isExpanded ? translationKeys.collapseRow : translationKeys.expandRow;
      return _extends({}, rest, {
        key: row.id,
        // Compose the event handlers so we don't overwrite a consumer's `onClick`
        // handler
        onExpand: composeEventHandlers([_this3.handleOnExpandRow(row.id), onClick]),
        isExpanded: row.isExpanded,
        ariaLabel: t(translationKey)
      });
    }
  });
  Object.defineProperty(this, "getSelectionProps", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value() {
      var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var onClick = _ref3.onClick,
          row = _ref3.row,
          rest = _objectWithoutProperties(_ref3, ["onClick", "row"]);

      var t = _this3.props.translateWithId; // If we're given a row, return the selection state values for that row

      if (row) {
        var _translationKey = row.isSelected ? translationKeys.unselectRow : translationKeys.selectRow;

        return _extends({}, rest, {
          checked: row.isSelected,
          onSelect: composeEventHandlers([_this3.handleOnSelectRow(row.id), onClick]),
          id: "".concat(_this3.getTablePrefix(), "__select-row-").concat(row.id),
          name: "select-row-".concat(row.id),
          ariaLabel: t(_translationKey)
        });
      } // Otherwise, we're working on `TableSelectAll` which handles toggling the
      // selection state of all rows.


      var rowCount = _this3.state.rowIds.length;

      var selectedRowCount = _this3.getSelectedRows().length;

      var checked = rowCount > 0 && selectedRowCount === rowCount;
      var indeterminate = rowCount > 0 && selectedRowCount > 0 && selectedRowCount !== rowCount;
      var translationKey = checked ? translationKeys.unselectAll : translationKeys.selectAll;
      return _extends({}, rest, {
        ariaLabel: t(translationKey),
        checked: checked,
        id: "".concat(_this3.getTablePrefix(), "__select-all"),
        indeterminate: indeterminate,
        name: 'select-all',
        onSelect: composeEventHandlers([_this3.handleSelectAll, onClick])
      });
    }
  });
  Object.defineProperty(this, "getBatchActionProps", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var shouldShowBatchActions = _this3.state.shouldShowBatchActions;

      var totalSelected = _this3.getSelectedRows().length;

      return _extends({}, props, {
        shouldShowBatchActions: shouldShowBatchActions,
        totalSelected: totalSelected,
        onCancel: _this3.handleOnCancel
      });
    }
  });
  Object.defineProperty(this, "getSelectedRows", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value() {
      return _this3.state.rowIds.filter(function (id) {
        var row = _this3.state.rowsById[id];
        return row.isSelected;
      });
    }
  });
  Object.defineProperty(this, "getTablePrefix", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value() {
      return "data-table-".concat(_this3.instanceId);
    }
  });
  Object.defineProperty(this, "setAllSelectedState", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(initialState, isSelected) {
      var rowIds = initialState.rowIds;
      return {
        rowsById: rowIds.reduce(function (acc, id) {
          return _extends({}, acc, _defineProperty({}, id, _extends({}, initialState.rowsById[id], {
            isSelected: isSelected
          })));
        }, {})
      };
    }
  });
  Object.defineProperty(this, "handleOnCancel", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value() {
      _this3.setState(function (state) {
        return _extends({
          shouldShowBatchActions: false
        }, _this3.setAllSelectedState(state, false));
      });
    }
  });
  Object.defineProperty(this, "handleSelectAll", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value() {
      _this3.setState(function (state) {
        var rowIds = state.rowIds;
        var isSelected = _this3.getSelectedRows().length !== rowIds.length;
        return _extends({
          shouldShowBatchActions: isSelected
        }, _this3.setAllSelectedState(state, isSelected));
      });
    }
  });
  Object.defineProperty(this, "handleOnSelectRow", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(rowId) {
      return function () {
        _this3.setState(function (state) {
          var row = state.rowsById[rowId];
          var selectedRows = state.rowIds.filter(function (id) {
            return state.rowsById[id].isSelected;
          }).length; // Predict the length of the selected rows after this change occurs

          var selectedRowsCount = !row.isSelected ? selectedRows + 1 : selectedRows - 1;
          return {
            // Basic assumption here is that we want to show the batch action bar if
            // the row is being selected. If it's being unselected, then see if we
            // have a non-zero number of selected rows that batch actions could
            // still apply to
            shouldShowBatchActions: !row.isSelected || selectedRowsCount > 0,
            rowsById: _extends({}, state.rowsById, _defineProperty({}, rowId, _extends({}, row, {
              isSelected: !row.isSelected
            })))
          };
        });
      };
    }
  });
  Object.defineProperty(this, "handleOnExpandRow", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(rowId) {
      return function () {
        _this3.setState(function (state) {
          var row = state.rowsById[rowId];
          return {
            rowsById: _extends({}, state.rowsById, _defineProperty({}, rowId, _extends({}, row, {
              isExpanded: !row.isExpanded
            })))
          };
        });
      };
    }
  });
  Object.defineProperty(this, "handleSortBy", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(headerKey) {
      return function () {
        _this3.setState(function (state) {
          return getNextSortState(_this3.props, state, {
            key: headerKey
          });
        });
      };
    }
  });
  Object.defineProperty(this, "handleOnInputValueChange", {
    configurable: true,
    enumerable: true,
    writable: true,
    value: function value(event) {
      _this3.setState({
        filterInputValue: event.target.value
      });
    }
  });
};

export { DataTable as default };