import { DocumentNode, GraphQLError } from 'graphql';
import { QueryStoreValue } from '../data/queries';
import { NetworkStatus } from './networkStatus';
import { FetchResult } from 'apollo-link';
export declare type QueryListener = (queryStoreValue: QueryStoreValue, newData?: any) => void;
export declare type OperationVariables = {
    [key: string]: any;
};
export declare type PureQueryOptions = {
    query: DocumentNode;
    variables?: {
        [key: string]: any;
    };
    context?: any;
};
export declare type ApolloQueryResult<T> = {
    data: T;
    errors?: GraphQLError[];
    loading: boolean;
    networkStatus: NetworkStatus;
    stale: boolean;
};
export declare enum FetchType {
    normal = 1,
    refetch = 2,
    poll = 3
}
export declare type MutationQueryReducer<T> = (previousResult: Record<string, any>, options: {
    mutationResult: FetchResult<T>;
    queryName: string | undefined;
    queryVariables: Record<string, any>;
}) => Record<string, any>;
export declare type MutationQueryReducersMap<T = {
    [key: string]: any;
}> = {
    [queryName: string]: MutationQueryReducer<T>;
};
//# sourceMappingURL=types.d.ts.map